/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.sampling.distribution;

import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.InternalUtils;
import org.apache.commons.rng.sampling.distribution.NormalizedGaussianSampler;
import org.apache.commons.rng.sampling.distribution.SharedStateContinuousSampler;

public class BoxMullerNormalizedGaussianSampler
implements NormalizedGaussianSampler,
SharedStateContinuousSampler {
    private double nextGaussian = Double.NaN;
    private final UniformRandomProvider rng;

    public BoxMullerNormalizedGaussianSampler(UniformRandomProvider rng) {
        this.rng = rng;
    }

    @Override
    public double sample() {
        double random;
        if (Double.isNaN(this.nextGaussian)) {
            double x = this.rng.nextDouble();
            double y = InternalUtils.makeNonZeroDouble(this.rng.nextLong());
            double alpha = Math.PI * 2 * x;
            double r = Math.sqrt(-2.0 * Math.log(y));
            random = r * Math.cos(alpha);
            this.nextGaussian = r * Math.sin(alpha);
        } else {
            random = this.nextGaussian;
            this.nextGaussian = Double.NaN;
        }
        return random;
    }

    public String toString() {
        return "Box-Muller normalized Gaussian deviate [" + this.rng.toString() + "]";
    }

    @Override
    public SharedStateContinuousSampler withUniformRandomProvider(UniformRandomProvider rng) {
        return new BoxMullerNormalizedGaussianSampler(rng);
    }

    public static <S extends NormalizedGaussianSampler & SharedStateContinuousSampler> S of(UniformRandomProvider rng) {
        return (S)new BoxMullerNormalizedGaussianSampler(rng);
    }
}

