/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.simple.internal;

import org.apache.commons.rng.core.util.NumberFactory;
import org.apache.commons.rng.simple.internal.Conversions;
import org.apache.commons.rng.simple.internal.SeedFactory;

public enum NativeSeedType {
    INT((Class)Integer.class, 4){

        @Override
        public Integer createSeed(int size, int from, int to) {
            return SeedFactory.createInt();
        }

        @Override
        protected Integer convert(Integer seed, int size) {
            return seed;
        }

        @Override
        protected Integer convert(Long seed, int size) {
            return Conversions.long2Int(seed);
        }

        @Override
        protected Integer convert(int[] seed, int size) {
            return Conversions.intArray2Int(seed);
        }

        @Override
        protected Integer convert(long[] seed, int size) {
            return Conversions.longArray2Int(seed);
        }

        @Override
        protected Integer convert(byte[] seed, int size) {
            return Conversions.byteArray2Int(seed);
        }
    }
    ,
    LONG((Class)Long.class, 8){

        @Override
        public Long createSeed(int size, int from, int to) {
            return SeedFactory.createLong();
        }

        @Override
        protected Long convert(Integer seed, int size) {
            return Conversions.int2Long(seed);
        }

        @Override
        protected Long convert(Long seed, int size) {
            return seed;
        }

        @Override
        protected Long convert(int[] seed, int size) {
            return Conversions.intArray2Long(seed);
        }

        @Override
        protected Long convert(long[] seed, int size) {
            return Conversions.longArray2Long(seed);
        }

        @Override
        protected Long convert(byte[] seed, int size) {
            return Conversions.byteArray2Long(seed);
        }
    }
    ,
    INT_ARRAY((Class)int[].class, 4){

        public int[] createSeed(int size, int from, int to) {
            return SeedFactory.createIntArray(Math.min(size, 128), from, to);
        }

        protected int[] convert(Integer seed, int size) {
            return Conversions.int2IntArray(seed, size);
        }

        protected int[] convert(Long seed, int size) {
            return Conversions.long2IntArray(seed, size);
        }

        protected int[] convert(int[] seed, int size) {
            return seed;
        }

        protected int[] convert(long[] seed, int size) {
            return Conversions.longArray2IntArray(seed, Math.min(size, Conversions.intSizeFromLongSize(seed.length)));
        }

        protected int[] convert(byte[] seed, int size) {
            return Conversions.byteArray2IntArray(seed, Math.min(size, Conversions.intSizeFromByteSize(seed.length)));
        }
    }
    ,
    LONG_ARRAY((Class)long[].class, 8){

        public long[] createSeed(int size, int from, int to) {
            return SeedFactory.createLongArray(Math.min(size, 128), from, to);
        }

        protected long[] convert(Integer seed, int size) {
            return Conversions.int2LongArray(seed, size);
        }

        protected long[] convert(Long seed, int size) {
            return Conversions.long2LongArray(seed, size);
        }

        protected long[] convert(int[] seed, int size) {
            return Conversions.intArray2LongArray(seed, Math.min(size, Conversions.longSizeFromIntSize(seed.length)));
        }

        protected long[] convert(long[] seed, int size) {
            return seed;
        }

        protected long[] convert(byte[] seed, int size) {
            return Conversions.byteArray2LongArray(seed, Math.min(size, Conversions.longSizeFromByteSize(seed.length)));
        }
    };

    private static final String UNRECOGNISED_SEED = "Unrecognized seed type: ";
    private static final int RANDOM_SEED_ARRAY_SIZE = 128;
    private final Class<?> type;
    private final int bytes;

    private NativeSeedType(Class<?> type, int bytes) {
        this.type = type;
        this.bytes = bytes;
    }

    public Class<?> getType() {
        return this.type;
    }

    public int getBytes() {
        return this.bytes;
    }

    public Object createSeed(int size) {
        return this.createSeed(size, 0, Math.min(size, 1));
    }

    public abstract Object createSeed(int var1, int var2, int var3);

    public Object convertSeed(Object seed, int size) {
        if (seed instanceof Integer) {
            return this.convert((Integer)seed, size);
        }
        if (seed instanceof Long) {
            return this.convert((Long)seed, size);
        }
        if (seed instanceof int[]) {
            return this.convert((int[])seed, size);
        }
        if (seed instanceof long[]) {
            return this.convert((long[])seed, size);
        }
        if (seed instanceof byte[]) {
            return this.convert((byte[])seed, size);
        }
        throw new UnsupportedOperationException(NativeSeedType.unrecognisedSeedMessage(seed));
    }

    protected abstract Object convert(Integer var1, int var2);

    protected abstract Object convert(Long var1, int var2);

    protected abstract Object convert(int[] var1, int var2);

    protected abstract Object convert(long[] var1, int var2);

    protected abstract Object convert(byte[] var1, int var2);

    public static byte[] convertSeedToBytes(Object seed) {
        if (seed instanceof Integer) {
            return NumberFactory.makeByteArray((int)((Integer)seed));
        }
        if (seed instanceof Long) {
            return NumberFactory.makeByteArray((long)((Long)seed));
        }
        if (seed instanceof int[]) {
            return NumberFactory.makeByteArray((int[])((int[])seed));
        }
        if (seed instanceof long[]) {
            return NumberFactory.makeByteArray((long[])((long[])seed));
        }
        if (seed instanceof byte[]) {
            return (byte[])seed;
        }
        throw new UnsupportedOperationException(NativeSeedType.unrecognisedSeedMessage(seed));
    }

    private static String unrecognisedSeedMessage(Object seed) {
        return UNRECOGNISED_SEED + (seed == null ? "null" : seed.getClass().getName());
    }
}

