/*
 * Decompiled with CFR 0.152.
 */
package org.meteothink.imep.verification;

import java.util.HashMap;
import java.util.Map;
import org.meteothink.imep.verification.MethodType;
import org.meteothink.imep.verification.VerifyTable;

public class MultiCategoryTable
extends VerifyTable {
    private int[][] _values;

    public int[][] getValues() {
        return this._values;
    }

    public void setValues(int[][] value) {
        this._values = value;
    }

    public int getCategoryNum() {
        return this._values.length;
    }

    public int getTotal() {
        int n = 0;
        int len = this.getCategoryNum();
        for (int i = 0; i < len; ++i) {
            for (int j = 0; j < len; ++j) {
                n += this._values[i][j];
            }
        }
        return n;
    }

    public int getFitNum() {
        int n = 0;
        int len = this.getCategoryNum();
        for (int i = 0; i < len; ++i) {
            n += this._values[i][i];
        }
        return n;
    }

    public int getFcstCategoryNum(int idx) {
        int n = 0;
        int len = this.getCategoryNum();
        for (int i = 0; i < len; ++i) {
            n += this._values[idx][i];
        }
        return n;
    }

    public int getObsCategoryNum(int idx) {
        int n = 0;
        int len = this.getCategoryNum();
        for (int i = 0; i < len; ++i) {
            n += this._values[i][idx];
        }
        return n;
    }

    public float getAccuracy() {
        int nfit = this.getFitNum();
        int n = this.getTotal();
        return (float)nfit / (float)n;
    }

    public float getHSS() {
        float accuracy = this.getAccuracy();
        int n = this.getTotal();
        int sum = 0;
        int len = this.getCategoryNum();
        for (int i = 0; i < len; ++i) {
            sum += this.getFcstCategoryNum(i) * this.getObsCategoryNum(i);
        }
        float tt = (float)sum / (float)(n * n);
        return (accuracy - tt) / (1.0f - tt);
    }

    public float getHK() {
        float accuracy = this.getAccuracy();
        int n = this.getTotal();
        int sum = 0;
        int sum1 = 0;
        int len = this.getCategoryNum();
        for (int i = 0; i < len; ++i) {
            sum += this.getFcstCategoryNum(i) * this.getObsCategoryNum(i);
            sum1 += this.getObsCategoryNum(i) * this.getObsCategoryNum(i);
        }
        float tt = (float)sum / (float)(n * n);
        float tt1 = (float)sum1 / (float)(n * n);
        return (accuracy - tt) / (1.0f - tt1);
    }

    @Override
    public Map getVerifyResult() {
        HashMap<String, Float> map = new HashMap<String, Float>();
        map.put("Accuracy", Float.valueOf(this.getAccuracy()));
        map.put("HSS", Float.valueOf(this.getHSS()));
        map.put("HK", Float.valueOf(this.getHK()));
        return map;
    }

    @Override
    public MethodType getMethodType() {
        return MethodType.MULTICATEGORY;
    }

    @Override
    public String getScoreNames() {
        return "Accuracy,HSS,HK";
    }
}

