/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.intern;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.event.CVetoClosingEvent;
import bibliothek.gui.dock.common.event.CVetoClosingListener;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.common.intern.CommonDockable;
import bibliothek.gui.dock.event.VetoableDockFrontendEvent;
import bibliothek.gui.dock.event.VetoableDockFrontendListener;
import java.util.ArrayList;

public class ControlVetoClosingListener
implements VetoableDockFrontendListener {
    private CControl control;
    private CVetoClosingListener callback;

    public ControlVetoClosingListener(CControl control, CVetoClosingListener callback) {
        this.control = control;
        this.callback = callback;
    }

    public void hidden(VetoableDockFrontendEvent event) {
        CDockable[] dockables = this.getCDockables(event);
        if (dockables != null && dockables.length > 0) {
            this.callback.closed(new CVetoClosingEvent(this.control, event, dockables));
        }
    }

    public void hiding(VetoableDockFrontendEvent event) {
        CDockable[] dockables = this.getCDockables(event);
        if (dockables != null && dockables.length > 0) {
            this.callback.closing(new CVetoClosingEvent(this.control, event, dockables));
        }
    }

    protected CDockable[] getCDockables(VetoableDockFrontendEvent event) {
        ArrayList<CDockable> list = new ArrayList<CDockable>();
        for (Dockable dockable : event) {
            if (!(dockable instanceof CommonDockable)) continue;
            list.add(((CommonDockable)dockable).getDockable());
        }
        return list.toArray(new CDockable[list.size()]);
    }

    public void showing(VetoableDockFrontendEvent event) {
    }

    public void shown(VetoableDockFrontendEvent event) {
    }
}

