/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.intern.ui;

import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.event.CControlListener;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.util.UIBridge;
import bibliothek.gui.dock.util.UIValue;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class UITransmitter<V, U extends UIValue<V>>
implements UIBridge<V, U> {
    private CControl control;
    private Set<String> keys = new HashSet<String>();
    private Map<String, List<U>> values = new HashMap<String, List<U>>();
    private Listener listener = new Listener();

    public UITransmitter(String ... keys) {
        for (String key : keys) {
            this.keys.add(key);
        }
    }

    public void add(String id, U value) {
        if (this.keys.contains(id)) {
            boolean empty = this.values.isEmpty();
            List<U> list = this.values.get(id);
            if (list == null) {
                list = new LinkedList<U>();
                this.values.put(id, list);
            }
            list.add(value);
            if (empty) {
                this.setListening(true);
            }
        }
    }

    public void remove(String id, U value) {
        if (this.keys.contains(id)) {
            boolean empty = this.values.isEmpty();
            List<U> list = this.values.get(id);
            list.remove(value);
            if (list.isEmpty()) {
                this.values.remove(id);
            }
            if (!empty && this.values.isEmpty()) {
                this.setListening(false);
            }
        }
    }

    public void setControl(CControl control) {
        if (!this.values.isEmpty()) {
            this.setListening(false);
        }
        this.control = control;
        if (!this.values.isEmpty()) {
            this.setListening(true);
        }
    }

    private void setListening(boolean listening) {
        block4: {
            if (this.control == null) break block4;
            if (listening) {
                this.control.addControlListener(this.listener);
                int n = this.control.getCDockableCount();
                for (int i = 0; i < n; ++i) {
                    this.connect(this.control.getCDockable(i));
                }
            } else {
                this.control.removeControlListener(this.listener);
                int n = this.control.getCDockableCount();
                for (int i = 0; i < n; ++i) {
                    this.disconnect(this.control.getCDockable(i));
                }
            }
        }
    }

    public void set(String id, V value, U observer) {
        if (this.keys.contains(id)) {
            value = this.get(value, id, observer);
        }
        observer.set(value);
    }

    protected abstract V get(V var1, String var2, U var3);

    protected abstract void update(CDockable var1, String var2, V var3);

    protected abstract CDockable getDockable(U var1);

    protected void set(String id, V value, CDockable dockable) {
        List<U> list = this.values.get(id);
        if (list != null) {
            for (UIValue observer : list) {
                if (dockable != this.getDockable(observer)) continue;
                observer.set(value);
            }
        }
    }

    protected abstract void connect(CDockable var1);

    protected abstract void disconnect(CDockable var1);

    private class Listener
    implements CControlListener {
        private Listener() {
        }

        @Override
        public void added(CControl control, CDockable dockable) {
        }

        @Override
        public void removed(CControl control, CDockable dockable) {
        }

        @Override
        public void closed(CControl control, CDockable dockable) {
            UITransmitter.this.disconnect(dockable);
        }

        @Override
        public void opened(CControl control, CDockable dockable) {
            UITransmitter.this.connect(dockable);
        }
    }
}

