/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.console.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.fife.ui.rsyntaxtextarea.SyntaxScheme;
import org.fife.ui.rsyntaxtextarea.TextEditorPane;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;
import org.meteoinfo.console.editor.MITextEditorPane;

public class TextEditor
extends JPanel {
    private MITextEditorPane _textArea;
    private String _title;
    private File _file = null;
    private Font font;
    private JTabbedPane _parent;

    public TextEditor(JTabbedPane parent, String title) {
        this.setLayout(new BorderLayout());
        this._title = title;
        this._parent = parent;
        this._textArea = new MITextEditorPane();
        this._textArea.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                TextEditor.this.checkUpdate();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                TextEditor.this.checkUpdate();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                TextEditor.this.checkUpdate();
            }
        });
        this._textArea.setCodeFoldingEnabled(true);
        this._textArea.setAntiAliasingEnabled(true);
        this._textArea.setEncoding("utf-8");
        this._textArea.setTabSize(4);
        this._textArea.setTabsEmulated(true);
        this._textArea.setMarkOccurrences(true);
        RTextScrollPane sp = new RTextScrollPane((RTextArea)this._textArea);
        sp.setFoldIndicatorEnabled(true);
        this.add((Component)sp);
    }

    public TextEditorPane getTextArea() {
        return this._textArea;
    }

    public String getTitle() {
        return this._title;
    }

    public void setTitle(String value) {
        int idx = this._parent.indexOfComponent(this);
        this._title = value;
        this._parent.setTitleAt(idx, this._title);
    }

    public File getFile() {
        return this._file;
    }

    public void setFile(File file) {
        this._file = file;
        this.setTitle(this._file.getName());
    }

    public String getFileName() {
        if (this._file == null) {
            return "";
        }
        return this._file.getAbsolutePath();
    }

    public void openFile(File file) {
        if (file.isDirectory()) {
            JOptionPane.showMessageDialog(this, file.getAbsolutePath() + " is a directory", "Error", 0);
            return;
        }
        if (!file.isFile()) {
            JOptionPane.showMessageDialog(this, "No such file: " + file.getAbsolutePath(), "Error", 0);
            return;
        }
        try {
            BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            this._textArea.read(r, null);
            r.close();
            this.setFile(file);
            this._textArea.discardAllEdits();
            this._textArea.setDirty(false);
        }
        catch (IOException ioe) {
            UIManager.getLookAndFeel().provideErrorFeedback((Component)((Object)this._textArea));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveFile(File file) {
        OutputStreamWriter w = null;
        try {
            w = new OutputStreamWriter((OutputStream)new FileOutputStream(file.getAbsolutePath()), "UTF-8");
            this._textArea.write(w);
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(TextEditor.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(TextEditor.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                w.close();
                this.setFile(file);
                this._textArea.setDirty(false);
                this.checkUpdate();
            }
            catch (IOException ex) {
                Logger.getLogger(TextEditor.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void checkUpdate() {
        String title = this._title;
        if (this._title.substring(this._title.length() - 1).equals("*")) {
            this._title = this._title.substring(0, this._title.length() - 1);
        }
        if (this._textArea.isDirty()) {
            this._title = this._title + '*';
        }
        if (!title.equals(this._title)) {
            int idx = this._parent.indexOfComponent(this);
            this._parent.setTitleAt(idx, this._title);
        }
    }

    public void setTextFont(Font font) {
        if (font != null) {
            this.font = font;
            SyntaxScheme ss = this._textArea.getSyntaxScheme();
            ss = (SyntaxScheme)ss.clone();
            for (int i = 0; i < ss.getStyleCount(); ++i) {
                if (ss.getStyle(i) == null) continue;
                ss.getStyle((int)i).font = font;
            }
            this._textArea.setSyntaxScheme(ss);
            this._textArea.setFont(font);
        }
    }

    public void updateTextFont() {
        if (this.font != null) {
            SyntaxScheme ss = this._textArea.getSyntaxScheme();
            ss = (SyntaxScheme)ss.clone();
            for (int i = 0; i < ss.getStyleCount(); ++i) {
                if (ss.getStyle(i) == null) continue;
                ss.getStyle((int)i).font = this.font;
            }
            this._textArea.setSyntaxScheme(ss);
            this._textArea.setFont(this.font);
        }
    }
}

