/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.geometry.geoprocess;

import java.util.ArrayList;
import java.util.List;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.meteoinfo.common.Extent;
import org.meteoinfo.common.Extent3D;
import org.meteoinfo.common.PointD;
import org.meteoinfo.common.PointF;
import org.meteoinfo.geometry.geoprocess.GeoComputation;
import org.meteoinfo.geometry.shape.PointZ;
import org.meteoinfo.geometry.shape.Polygon;
import org.meteoinfo.geometry.shape.PolygonShape;
import org.meteoinfo.geometry.shape.PolygonZShape;
import org.meteoinfo.geometry.shape.Polyline;
import org.meteoinfo.geometry.shape.PolylineShape;
import org.meteoinfo.geometry.shape.PolylineZShape;
import org.meteoinfo.geometry.shape.Shape;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.DataType;
import org.meteoinfo.ndarray.IndexIterator;

public class GeometryUtil {
    public static Extent getPointsExtent(List<? extends PointD> PList) {
        if (PList.get(0) instanceof PointZ) {
            Extent3D cET = new Extent3D();
            for (int i = 0; i < PList.size(); ++i) {
                PointZ aP = (PointZ)PList.get(i);
                if (i == 0) {
                    cET.minX = aP.X;
                    cET.maxX = aP.X;
                    cET.minY = aP.Y;
                    cET.maxY = aP.Y;
                    cET.minZ = aP.Z;
                    cET.maxZ = aP.Z;
                    continue;
                }
                if (cET.minX > aP.X) {
                    cET.minX = aP.X;
                } else if (cET.maxX < aP.X) {
                    cET.maxX = aP.X;
                }
                if (cET.minY > aP.Y) {
                    cET.minY = aP.Y;
                } else if (cET.maxY < aP.Y) {
                    cET.maxY = aP.Y;
                }
                if (cET.minZ > aP.Z) {
                    cET.minZ = aP.Z;
                    continue;
                }
                if (!(cET.maxZ < aP.Z)) continue;
                cET.maxZ = aP.Z;
            }
            return cET;
        }
        Extent cET = null;
        for (int i = 0; i < PList.size(); ++i) {
            PointD aP = PList.get(i);
            if (Double.isInfinite(aP.X) || Double.isInfinite(aP.Y)) continue;
            if (cET == null) {
                cET = new Extent(aP.X, aP.X, aP.Y, aP.Y);
                continue;
            }
            if (cET.minX > aP.X) {
                cET.minX = aP.X;
            } else if (cET.maxX < aP.X) {
                cET.maxX = aP.X;
            }
            if (cET.minY > aP.Y) {
                cET.minY = aP.Y;
                continue;
            }
            if (!(cET.maxY < aP.Y)) continue;
            cET.maxY = aP.Y;
        }
        return cET;
    }

    public static Extent getExtent(List<? extends Shape> shapes) {
        Extent extent = (Extent)shapes.get(0).getExtent().clone();
        double minx = extent.minX;
        double maxx = extent.maxX;
        double miny = extent.minY;
        double maxy = extent.maxY;
        for (int i = 1; i < shapes.size(); ++i) {
            Extent ext = shapes.get(i).getExtent();
            if (minx > ext.minX) {
                minx = ext.minX;
            }
            if (maxx < ext.maxX) {
                maxx = ext.maxX;
            }
            if (miny > ext.minY) {
                miny = ext.minY;
            }
            if (!(maxy < ext.maxY)) continue;
            maxy = ext.maxY;
        }
        extent.minX = minx;
        extent.maxX = maxx;
        extent.minY = miny;
        extent.maxY = maxy;
        return extent;
    }

    public static Extent3D getExtent(PointZ[] points) {
        PointZ p = points[0];
        double minx = p.X;
        double maxx = p.X;
        double miny = p.Y;
        double maxy = p.Y;
        double minz = p.Z;
        double maxz = p.Z;
        for (int i = 1; i < points.length; ++i) {
            p = points[i];
            if (minx > p.X) {
                minx = p.X;
            }
            if (maxx < p.X) {
                maxx = p.X;
            }
            if (miny > p.Y) {
                miny = p.Y;
            }
            if (maxy < p.Y) {
                maxy = p.Y;
            }
            if (minz > p.Z) {
                minz = p.Z;
            }
            if (!(maxz < p.Z)) continue;
            maxz = p.Z;
        }
        Extent3D extent = new Extent3D();
        extent.minX = minx;
        extent.maxX = maxx;
        extent.minY = miny;
        extent.maxY = maxy;
        extent.minZ = minz;
        extent.maxZ = maxz;
        return extent;
    }

    public static Extent getExtent(PointF[] points) {
        PointF p = points[0];
        double minx = p.X;
        double maxx = p.X;
        double miny = p.Y;
        double maxy = p.Y;
        for (int i = 1; i < points.length; ++i) {
            p = points[i];
            if (minx > (double)p.X) {
                minx = p.X;
            }
            if (maxx < (double)p.X) {
                maxx = p.X;
            }
            if (miny > (double)p.Y) {
                miny = p.Y;
            }
            if (!(maxy < (double)p.Y)) continue;
            maxy = p.Y;
        }
        Extent extent = new Extent();
        extent.minX = minx;
        extent.maxX = maxx;
        extent.minY = miny;
        extent.maxY = maxy;
        return extent;
    }

    public static PointD getEllipseXY(double x0, double y0, double a, double b, double angle) {
        double rangle = Math.toRadians(angle);
        double x = a * b / Math.sqrt(b * b + a * a * Math.tan(rangle) * Math.tan(rangle));
        if (angle > 90.0 && angle < 270.0) {
            x = -x;
        }
        double y = Math.tan(rangle) * x;
        if (angle > 0.0 && angle < 180.0) {
            y = -Math.abs(y);
        }
        return new PointD(x + x0, y + y0);
    }

    public static List<PointD> getEllipseCoordinates(double x0, double y0, double a, double b, double deltaAngle) {
        ArrayList<PointD> points = new ArrayList<PointD>();
        for (double angle = 0.0; angle <= 360.0; angle += deltaAngle) {
            points.add(GeometryUtil.getEllipseXY(x0, y0, a, b, angle));
        }
        return points;
    }

    public static List<PointD> getEllipseCoordinates(double x0, double y0, double a, double b) {
        ArrayList<PointD> points = new ArrayList<PointD>();
        double deltaAngle = 1.0;
        for (double angle = 0.0; angle <= 360.0; angle += deltaAngle) {
            points.add(GeometryUtil.getEllipseXY(x0, y0, a, b, angle));
        }
        return points;
    }

    public static PolygonShape convexHull(Array x, Array y) {
        int n = (int)x.getSize();
        ArrayList<Point> geos = new ArrayList<Point>();
        GeometryFactory factory = new GeometryFactory();
        IndexIterator xIter = x.getIndexIterator();
        IndexIterator yIter = y.getIndexIterator();
        while (xIter.hasNext()) {
            double xx = xIter.getDoubleNext();
            double yy = yIter.getDoubleNext();
            if (Double.isNaN(xx) || Double.isNaN(yy)) continue;
            Coordinate c = new Coordinate(xx, yy);
            geos.add(factory.createPoint(c));
        }
        GeometryCollection gs = factory.createGeometryCollection(geos.toArray(new Geometry[geos.size()]));
        Geometry ch = gs.convexHull();
        return new PolygonShape(ch);
    }

    public static Array inPolygon(Array a, List<Number> x, List<Number> y, PolygonShape ps) {
        ArrayList<PolygonShape> polygons = new ArrayList<PolygonShape>();
        polygons.add(ps);
        return GeometryUtil.inPolygon(a, x, y, polygons);
    }

    public static Array inPolygon(Array a, List<Number> x, List<Number> y, List<PolygonShape> polygons) {
        if (a.getRank() == 2) {
            int xNum = x.size();
            int yNum = y.size();
            Array r = Array.factory((DataType)DataType.INT, (int[])a.getShape());
            for (int i = 0; i < yNum; ++i) {
                for (int j = 0; j < xNum; ++j) {
                    if (GeoComputation.pointInPolygons(polygons, new PointD(x.get(j).doubleValue(), y.get(i).doubleValue()))) {
                        r.setInt(i * xNum + j, 1);
                        continue;
                    }
                    r.setInt(i * xNum + j, -1);
                }
            }
            return r;
        }
        if (a.getRank() == 1) {
            int n = x.size();
            Array r = Array.factory((DataType)DataType.INT, (int[])a.getShape());
            for (int i = 0; i < n; ++i) {
                if (GeoComputation.pointInPolygons(polygons, new PointD(x.get(i).doubleValue(), y.get(i).doubleValue()))) {
                    r.setInt(i, 1);
                    continue;
                }
                r.setInt(i, -1);
            }
            return r;
        }
        return null;
    }

    public static Array inPolygon(Array x, Array y, List<PolygonShape> polygons) {
        Array r = Array.factory((DataType)DataType.BOOLEAN, (int[])x.getShape());
        IndexIterator xIter = x.getIndexIterator();
        IndexIterator yIter = y.getIndexIterator();
        IndexIterator rIter = r.getIndexIterator();
        while (rIter.hasNext()) {
            if (GeoComputation.pointInPolygons(polygons, new PointD(xIter.getDoubleNext(), yIter.getDoubleNext()))) {
                rIter.setBooleanNext(true);
                continue;
            }
            rIter.setBooleanNext(false);
        }
        return r;
    }

    public static Array inPolygon(Array a, List<Number> x, List<Number> y, List<Number> x_p, List<Number> y_p) {
        PolygonShape ps = new PolygonShape();
        ArrayList<PointD> points = new ArrayList<PointD>();
        for (int i = 0; i < x_p.size(); ++i) {
            points.add(new PointD(x_p.get(i).doubleValue(), y_p.get(i).doubleValue()));
        }
        ps.setPoints(points);
        ArrayList<PolygonShape> shapes = new ArrayList<PolygonShape>();
        shapes.add(ps);
        return GeometryUtil.inPolygon(a, x, y, shapes);
    }

    public static Array inPolygon(Array x, Array y, Array x_p, Array y_p) {
        PolygonShape ps = new PolygonShape();
        ArrayList<PointD> points = new ArrayList<PointD>();
        IndexIterator xIter = x_p.getIndexIterator();
        IndexIterator yIter = y_p.getIndexIterator();
        while (xIter.hasNext()) {
            points.add(new PointD(xIter.getDoubleNext(), yIter.getDoubleNext()));
        }
        ps.setPoints(points);
        ArrayList<PolygonShape> shapes = new ArrayList<PolygonShape>();
        shapes.add(ps);
        return GeometryUtil.inPolygon(x, y, shapes);
    }

    public static Array polygonIndex(Array x, Array y, List<PolygonShape> polygons) {
        Array r = Array.factory((DataType)DataType.INT, (int[])x.getShape());
        IndexIterator xIter = x.getIndexIterator();
        IndexIterator yIter = y.getIndexIterator();
        IndexIterator rIter = r.getIndexIterator();
        while (rIter.hasNext()) {
            int idx = GeoComputation.polygonIndex(polygons, new PointD(xIter.getDoubleNext(), yIter.getDoubleNext()));
            rIter.setIntNext(idx);
        }
        return r;
    }

    public static Array maskout(Array a, List<Number> x, List<Number> y, PolygonShape polygon, Number missingValue) {
        ArrayList<PolygonShape> polygons = new ArrayList<PolygonShape>();
        polygons.add(polygon);
        return GeometryUtil.maskout(a, x, y, polygons, missingValue);
    }

    public static Array maskout(Array a, Array x, Array y, List<PolygonShape> polygons) {
        Array r = Array.factory((DataType)a.getDataType(), (int[])a.getShape());
        IndexIterator aIter = a.getIndexIterator();
        IndexIterator xIter = x.getIndexIterator();
        IndexIterator yIter = y.getIndexIterator();
        int i = 0;
        while (aIter.hasNext()) {
            if (GeoComputation.pointInPolygons(polygons, new PointD(xIter.getDoubleNext(), yIter.getDoubleNext()))) {
                r.setObject(i, aIter.getObjectNext());
            } else {
                r.setObject(i, (Object)Double.NaN);
                aIter.next();
            }
            ++i;
        }
        return r;
    }

    public static Array maskin(Array a, Array x, Array y, List<PolygonShape> polygons) {
        Array r = Array.factory((DataType)a.getDataType(), (int[])a.getShape());
        IndexIterator aIter = a.getIndexIterator();
        IndexIterator xIter = x.getIndexIterator();
        IndexIterator yIter = y.getIndexIterator();
        int i = 0;
        while (aIter.hasNext()) {
            if (GeoComputation.pointInPolygons(polygons, new PointD(xIter.getDoubleNext(), yIter.getDoubleNext()))) {
                r.setObject(i, (Object)Double.NaN);
                aIter.next();
            } else {
                r.setObject(i, aIter.getObjectNext());
            }
            ++i;
        }
        return r;
    }

    public static Array[] maskout_Remove(Array a, Array x, Array y, List<PolygonShape> polygons) {
        ArrayList<Double> rdata = new ArrayList<Double>();
        ArrayList<Double> rxdata = new ArrayList<Double>();
        ArrayList<Double> rydata = new ArrayList<Double>();
        IndexIterator aIter = a.getIndexIterator();
        IndexIterator xIter = x.getIndexIterator();
        IndexIterator yIter = y.getIndexIterator();
        while (aIter.hasNext()) {
            double vy;
            double va = aIter.getDoubleNext();
            double vx = xIter.getDoubleNext();
            if (!GeoComputation.pointInPolygons(polygons, new PointD(vx, vy = yIter.getDoubleNext()))) continue;
            rdata.add(va);
            rxdata.add(vx);
            rydata.add(vy);
        }
        int n = rdata.size();
        int[] shape = new int[]{n};
        Array r = Array.factory((DataType)a.getDataType(), (int[])shape);
        Array rx = Array.factory((DataType)x.getDataType(), (int[])shape);
        Array ry = Array.factory((DataType)y.getDataType(), (int[])shape);
        for (int i = 0; i < n; ++i) {
            r.setObject(i, rdata.get(i));
            rx.setDouble(i, ((Double)rxdata.get(i)).doubleValue());
            ry.setDouble(i, ((Double)rydata.get(i)).doubleValue());
        }
        return new Array[]{r, rx, ry};
    }

    public static Array[] maskin_Remove(Array a, Array x, Array y, List<PolygonShape> polygons) {
        ArrayList<Double> rdata = new ArrayList<Double>();
        ArrayList<Double> rxdata = new ArrayList<Double>();
        ArrayList<Double> rydata = new ArrayList<Double>();
        IndexIterator aIter = a.getIndexIterator();
        IndexIterator xIter = x.getIndexIterator();
        IndexIterator yIter = y.getIndexIterator();
        while (aIter.hasNext()) {
            double vy;
            double va = aIter.getDoubleNext();
            double vx = xIter.getDoubleNext();
            if (GeoComputation.pointInPolygons(polygons, new PointD(vx, vy = yIter.getDoubleNext()))) continue;
            rdata.add(va);
            rxdata.add(vx);
            rydata.add(vy);
        }
        int n = rdata.size();
        int[] shape = new int[]{n};
        Array r = Array.factory((DataType)a.getDataType(), (int[])shape);
        Array rx = Array.factory((DataType)x.getDataType(), (int[])shape);
        Array ry = Array.factory((DataType)y.getDataType(), (int[])shape);
        for (int i = 0; i < n; ++i) {
            r.setObject(i, rdata.get(i));
            rx.setDouble(i, ((Double)rxdata.get(i)).doubleValue());
            ry.setDouble(i, ((Double)rydata.get(i)).doubleValue());
        }
        return new Array[]{r, rx, ry};
    }

    public static Array maskout(Array a, List<Number> x, List<Number> y, List<PolygonShape> polygons) {
        return GeometryUtil.maskout(a, x, y, polygons, (Number)Double.NaN);
    }

    public static Array maskout(Array a, List<Number> x, List<Number> y, List<PolygonShape> polygons, Number missingValue) {
        Array r;
        block7: {
            IndexIterator iter;
            int yNum;
            int xNum;
            block6: {
                xNum = x.size();
                yNum = y.size();
                r = Array.factory((DataType)a.getDataType(), (int[])a.getShape());
                iter = a.getIndexIterator();
                if (a.getRank() != 1) break block6;
                int i = 0;
                while (iter.hasNext()) {
                    if (GeoComputation.pointInPolygons(polygons, new PointD(x.get(i).doubleValue(), y.get(i).doubleValue()))) {
                        r.setObject(i, iter.getObjectNext());
                    } else {
                        r.setObject(i, (Object)missingValue);
                        iter.next();
                    }
                    ++i;
                }
                break block7;
            }
            if (a.getRank() != 2) break block7;
            for (int i = 0; i < yNum; ++i) {
                for (int j = 0; j < xNum; ++j) {
                    int idx = i * xNum + j;
                    if (GeoComputation.pointInPolygons(polygons, new PointD(x.get(j).doubleValue(), y.get(i).doubleValue()))) {
                        r.setObject(idx, iter.getObjectNext());
                        continue;
                    }
                    r.setObject(idx, (Object)missingValue);
                    iter.next();
                }
            }
        }
        return r;
    }

    public static Array maskout(Array a, Array m, Number missingValue) {
        Array r = Array.factory((DataType)a.getDataType(), (int[])a.getShape());
        IndexIterator aIter = a.getIndexIterator();
        IndexIterator mIter = m.getIndexIterator();
        int i = 0;
        while (aIter.hasNext()) {
            double va = aIter.getDoubleNext();
            double vm = mIter.getDoubleNext();
            if (vm < 0.0) {
                r.setObject(i, (Object)missingValue);
            } else {
                r.setObject(i, (Object)va);
            }
            ++i;
        }
        return r;
    }

    public static Array maskout(Array a, Array m) {
        return GeometryUtil.maskout(a, m, Double.NaN);
    }

    public static Array maskin(Array a, Array m) {
        Array r = Array.factory((DataType)a.getDataType(), (int[])a.getShape());
        IndexIterator aIter = a.getIndexIterator();
        IndexIterator mIter = m.getIndexIterator();
        int i = 0;
        while (aIter.hasNext()) {
            double va = aIter.getDoubleNext();
            double vm = mIter.getDoubleNext();
            if (vm < 0.0) {
                r.setObject(i, (Object)va);
            } else {
                r.setObject(i, (Object)Double.NaN);
            }
            ++i;
        }
        return r;
    }

    public static boolean isConvex(List<? extends PointD> points) {
        if (points.size() <= 5) {
            return true;
        }
        int sign = 0;
        for (int i = 0; i < points.size() - 1; ++i) {
            int s;
            PointD p0 = points.get(i == 0 ? points.size() - 2 : i - 1);
            PointD p1 = points.get(i);
            PointD p2 = points.get(i + 1);
            double dx1 = p1.X - p0.X;
            double dy1 = p1.Y - p0.Y;
            double dx2 = p2.X - p1.X;
            double dy2 = p2.Y - p2.Y;
            double z = dx1 * dy2 - dy1 * dx2;
            int n = s = z >= 0.0 ? 1 : -1;
            if (sign == 0) {
                sign = s;
                continue;
            }
            if (sign == s) continue;
            return false;
        }
        return true;
    }

    public static boolean isConvex(Polygon polygon) {
        return GeometryUtil.isConvex(polygon.getOutLine());
    }

    public static Array[] getCoordinates(PolygonShape pgs) {
        boolean isZ;
        int n = pgs.getPointNum() + pgs.getPartNum() - 1;
        int[] shape = new int[]{n};
        Array xArray = Array.factory((DataType)DataType.DOUBLE, (int[])shape);
        Array yArray = Array.factory((DataType)DataType.DOUBLE, (int[])shape);
        Array zArray = null;
        boolean bl = isZ = pgs instanceof PolygonZShape;
        if (isZ) {
            zArray = Array.factory((DataType)DataType.DOUBLE, (int[])shape);
        }
        int i = 0;
        for (Polygon polygon : pgs.getPolygons()) {
            for (List<? extends PointD> points : polygon.getRings()) {
                if (isZ) {
                    for (PointZ pointZ : points) {
                        xArray.setDouble(i, pointZ.X);
                        yArray.setDouble(i, pointZ.Y);
                        zArray.setDouble(i, pointZ.Z);
                        ++i;
                    }
                    if (i < n) {
                        xArray.setDouble(i, Double.NaN);
                        yArray.setDouble(i, Double.NaN);
                        zArray.setDouble(i, Double.NaN);
                    }
                } else {
                    for (PointD pointD : points) {
                        xArray.setDouble(i, pointD.X);
                        yArray.setDouble(i, pointD.Y);
                        ++i;
                    }
                    if (i < n) {
                        xArray.setDouble(i, Double.NaN);
                        yArray.setDouble(i, Double.NaN);
                    }
                }
                ++i;
            }
        }
        if (isZ) {
            return new Array[]{xArray, yArray, zArray};
        }
        return new Array[]{xArray, yArray};
    }

    public static Array[] getCoordinates(PolylineShape pls) {
        boolean isZ;
        int n = pls.getPointNum() + pls.getPartNum() - 1;
        int[] shape = new int[]{n};
        Array xArray = Array.factory((DataType)DataType.DOUBLE, (int[])shape);
        Array yArray = Array.factory((DataType)DataType.DOUBLE, (int[])shape);
        Array zArray = null;
        boolean bl = isZ = pls instanceof PolylineZShape;
        if (isZ) {
            zArray = Array.factory((DataType)DataType.DOUBLE, (int[])shape);
        }
        int i = 0;
        for (Polyline polyline : pls.getPolylines()) {
            if (isZ) {
                for (PointZ pointZ : polyline.getPointList()) {
                    xArray.setDouble(i, pointZ.X);
                    yArray.setDouble(i, pointZ.Y);
                    zArray.setDouble(i, pointZ.Z);
                    ++i;
                }
                if (i < n) {
                    xArray.setDouble(i, Double.NaN);
                    yArray.setDouble(i, Double.NaN);
                    zArray.setDouble(i, Double.NaN);
                }
            } else {
                for (PointD pointD : polyline.getPointList()) {
                    xArray.setDouble(i, pointD.X);
                    yArray.setDouble(i, pointD.Y);
                    ++i;
                }
                if (i < n) {
                    xArray.setDouble(i, Double.NaN);
                    yArray.setDouble(i, Double.NaN);
                }
            }
            ++i;
        }
        if (isZ) {
            return new Array[]{xArray, yArray, zArray};
        }
        return new Array[]{xArray, yArray};
    }
}

