/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.geometry.legend;

import java.awt.Color;
import java.util.HashMap;
import org.meteoinfo.common.colors.ColorUtil;
import org.meteoinfo.geometry.legend.BreakTypes;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ColorBreak {
    protected BreakTypes breakType = BreakTypes.COLOR_BREAK;
    protected Object startValue = 0;
    protected Object endValue = 0;
    protected Color color = Color.BLACK;
    protected String caption = "";
    protected boolean isNoData = false;
    protected boolean drawShape = true;
    protected String tag;

    public BreakTypes getBreakType() {
        return this.breakType;
    }

    public void setBreakType(BreakTypes value) {
        this.breakType = value;
    }

    public Object getStartValue() {
        return this.startValue;
    }

    public void setStartValue(Object value) {
        this.startValue = value;
    }

    public Object getEndValue() {
        return this.endValue;
    }

    public void setEndValue(Object value) {
        this.endValue = value;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color c) {
        this.color = c;
    }

    public String getCaption() {
        return this.caption;
    }

    public void setCaption(String value) {
        this.caption = value;
    }

    public boolean isNoData() {
        return this.isNoData;
    }

    public void setNoData(boolean isTrue) {
        this.isNoData = isTrue;
    }

    public boolean isDrawShape() {
        return this.drawShape;
    }

    public void setDrawShape(boolean isTrue) {
        this.drawShape = isTrue;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String value) {
        this.tag = value;
    }

    public Object getPropertyObject() {
        HashMap<String, String> objAttr = new HashMap<String, String>();
        objAttr.put("Color", "Color");
        return objAttr;
    }

    public Object clone() {
        ColorBreak aCB = new ColorBreak();
        aCB.setCaption(this.caption);
        aCB.setColor(this.color);
        aCB.setDrawShape(this.drawShape);
        aCB.setEndValue(this.endValue);
        aCB.setNoData(this.isNoData);
        aCB.setStartValue(this.startValue);
        aCB.setTag(this.tag);
        return aCB;
    }

    public void exportToXML(Document doc, Element parent) {
        Element brk = doc.createElement("Break");
        Attr captionAttr = doc.createAttribute("Caption");
        Attr startValueAttr = doc.createAttribute("StartValue");
        Attr endValueAttr = doc.createAttribute("EndValue");
        Attr colorAttr = doc.createAttribute("Color");
        Attr isNoDataAttr = doc.createAttribute("IsNoData");
        Attr tagAttr = doc.createAttribute("Tag");
        captionAttr.setValue(this.caption);
        startValueAttr.setValue(String.valueOf(this.startValue));
        endValueAttr.setValue(String.valueOf(this.endValue));
        colorAttr.setValue(ColorUtil.toHexEncoding((Color)this.color));
        isNoDataAttr.setValue(String.valueOf(this.isNoData));
        tagAttr.setValue(this.tag);
        brk.setAttributeNode(captionAttr);
        brk.setAttributeNode(startValueAttr);
        brk.setAttributeNode(endValueAttr);
        brk.setAttributeNode(colorAttr);
        brk.setAttributeNode(isNoDataAttr);
        brk.setAttributeNode(tagAttr);
        parent.appendChild(brk);
    }

    public String getValueString() {
        if (String.valueOf(this.startValue) == null ? String.valueOf(this.endValue) == null : String.valueOf(this.startValue).equals(String.valueOf(this.endValue))) {
            return String.valueOf(this.startValue);
        }
        return String.valueOf(this.startValue) + " - " + String.valueOf(this.endValue);
    }
}

