/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.gempak;

import com.google.re2j.Matcher;
import com.google.re2j.Pattern;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import ucar.nc2.iosp.gempak.GempakParameter;

public class GempakParameterTable {
    private HashMap<String, GempakParameter> paramMap = new HashMap(256);
    private HashMap<String, GempakParameter> templateParamMap = new HashMap(20);
    private static int[] indices = new int[]{0, 4, 38, 59, 72, 79, 90, 97};
    private static int[] lengths = new int[]{4, 33, 21, 13, 7, 11, 6, 6};

    public void addParameters(String tbl) throws IOException {
        try (InputStream is = this.getInputStream(tbl);){
            if (is == null) {
                throw new IOException("Unable to open " + tbl);
            }
            String content = this.readContents(is);
            String[] lines = content.split("\n");
            ArrayList<String[]> result = new ArrayList<String[]>();
            for (String line : lines) {
                String tline = line.trim();
                if (tline.isEmpty() || tline.startsWith("!")) continue;
                String[] words = new String[indices.length];
                for (int idx = 0; idx < indices.length; ++idx) {
                    if (indices[idx] >= tline.length()) continue;
                    words[idx] = indices[idx] + lengths[idx] > tline.length() ? line.substring(indices[idx]) : line.substring(indices[idx], indices[idx] + lengths[idx]);
                    words[idx] = words[idx].trim();
                }
                result.add(words);
            }
            for (String[] aResult : result) {
                GempakParameter p = this.makeParameter(aResult);
                if (p == null) continue;
                if (p.getName().contains("(")) {
                    this.templateParamMap.put(p.getName(), p);
                    continue;
                }
                this.paramMap.put(p.getName(), p);
            }
        }
    }

    private GempakParameter makeParameter(String[] words) {
        int decimalScale;
        int num = 0;
        if (words[0] != null) {
            num = (int)Double.parseDouble(words[0]);
        }
        if (words[3] == null || words[3].equals("")) {
            return null;
        }
        String name = words[3];
        if (name.contains("-")) {
            int first = name.indexOf("-");
            int last = name.lastIndexOf("-");
            StringBuilder buf = new StringBuilder(name.substring(0, first));
            buf.append("(");
            for (int i = first; i <= last; ++i) {
                buf.append("\\d");
            }
            buf.append(")");
            buf.append(name.substring(last + 1));
            name = buf.toString();
        }
        String description = words[1] == null || words[1].equals("") ? words[3] : words[1];
        String unit = words[2];
        if (unit != null && (unit = unit.replaceAll("\\*\\*", "")).equals("-")) {
            unit = "";
        }
        try {
            decimalScale = Integer.parseInt(words[4].trim());
        }
        catch (NumberFormatException ne) {
            decimalScale = 0;
        }
        return new GempakParameter(num, name, description, unit, decimalScale);
    }

    public GempakParameter getParameter(String name) {
        Set<String> keys;
        GempakParameter param = this.paramMap.get(name);
        if (param == null && !(keys = this.templateParamMap.keySet()).isEmpty()) {
            for (String key : keys) {
                Pattern p = Pattern.compile((String)key);
                Matcher m = p.matcher((CharSequence)name);
                if (!m.matches()) continue;
                String value = m.group(1);
                GempakParameter match = this.templateParamMap.get(key);
                param = new GempakParameter(match.getNumber(), name, match.getDescription() + " (" + value + " hour)", match.getUnit(), match.getDecimalScale());
                this.paramMap.put(name, param);
                break;
            }
        }
        return param;
    }

    private String readContents(InputStream is) throws IOException {
        return new String(this.readBytes(is), StandardCharsets.UTF_8);
    }

    private byte[] readBytes(InputStream is) throws IOException {
        int howMany;
        int totalRead = 0;
        byte[] content = new byte[1000000];
        while ((howMany = is.read(content, totalRead, content.length - totalRead)) >= 0) {
            if (howMany == 0 || (totalRead += howMany) < content.length) continue;
            byte[] tmp = content;
            int newLength = content.length < 25000000 ? content.length * 2 : content.length + 5000000;
            content = new byte[newLength];
            System.arraycopy(tmp, 0, content, 0, totalRead);
        }
        is.close();
        byte[] results = new byte[totalRead];
        System.arraycopy(content, 0, results, 0, totalRead);
        return results;
    }

    private InputStream getInputStream(String resourceName) throws IOException {
        ClassLoader cl = GempakParameterTable.class.getClassLoader();
        InputStream s = cl.getResourceAsStream(resourceName);
        if (s != null) {
            return s;
        }
        File f = new File(resourceName);
        if (f.exists()) {
            s = new FileInputStream(f);
        }
        if (s != null) {
            return s;
        }
        Matcher m = Pattern.compile((String)" ").matcher((CharSequence)resourceName);
        String encodedUrl = m.replaceAll("%20");
        URL dataUrl = new URL(encodedUrl);
        URLConnection connection = dataUrl.openConnection();
        return connection.getInputStream();
    }
}

