print 'Open data files...'
f_uwnd = addfile('D:/Temp/nc/uwnd.2011.nc')
f_vwnd = addfile('D:/Temp/nc/vwnd.2011.nc')

print 'Read data array...'
tidx = 173    # Jun 23, 2011
t = f_uwnd.gettime(tidx)
lidx = 1    # 1000 hPa
uwnd = f_uwnd['uwnd'][tidx,lidx,::-1,:]
vwnd = f_vwnd['vwnd'][tidx,lidx,::-1,:]
lon = f_uwnd['lon'][:]
lat = f_uwnd['lat'][:]
lon, lat = meshgrid(lon, lat)

# Calculate
print 'Calculate...'
vor = meteolib.vorticity(uwnd, vwnd)
dtx = meteolib.cdiff(vor, 1)
dty = meteolib.cdiff(vor, 0)
dx = meteolib.cdiff(lon, 1) * pi / 180
dy = meteolib.cdiff(lat, 0) * pi / 180
tadv = -1*((uwnd*dtx)/(cos(lat*pi/180)*dx)+vwnd*dty/dy)/6.37e6

#Plot
print 'Plot...'
axesm()
geoshow('country', edgecolor='k')
layer = contourf(tadv, cmap='grads_rainbow')
title('Vorticity advection (' + t.strftime('%Y-%m-%d') + ')')
colorbar(layer)
xlim(0, 360)
ylim(-90, 90)