x = arange(-5, 5, 0.01)
aa = [0, 0, 0, -2]
bb = [0.5, 1, 2, 1]
ss = ['-b', '-r', '-c', '-g']

#PDF
subplot(1,2,1)
for a,b,s in zip(aa,bb,ss):
    y = stats.cauchy.pdf(x, a, b)
    plot(x, y, s, linewidth=2, label=r'x = %.1f, y = %.1f' % (a, b))
grid(True)
legend(loc='upper left', facecolor='w')
ylim(0, 0.7)
xlim(-5, 5)
title('PDF')

#CDF
subplot(1,2,2)
for a,b,s in zip(aa,bb,ss):
    y = stats.cauchy.cdf(x, a, b)
    plot(x, y, s, linewidth=2, label=r'x = %.1f, y = %.1f' % (a, b))
grid(True)
legend(loc='lower right', facecolor='w')
ylim(0, 1)
xlim(-5, 5)
title('CDF')

suptitle('Cauchy distribution')