from mipylib.numeric import stats

x = arange(0, 3, 0.01)
aa = [0, 0, 0, 0, 0, 0]
bb = [10, 1.5, 1, 0.5, 0.25, 0.125]
ss = ['-b', '-r', '-c', '-g', '-m', '-y']

#PDF
subplot(1,2,1)
for a,b,s in zip(aa,bb,ss):
    y = stats.lognorm.pdf(x, a, b)
    plot(x, y, s, linewidth=2, label=r'$\mu = %i, \sigma^2 = %.1f$' % (a, b))
#grid(True)
legend(loc='upper right', facecolor='w')
ylim(0, 4)
xlim(-0.1, 3)
title('PDF')

#CDF
subplot(1,2,2)
for a,b,s in zip(aa,bb,ss):
    y = stats.lognorm.cdf(x, a, b)
    plot(x, y, s, linewidth=2, label=r'$\mu = %i, \sigma^2 = %.1f$' % (a, b))
#grid(True)
legend(loc='lower right', facecolor='w')
ylim(0, 1.1)
xlim(-0.1, 3)
title('CDF')

suptitle('Log-Normal distribution')