fn = os.path.join(migl.get_sample_folder(), 'ASCII', 'windrose.txt')
ncol = numasciicol(fn)
nrow = numasciirow(fn)
a = asciiread(fn,shape=(nrow,ncol))
ws=a[:,0]
wd=a[:,1]

wdbins = linspace(0.0, 2 * pi, 17)
wsbins = arange(0., 21.1, 4)
dwdbins = degrees(wdbins)
print dwdbins
dwdbins = dwdbins - 90
print dwdbins
for i in range(len(dwdbins)):
    if dwdbins[i] < 0:
        dwdbins[i] += 360
for i in range(len(dwdbins)):
    d = dwdbins[i]
    d = 360 - d
    dwdbins[i] = d
rwdbins = radians(dwdbins)

N = len(wd)
wdN = len(wdbins) - 1
wsN = len(wsbins) - 1
#cols = makecolors(wsN, alpha=0.7)
cols = makecolors(['k','y','r','b','g'], alpha=0.7)

wd = wd + 360./16/2
wd[wd>360] = wd - 360
rwd = np.radians(wd)

ax = axes(polar=True)  
#grid('on', top=True)  
theta = ones(wdN)
for i in range(wdN):
    theta[i] = rwdbins[i] - pi/wdN/2

bars = []
hhist = 0
for i in range(wsN):
    idx = where((ws>=wsbins[i]) * (ws<wsbins[i+1]))
    if idx is None:
        continue
    print wsbins[i]
    s_wd = rwd[idx]        
    wdhist = histogram(s_wd, wdbins)[0].astype('float')    
    wdhist = wdhist / N       
    lab = '%s - %s' % (wsbins[i], wsbins[i+1])
    bb = bar(theta, wdhist, pi/wdN, bottom=hhist, color=cols[i],
        edgecolor='gray', label=lab).legend
    bb.setStartValue(wsbins[i])
    bb.setEndValue(wsbins[i+1])
    bars.append(bb)
    hhist = hhist + wdhist
ax.set_rmax(0.18)
ax.set_rtick_locations([0.05,0.1,0.15,0.18])
ax.set_rticks(['5%','10%','15%','18%'])
ax.set_rlabel_position(60.)
ax.set_rtick_font(size=12)
ax.set_xtick_locations(arange(0., 360., 360./wdN).tolist())
#ax.set_xticks(['E','NE','N','NW','W','SW','S','SE'])
ax.set_xtick_font(size=14)
ax.set_xticks(['E','ENE','NE','NNE','N','NNW','NW','WNW','W','WSW',\
    'SW','SSW','S','SSE','SE','ESE'])
legend(bars[::-1], xshift=100, yshift=-40)
title('Windrose example')