/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.facile.mode.status;

import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.common.event.CDockableAdapter;
import bibliothek.gui.dock.common.event.CDockablePropertyListener;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.common.intern.CommonDockable;
import bibliothek.gui.dock.common.mode.ExtendedMode;
import bibliothek.gui.dock.facile.mode.LocationModeManager;
import bibliothek.gui.dock.facile.mode.status.AbstractExtendedModeEnablement;
import bibliothek.gui.dock.facile.mode.status.ExtendedModeEnablement;
import bibliothek.gui.dock.facile.mode.status.ExtendedModeEnablementFactory;
import bibliothek.gui.dock.facile.mode.status.ExtendedModeEnablementListener;
import bibliothek.gui.dock.util.extension.ExtensionName;
import bibliothek.util.Path;
import java.util.List;

public class DefaultExtendedModeEnablement
extends AbstractExtendedModeEnablement {
    public static final Path EXTENSION = new Path("dock.DefaultExtendedModeEnablement");
    public static final ExtendedModeEnablementFactory FACTORY = new ExtendedModeEnablementFactory(){

        @Override
        public ExtendedModeEnablement create(LocationModeManager<?> manager) {
            return new DefaultExtendedModeEnablement(manager);
        }
    };
    private CDockablePropertyListener listener = new CDockableAdapter(){

        @Override
        public void minimizableChanged(CDockable dockable) {
            DefaultExtendedModeEnablement.this.fire(dockable.intern(), ExtendedMode.MINIMIZED, DefaultExtendedModeEnablement.this.isAvailable(dockable.intern(), ExtendedMode.MINIMIZED).isAvailable());
        }

        @Override
        public void maximizableChanged(CDockable dockable) {
            DefaultExtendedModeEnablement.this.fire(dockable.intern(), ExtendedMode.MAXIMIZED, DefaultExtendedModeEnablement.this.isAvailable(dockable.intern(), ExtendedMode.MAXIMIZED).isAvailable());
        }

        @Override
        public void externalizableChanged(CDockable dockable) {
            DefaultExtendedModeEnablement.this.fire(dockable.intern(), ExtendedMode.EXTERNALIZED, DefaultExtendedModeEnablement.this.isAvailable(dockable.intern(), ExtendedMode.EXTERNALIZED).isAvailable());
        }

        @Override
        public void normalizeableChanged(CDockable dockable) {
            DefaultExtendedModeEnablement.this.fire(dockable.intern(), ExtendedMode.NORMALIZED, DefaultExtendedModeEnablement.this.isAvailable(dockable.intern(), ExtendedMode.NORMALIZED).isAvailable());
        }
    };
    private ExtendedModeEnablementListener extensionListener = new ExtendedModeEnablementListener(){

        @Override
        public void availabilityChanged(Dockable dockable, ExtendedMode mode, boolean available) {
            DefaultExtendedModeEnablement.this.fire(dockable, mode, DefaultExtendedModeEnablement.this.isAvailable(dockable, mode).isAvailable());
        }
    };
    private ExtendedModeEnablement[] extensions;

    public DefaultExtendedModeEnablement(LocationModeManager<?> manager) {
        super(manager);
        this.init();
        List factories = manager.getController().getExtensions().load(new ExtensionName(EXTENSION, ExtendedModeEnablementFactory.class));
        this.extensions = new ExtendedModeEnablement[factories.size()];
        int index = 0;
        for (ExtendedModeEnablementFactory factory : factories) {
            this.extensions[index] = factory.create(manager);
            this.extensions[index].addListener(this.extensionListener);
        }
    }

    @Override
    public void destroy() {
        for (ExtendedModeEnablement extension : this.extensions) {
            extension.removeListener(this.extensionListener);
            extension.destroy();
        }
        super.destroy();
    }

    @Override
    protected void connect(Dockable dockable) {
        if (dockable instanceof CommonDockable) {
            ((CommonDockable)dockable).getDockable().addCDockablePropertyListener(this.listener);
        }
    }

    @Override
    protected void disconnect(Dockable dockable) {
        if (dockable instanceof CommonDockable) {
            ((CommonDockable)dockable).getDockable().removeCDockablePropertyListener(this.listener);
        }
    }

    @Override
    public ExtendedModeEnablement.Availability isAvailable(Dockable dockable, ExtendedMode mode) {
        ExtendedModeEnablement.Availability available = this.isModeAvailable(dockable, mode);
        for (ExtendedModeEnablement extension : this.extensions) {
            available = available.strongest(extension.isAvailable(dockable, mode));
        }
        return available;
    }

    @Override
    public ExtendedModeEnablement.Hidden isHidden(Dockable dockable, ExtendedMode mode) {
        ExtendedModeEnablement.Hidden hidden = ExtendedModeEnablement.Hidden.WEAK_VISIBLE;
        for (ExtendedModeEnablement extension : this.extensions) {
            hidden = hidden.strongest(extension.isHidden(dockable, mode));
        }
        return hidden;
    }

    protected ExtendedModeEnablement.Availability isModeAvailable(Dockable dockable, ExtendedMode mode) {
        DockStation station;
        if (dockable instanceof CommonDockable) {
            CDockable cdockable = ((CommonDockable)dockable).getDockable();
            boolean result = false;
            boolean set = false;
            if (mode == ExtendedMode.EXTERNALIZED) {
                result = cdockable.isExternalizable();
                set = true;
            } else if (mode == ExtendedMode.MAXIMIZED) {
                result = cdockable.isMaximizable();
                set = true;
            } else if (mode == ExtendedMode.MINIMIZED) {
                result = cdockable.isMinimizable();
                set = true;
            } else if (mode == ExtendedMode.NORMALIZED) {
                result = cdockable.isNormalizeable();
                set = true;
            }
            if (set) {
                if (result) {
                    return ExtendedModeEnablement.Availability.WEAK_AVAILABLE;
                }
                return ExtendedModeEnablement.Availability.WEAK_FORBIDDEN;
            }
        }
        if ((station = dockable.asDockStation()) != null) {
            int n = station.getDockableCount();
            for (int i = 0; i < n; ++i) {
                ExtendedModeEnablement.Availability result = this.isModeAvailable(station.getDockable(i), mode);
                if (result == ExtendedModeEnablement.Availability.UNCERTAIN) continue;
                return result;
            }
        }
        return ExtendedModeEnablement.Availability.UNCERTAIN;
    }
}

