/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.table;

import org.meteoinfo.ndarray.DataType;
import org.meteoinfo.table.DataColumn;

public class Field
extends DataColumn {
    private int fieldLen;
    private int fieldNumDec = 0;

    public Field(String name, DataType type, int fLen, int fNumDec) {
        this.setColumnName(name);
        this.setDataType(type);
        this.fieldLen = fLen;
        this.fieldNumDec = fNumDec;
    }

    public Field(String name, DataType type) {
        this.setColumnName(name);
        this.setDataType(type);
        switch (type) {
            case STRING: {
                this.fieldLen = 255;
                break;
            }
            case DATE: {
                this.fieldLen = 8;
                break;
            }
            case FLOAT: {
                this.fieldLen = 18;
                this.fieldNumDec = 6;
                break;
            }
            case DOUBLE: {
                this.fieldLen = 18;
                this.fieldNumDec = 9;
                break;
            }
            case INT: {
                this.fieldLen = 11;
                break;
            }
            case LONG: {
                this.fieldLen = 20;
                break;
            }
            case BOOLEAN: {
                this.fieldLen = 1;
            }
        }
    }

    public Field(String fName, char fType, int fLen, int fNumDec) {
        this.setColumnName(fName);
        this.fieldLen = fLen;
        this.fieldNumDec = fNumDec;
        switch (fType) {
            case 'D': 
            case 'T': {
                this.setDataType(DataType.DATE);
                break;
            }
            case 'L': {
                this.setDataType(DataType.BOOLEAN);
                break;
            }
            case 'F': {
                this.setDataType(DataType.FLOAT);
                break;
            }
            case 'N': {
                if (fNumDec == 0) {
                    if (fLen <= 11) {
                        this.setDataType(DataType.INT);
                        break;
                    }
                    this.setDataType(DataType.LONG);
                    break;
                }
                this.setDataType(DataType.DOUBLE);
                break;
            }
            default: {
                this.setDataType(DataType.STRING);
            }
        }
    }

    public Field(DataColumn inColumn) {
        this(inColumn.getColumnName(), inColumn.getDataType());
        this.setup_decimalCount();
    }

    public int getLength() {
        return this.fieldLen;
    }

    public void setLength(int len) {
        this.fieldLen = len;
    }

    public int getDecimalCount() {
        return this.fieldNumDec;
    }

    public void setDecimalCount(int value) {
        this.fieldNumDec = value;
    }

    public char getTypeCharacter() {
        switch (this.getDataType()) {
            case BOOLEAN: {
                return 'L';
            }
            case DATE: {
                return 'D';
            }
            case FLOAT: {
                return 'F';
            }
            case DOUBLE: 
            case INT: 
            case LONG: {
                return 'N';
            }
        }
        return 'C';
    }

    public boolean isNumeric() {
        return this.getDataType().isNumeric();
    }

    private void setup_decimalCount() {
        switch (this.getDataType()) {
            case FLOAT: {
                this.fieldLen = 18;
                this.fieldNumDec = 6;
                break;
            }
            case DOUBLE: {
                this.fieldLen = 18;
                this.fieldNumDec = 9;
                break;
            }
            case INT: {
                this.fieldNumDec = 0;
                this.fieldLen = 11;
                break;
            }
            case STRING: {
                this.fieldNumDec = 0;
                this.fieldLen = 255;
                break;
            }
            case DATE: {
                this.fieldNumDec = 0;
                this.fieldLen = 8;
            }
        }
    }
}

