/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.tiff.write;

import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.formats.tiff.fieldtypes.AbstractFieldType;
import org.apache.commons.imaging.formats.tiff.write.AbstractTiffOutputItem;
import org.apache.commons.imaging.formats.tiff.write.ImageDataOffsets;
import org.apache.commons.imaging.formats.tiff.write.TiffOutputDirectory;
import org.apache.commons.imaging.formats.tiff.write.TiffOutputField;

final class TiffOutputSummary {
    public final ByteOrder byteOrder;
    public final TiffOutputDirectory rootDirectory;
    public final Map<Integer, TiffOutputDirectory> directoryTypeMap;
    private final List<OffsetItem> offsetItems = new ArrayList<OffsetItem>();
    private final List<ImageDataOffsets> imageDataItems = new ArrayList<ImageDataOffsets>();

    TiffOutputSummary(ByteOrder byteOrder, TiffOutputDirectory rootDirectory, Map<Integer, TiffOutputDirectory> directoryTypeMap) {
        this.byteOrder = byteOrder;
        this.rootDirectory = rootDirectory;
        this.directoryTypeMap = directoryTypeMap;
    }

    public void add(AbstractTiffOutputItem item, TiffOutputField itemOffsetField) {
        this.offsetItems.add(new OffsetItem(item, itemOffsetField));
    }

    public void addTiffImageData(ImageDataOffsets imageDataInfo) {
        this.imageDataItems.add(imageDataInfo);
    }

    public void updateOffsets(ByteOrder byteOrder) throws ImagingException {
        for (OffsetItem offset : this.offsetItems) {
            byte[] value = AbstractFieldType.LONG.writeData((int)offset.item.getOffset(), byteOrder);
            offset.itemOffsetField.setData(value);
        }
        for (ImageDataOffsets imageDataInfo : this.imageDataItems) {
            for (int j = 0; j < imageDataInfo.outputItems.length; ++j) {
                AbstractTiffOutputItem item = imageDataInfo.outputItems[j];
                imageDataInfo.imageDataOffsets[j] = (int)item.getOffset();
            }
            imageDataInfo.imageDataOffsetsField.setData(AbstractFieldType.LONG.writeData(imageDataInfo.imageDataOffsets, byteOrder));
        }
    }

    private static final class OffsetItem {
        public final AbstractTiffOutputItem item;
        public final TiffOutputField itemOffsetField;

        OffsetItem(AbstractTiffOutputItem item, TiffOutputField itemOffsetField) {
            this.itemOffsetField = itemOffsetField;
            this.item = item;
        }
    }
}

