/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.chart.axis;

import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import org.meteoinfo.chart.Location;
import org.meteoinfo.chart.axis.LonLatAxis;
import org.meteoinfo.chart.geo.MapGridLine;
import org.meteoinfo.chart.plot.AbstractPlot2D;
import org.meteoinfo.common.GridLabel;
import org.meteoinfo.common.PointD;
import org.meteoinfo.common.XAlign;
import org.meteoinfo.common.YAlign;
import org.meteoinfo.projection.ProjectionInfo;
import org.meteoinfo.render.java2d.Draw;

public class ProjLonLatAxis
extends LonLatAxis {
    protected MapGridLine mapGridLine;

    public ProjLonLatAxis(String label, boolean isX, MapGridLine mapGridLine) {
        super(label, isX);
        this.mapGridLine = mapGridLine;
    }

    public ProjLonLatAxis(LonLatAxis axis, MapGridLine mapGridLine) {
        super(axis);
        this.drawDegreeSymbol = axis.drawDegreeSymbol;
        this.degreeSpace = axis.degreeSpace;
        this.mapGridLine = mapGridLine;
    }

    public ProjectionInfo getProjInfo() {
        return this.mapGridLine.getProjInfo();
    }

    public MapGridLine getMapGridLine() {
        return this.mapGridLine;
    }

    public void setMapGridLine(MapGridLine mapGridLine) {
        this.mapGridLine = mapGridLine;
    }

    public int getLabelGap(Graphics2D g, double len, List<GridLabel> labels) {
        int n = labels.size();
        int labLen = this.getMaxLabelLength(g, labels);
        int nn = (int)(len * 0.8 / (double)labLen);
        if (nn == 0) {
            nn = 1;
        }
        return n / nn + 1;
    }

    public int getMaxLabelLength(Graphics2D g, List<GridLabel> labels) {
        int max = 0;
        g.setFont(this.tickLabelFont);
        for (int i = 0; i < labels.size(); ++i) {
            GridLabel lab = labels.get(i);
            Dimension dim = Draw.getStringDimension((String)lab.getLabString(), (Graphics2D)g);
            int width = dim.width;
            if (this.tickLabelAngle != 0.0f) {
                width = (int)(dim.getWidth() * Math.cos((double)this.tickLabelAngle * Math.PI / 180.0));
                int height = dim.height;
                width = Math.max(width, height);
            }
            if (max >= width) continue;
            max = width;
        }
        return max;
    }

    @Override
    void drawXAxis(Graphics2D g, Rectangle2D area, AbstractPlot2D plot) {
        double xMin = area.getX();
        double xMax = area.getX() + area.getWidth();
        double yMin = area.getY();
        double yMax = area.getY() + area.getHeight();
        g.setColor(this.getLineColor());
        g.setStroke(new BasicStroke(this.getLineWidth()));
        g.draw(new Line2D.Double(xMin, yMax, xMax, yMax));
        if (this.isDrawTickLine()) {
            List<GridLabel> lonLabels = this.mapGridLine.getLongitudeLabels();
            int labelGap = this.getLabelGap(g, xMax - xMin, lonLabels);
            g.setColor(this.getTickColor());
            g.setStroke(new BasicStroke(this.getTickWidth()));
            int i = 0;
            int idx = 0;
            for (GridLabel gridLabel : lonLabels) {
                PointD point = gridLabel.getCoord();
                double x = point.X;
                if (x < plot.getDrawExtent().minX || x > plot.getDrawExtent().maxX) continue;
                x = plot.projToScreenX(x, area) + xMin;
                if (this.getLocation() == Location.BOTTOM) {
                    if (this.isInsideTick()) {
                        g.draw(new Line2D.Double(x, yMax, x, yMax - (double)this.getTickLength()));
                    } else {
                        g.draw(new Line2D.Double(x, yMax, x, yMax + (double)this.getTickLength()));
                    }
                } else if (this.isInsideTick()) {
                    g.draw(new Line2D.Double(x, yMin, x, yMin + (double)this.getTickLength()));
                } else {
                    g.draw(new Line2D.Double(x, yMin, x, yMin - (double)this.getTickLength()));
                }
                if (this.isDrawTickLabel() && i == idx) {
                    double y;
                    idx += labelGap;
                    if (this.getLocation() == Location.BOTTOM) {
                        y = this.isInsideTick() ? yMax : yMax + (double)this.getTickLength();
                        y += (double)this.getTickSpace();
                    } else {
                        y = this.isInsideTick() ? yMin : yMin - (double)this.getTickLength();
                        y -= (double)this.getTickSpace();
                    }
                    g.setColor(this.getTickLabelColor());
                    g.setFont(this.getTickLabelFont());
                    Draw.drawString((Graphics2D)g, (double)x, (double)y, (String)gridLabel.getLabString(), (XAlign)XAlign.CENTER, (YAlign)YAlign.TOP, (boolean)true);
                }
                ++i;
            }
        }
    }

    @Override
    void drawYAxis(Graphics2D g, Rectangle2D area, AbstractPlot2D plot) {
        double xMin = area.getX();
        double xMax = area.getX() + area.getWidth();
        double yMin = area.getY();
        double yMax = area.getY() + area.getHeight();
        g.setColor(this.getLineColor());
        g.setStroke(new BasicStroke(this.getLineWidth()));
        g.draw(new Line2D.Double(xMin, yMin, xMin, yMax));
        if (this.isDrawTickLine()) {
            List<GridLabel> latLabels = this.mapGridLine.getLatitudeLabels();
            g.setColor(this.getTickColor());
            g.setStroke(new BasicStroke(this.getTickWidth()));
            for (GridLabel gridLabel : latLabels) {
                double x;
                PointD point = gridLabel.getCoord();
                double y = point.Y;
                if (y < plot.getDrawExtent().minY || y > plot.getDrawExtent().maxY) continue;
                y = plot.projToScreenY(y, area) + yMin;
                if (this.getLocation() == Location.LEFT) {
                    if (this.isInsideTick()) {
                        g.draw(new Line2D.Double(xMin, y, xMin + (double)this.getTickLength(), y));
                    } else {
                        g.draw(new Line2D.Double(xMin, y, xMin - (double)this.getTickLength(), y));
                    }
                } else if (this.isInsideTick()) {
                    g.draw(new Line2D.Double(xMax, y, xMax - (double)this.getTickLength(), y));
                } else {
                    g.draw(new Line2D.Double(xMax, y, xMax + (double)this.getTickLength(), y));
                }
                if (!this.isDrawTickLabel()) continue;
                if (this.getLocation() == Location.LEFT) {
                    x = this.isInsideTick() ? xMin : xMin - (double)this.getTickLength();
                    x -= (double)this.getTickSpace();
                } else {
                    x = this.isInsideTick() ? xMax : xMax + (double)this.getTickLength();
                    x += (double)this.getTickSpace();
                }
                g.setColor(this.getTickLabelColor());
                g.setFont(this.getTickLabelFont());
                Draw.drawString((Graphics2D)g, (double)x, (double)y, (String)gridLabel.getLabString(), (XAlign)XAlign.RIGHT, (YAlign)YAlign.CENTER, (boolean)true);
            }
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        ProjLonLatAxis axis = (ProjLonLatAxis)super.clone();
        axis.mapGridLine = this.mapGridLine;
        return axis;
    }
}

