/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.chart.jogl.mc;

import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import org.meteoinfo.chart.jogl.mc.CallbackMC;
import org.meteoinfo.chart.jogl.mc.MarchingCubes;
import org.meteoinfo.chart.jogl.mc.VolumeGenerator;

public class ExtractHandler {
    public static void extractHandlerChar(File inputFile, File outFile, final int[] size, final float[] voxSize, final char isoValue, int nThreads) {
        int i;
        char[] scalarField;
        block10: {
            if (inputFile != null) {
                System.out.println("PROGRESS: Reading input data.");
                try {
                    int idx = 0;
                    scalarField = new char[size[0] * size[1] * size[2]];
                    DataInputStream in = new DataInputStream(new FileInputStream(inputFile));
                    while (in.available() > 0) {
                        if (idx >= scalarField.length) {
                            in.close();
                            System.out.println("Invalid volume size was specified.");
                            return;
                        }
                        scalarField[idx++] = (char)in.readByte();
                    }
                    in.close();
                    if (idx != scalarField.length) {
                        System.out.println("Invalid volume size was specified.");
                        return;
                    }
                    break block10;
                }
                catch (Exception e) {
                    System.out.println("Something went wrong while reading the volume");
                    return;
                }
            }
            System.out.println("PROGRESS: Generating volume data.");
            scalarField = VolumeGenerator.generateScalarFieldChar(size);
        }
        final char[] finalScalarField = scalarField;
        ArrayList<2> threads = new ArrayList<2>();
        final ArrayList<ArrayList<float[]>> results = new ArrayList<ArrayList<float[]>>();
        int remainder = size[2] % nThreads;
        int segment = size[2] / nThreads;
        int zAxisOffset = 0;
        System.out.println("PROGRESS: Executing marching cubes.");
        for (i = 0; i < nThreads; ++i) {
            int segmentSize = remainder-- > 0 ? segment + 1 : segment;
            final int paddedSegmentSize = i != nThreads - 1 ? segmentSize + 1 : segmentSize;
            final CallbackMC callback = new CallbackMC(){

                @Override
                public void run() {
                    results.add(this.getVertices());
                }
            };
            final int finalZAxisOffset = zAxisOffset;
            Thread t = new Thread(){

                @Override
                public void run() {
                    MarchingCubes.marchingCubesChar(finalScalarField, new int[]{size[0], size[1], paddedSegmentSize}, size[2], voxSize, isoValue, finalZAxisOffset, callback);
                }
            };
            threads.add(t);
            t.start();
            zAxisOffset += segmentSize;
        }
        for (i = 0; i < threads.size(); ++i) {
            try {
                ((Thread)threads.get(i)).join();
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        System.out.println("PROGRESS: Writing results to output file.");
        ExtractHandler.outputToFile(results, outFile);
    }

    public static void extractHandlerShort(File inputFile, File outFile, final int[] size, final float[] voxSize, final short isoValue, int nThreads) {
        int i;
        short[] scalarField;
        block10: {
            if (inputFile != null) {
                System.out.println("PROGRESS: Reading input data.");
                try {
                    int idx = 0;
                    scalarField = new short[size[0] * size[1] * size[2]];
                    DataInputStream in = new DataInputStream(new FileInputStream(inputFile));
                    while (in.available() > 0) {
                        if (idx >= scalarField.length) {
                            in.close();
                            System.out.println("Invalid volume size was specified.");
                            return;
                        }
                        scalarField[idx++] = in.readShort();
                    }
                    in.close();
                    if (idx != scalarField.length) {
                        System.out.println("Invalid volume size was specified.");
                        return;
                    }
                    break block10;
                }
                catch (Exception e) {
                    System.out.println("Something went wrong while reading the volume");
                    return;
                }
            }
            System.out.println("PROGRESS: Generating volume data.");
            scalarField = VolumeGenerator.generateScalarFieldShort(size);
        }
        final short[] finalScalarField = scalarField;
        ArrayList<4> threads = new ArrayList<4>();
        final ArrayList<ArrayList<float[]>> results = new ArrayList<ArrayList<float[]>>();
        int remainder = size[2] % nThreads;
        int segment = size[2] / nThreads;
        int zAxisOffset = 0;
        System.out.println("PROGRESS: Executing marching cubes.");
        for (i = 0; i < nThreads; ++i) {
            int segmentSize = remainder-- > 0 ? segment + 1 : segment;
            final int paddedSegmentSize = i != nThreads - 1 ? segmentSize + 1 : segmentSize;
            final CallbackMC callback = new CallbackMC(){

                @Override
                public void run() {
                    results.add(this.getVertices());
                }
            };
            final int finalZAxisOffset = zAxisOffset;
            Thread t = new Thread(){

                @Override
                public void run() {
                    MarchingCubes.marchingCubesShort(finalScalarField, new int[]{size[0], size[1], paddedSegmentSize}, size[2], voxSize, isoValue, finalZAxisOffset, callback);
                }
            };
            threads.add(t);
            t.start();
            zAxisOffset += segmentSize;
        }
        for (i = 0; i < threads.size(); ++i) {
            try {
                ((Thread)threads.get(i)).join();
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        System.out.println("PROGRESS: Writing results to output file.");
        ExtractHandler.outputToFile(results, outFile);
    }

    public static void extractHandlerInt(File inputFile, File outFile, final int[] size, final float[] voxSize, final int isoValue, int nThreads) {
        int i;
        int[] scalarField;
        block10: {
            if (inputFile != null) {
                System.out.println("PROGRESS: Reading input data.");
                try {
                    int idx = 0;
                    scalarField = new int[size[0] * size[1] * size[2]];
                    DataInputStream in = new DataInputStream(new FileInputStream(inputFile));
                    while (in.available() > 0) {
                        if (idx >= scalarField.length) {
                            in.close();
                            System.out.println("Invalid volume size was specified.");
                            return;
                        }
                        scalarField[idx++] = in.readInt();
                    }
                    in.close();
                    if (idx != scalarField.length) {
                        System.out.println("Invalid volume size was specified.");
                        return;
                    }
                    break block10;
                }
                catch (Exception e) {
                    System.out.println("Something went wrong while reading the volume");
                    return;
                }
            }
            System.out.println("PROGRESS: Generating volume data.");
            scalarField = VolumeGenerator.generateScalarFieldInt(size);
        }
        final int[] finalScalarField = scalarField;
        ArrayList<6> threads = new ArrayList<6>();
        final ArrayList<ArrayList<float[]>> results = new ArrayList<ArrayList<float[]>>();
        int remainder = size[2] % nThreads;
        int segment = size[2] / nThreads;
        int zAxisOffset = 0;
        System.out.println("PROGRESS: Executing marching cubes.");
        for (i = 0; i < nThreads; ++i) {
            int segmentSize = remainder-- > 0 ? segment + 1 : segment;
            final int paddedSegmentSize = i != nThreads - 1 ? segmentSize + 1 : segmentSize;
            final CallbackMC callback = new CallbackMC(){

                @Override
                public void run() {
                    results.add(this.getVertices());
                }
            };
            final int finalZAxisOffset = zAxisOffset;
            Thread t = new Thread(){

                @Override
                public void run() {
                    MarchingCubes.marchingCubesInt(finalScalarField, new int[]{size[0], size[1], paddedSegmentSize}, size[2], voxSize, isoValue, finalZAxisOffset, callback);
                }
            };
            threads.add(t);
            t.start();
            zAxisOffset += segmentSize;
        }
        for (i = 0; i < threads.size(); ++i) {
            System.out.println("PROGRESS: Reading input data.");
            try {
                ((Thread)threads.get(i)).join();
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        System.out.println("PROGRESS: Writing results to output file.");
        ExtractHandler.outputToFile(results, outFile);
    }

    public static void extractHandlerFloat(File inputFile, File outFile, final int[] size, final float[] voxSize, final float isoValue, int nThreads) {
        int i;
        float[] scalarField;
        block10: {
            if (inputFile != null) {
                System.out.println("PROGRESS: Reading input data.");
                try {
                    int idx = 0;
                    scalarField = new float[size[0] * size[1] * size[2]];
                    DataInputStream in = new DataInputStream(new FileInputStream(inputFile));
                    while (in.available() > 0) {
                        if (idx >= scalarField.length) {
                            in.close();
                            System.out.println("Invalid volume size was specified.");
                            return;
                        }
                        scalarField[idx++] = in.readFloat();
                    }
                    in.close();
                    if (idx != scalarField.length) {
                        System.out.println("Invalid volume size was specified.");
                        return;
                    }
                    break block10;
                }
                catch (Exception e) {
                    System.out.println("Something went wrong while reading the volume");
                    return;
                }
            }
            System.out.println("PROGRESS: Generating volume data.");
            scalarField = VolumeGenerator.generateScalarFieldFloat(size);
        }
        final float[] finalScalarField = scalarField;
        ArrayList<8> threads = new ArrayList<8>();
        final ArrayList<ArrayList<float[]>> results = new ArrayList<ArrayList<float[]>>();
        int remainder = size[2] % nThreads;
        int segment = size[2] / nThreads;
        int zAxisOffset = 0;
        System.out.println("PROGRESS: Executing marching cubes.");
        for (i = 0; i < nThreads; ++i) {
            int segmentSize = remainder-- > 0 ? segment + 1 : segment;
            final int paddedSegmentSize = i != nThreads - 1 ? segmentSize + 1 : segmentSize;
            final CallbackMC callback = new CallbackMC(){

                @Override
                public void run() {
                    results.add(this.getVertices());
                }
            };
            final int finalZAxisOffset = zAxisOffset;
            Thread t = new Thread(){

                @Override
                public void run() {
                    MarchingCubes.marchingCubesFloat(finalScalarField, new int[]{size[0], size[1], paddedSegmentSize}, size[2], voxSize, isoValue, finalZAxisOffset, callback);
                }
            };
            threads.add(t);
            t.start();
            zAxisOffset += segmentSize;
        }
        for (i = 0; i < threads.size(); ++i) {
            try {
                ((Thread)threads.get(i)).join();
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        System.out.println("PROGRESS: Writing results to output file.");
        ExtractHandler.outputToFile(results, outFile);
    }

    public static void extractHandlerDouble(File inputFile, File outFile, final int[] size, final float[] voxSize, final double isoValue, int nThreads) {
        int i;
        double[] scalarField;
        block10: {
            if (inputFile != null) {
                try {
                    int idx = 0;
                    scalarField = new double[size[0] * size[1] * size[2]];
                    DataInputStream in = new DataInputStream(new FileInputStream(inputFile));
                    while (in.available() > 0) {
                        if (idx >= scalarField.length) {
                            in.close();
                            System.out.println("Invalid volume size was specified.");
                            return;
                        }
                        scalarField[idx++] = in.readDouble();
                    }
                    in.close();
                    if (idx != scalarField.length) {
                        System.out.println("Invalid volume size was specified.");
                        return;
                    }
                    break block10;
                }
                catch (Exception e) {
                    System.out.println("Something went wrong while reading the volume");
                    return;
                }
            }
            System.out.println("PROGRESS: Generating volume data.");
            scalarField = VolumeGenerator.generateScalarFieldDouble(size);
        }
        final double[] finalScalarField = scalarField;
        ArrayList<10> threads = new ArrayList<10>();
        final ArrayList<ArrayList<float[]>> results = new ArrayList<ArrayList<float[]>>();
        int remainder = size[2] % nThreads;
        int segment = size[2] / nThreads;
        int zAxisOffset = 0;
        System.out.println("PROGRESS: Executing marching cubes.");
        for (i = 0; i < nThreads; ++i) {
            int segmentSize = remainder-- > 0 ? segment + 1 : segment;
            final int paddedSegmentSize = i != nThreads - 1 ? segmentSize + 1 : segmentSize;
            final CallbackMC callback = new CallbackMC(){

                @Override
                public void run() {
                    results.add(this.getVertices());
                }
            };
            final int finalZAxisOffset = zAxisOffset;
            Thread t = new Thread(){

                @Override
                public void run() {
                    MarchingCubes.marchingCubesDouble(finalScalarField, new int[]{size[0], size[1], paddedSegmentSize}, size[2], voxSize, isoValue, finalZAxisOffset, callback);
                }
            };
            threads.add(t);
            t.start();
            zAxisOffset += segmentSize;
        }
        for (i = 0; i < threads.size(); ++i) {
            try {
                ((Thread)threads.get(i)).join();
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        System.out.println("PROGRESS: Writing results to output file.");
        ExtractHandler.outputToFile(results, outFile);
    }

    private static void outputToFile(ArrayList<ArrayList<float[]>> results, File outFile) {
        try {
            BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(outFile));
            int idx = 0;
            for (int i = 0; i < results.size(); ++i) {
                ArrayList<float[]> resSeg = results.get(i);
                for (int j = 0; j < resSeg.size(); ++j) {
                    if (idx % 3 == 0) {
                        stream.write(("f " + (idx + 1) + " " + (idx + 2) + " " + (idx + 3) + "\n").getBytes());
                    }
                    ++idx;
                    stream.write(("v " + resSeg.get(j)[0] + " " + resSeg.get(j)[1] + " " + resSeg.get(j)[2] + "\n").getBytes());
                }
            }
            stream.flush();
            stream.close();
        }
        catch (Exception e) {
            System.out.println("Something went wrong while writing to the output file");
            return;
        }
    }
}

