/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.ndarray;

import java.io.IOException;
import org.meteoinfo.ndarray.ArrayStructureBak;
import org.meteoinfo.ndarray.StructureData;
import org.meteoinfo.ndarray.StructureDataIterator;

public class SequenceIterator
implements StructureDataIterator {
    private int start;
    private int size;
    private int count;
    private ArrayStructureBak abb;

    public SequenceIterator(int start, int size, ArrayStructureBak abb) {
        this.start = start;
        this.size = size;
        this.abb = abb;
        this.count = 0;
    }

    @Override
    public boolean hasNext() throws IOException {
        return this.count < this.size;
    }

    @Override
    public StructureData next() throws IOException {
        StructureData result = this.abb.getStructureData(this.start + this.count);
        ++this.count;
        return result;
    }

    @Override
    public void setBufferSize(int bytes) {
    }

    @Override
    public StructureDataIterator reset() {
        this.count = 0;
        return this;
    }

    @Override
    public int getCurrentRecno() {
        return this.count;
    }

    @Override
    public void finish() {
    }
}

