/*
 * Decompiled with CFR 0.152.
 */
package edu.ucar.unidata.compression.jna.libaec;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.ptr.PointerByReference;
import edu.ucar.unidata.compression.jna.libaec.SizeT;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LibAec {
    private static Logger log = LoggerFactory.getLogger(LibAec.class);
    private static final String libName = "aec";
    static final int AEC_DATA_SIGNED = 1;
    static final int AEC_DATA_3BYTE = 2;
    static final int AEC_DATA_MSB = 4;
    static final int AEC_DATA_PREPROCESS = 8;
    static final int AEC_RESTRICTED = 16;
    static final int AEC_PAD_RSI = 32;
    static final int AEC_NOT_ENFORCE = 64;
    public static final int AEC_OK = 0;
    public static final int AEC_CONF_ERROR = -1;
    public static final int AEC_STREAM_ERROR = -2;
    public static final int AEC_DATA_ERROR = -3;
    public static final int AEC_MEM_ERROR = -4;
    public static final int AEC_RSI_OFFSETS_ERROR = -5;
    public static final int AEC_NO_FLUSH = 0;
    public static final int AEC_FLUSH = 1;

    static native int aec_buffer_encode(AecStream var0);

    public static native int aec_buffer_decode(AecStream var0);

    static {
        try {
            File library = Native.extractFromResourcePath((String)libName);
            Native.register((String)library.getAbsolutePath());
            log.debug("Using libaec library from libaec-native.jar");
        }
        catch (IOException e) {
            try {
                Native.register((String)libName);
                log.debug("Using libaec library from system");
            }
            catch (UnsatisfiedLinkError ule) {
                String message = "libaec C library not present. To read this data, include the libaec-native jar in your classpath (edu.ucar:libaec-native) or install libaec on your system.";
                log.error(message);
                throw new RuntimeException(message, ule);
            }
        }
    }

    public static class AecStream
    extends Structure {
        public Pointer next_in;
        public SizeT avail_in;
        public SizeT total_in;
        public Pointer next_out;
        public SizeT avail_out;
        public SizeT total_out;
        public int bits_per_sample;
        public int block_size;
        public int rsi;
        public int flags;
        public volatile PointerByReference state;

        public static AecStream create(int bitsPerSample, int blockSize, int rsi, int flags) {
            AecStream aecStream = new AecStream();
            aecStream.bits_per_sample = bitsPerSample;
            aecStream.block_size = blockSize;
            aecStream.rsi = rsi;
            aecStream.flags = flags;
            return aecStream;
        }

        public void setInputMemory(Memory inputMemory) {
            this.next_in = inputMemory;
            this.avail_in = new SizeT(inputMemory.size());
        }

        public void setOutputMemory(Memory outputMemory) {
            this.next_out = outputMemory;
            this.avail_out = new SizeT(outputMemory.size());
        }

        protected List<String> getFieldOrder() {
            return Arrays.asList("next_in", "avail_in", "total_in", "next_out", "avail_out", "total_out", "bits_per_sample", "block_size", "rsi", "flags", "state");
        }
    }
}

