/*
 * Decompiled with CFR 0.152.
 */
package org.meteothink.imep.forms;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.meteothink.imep.verification.TimeSelect;
import org.meteothink.imep.verification.VerifyGroup;

public class FrmTimes
extends JDialog {
    private VerifyGroup _group;
    private JButton jButton_Cancel;
    private JButton jButton_OK;
    private JButton jButton_Select;
    private JButton jButton_SelectAll;
    private JButton jButton_UnSelect;
    private JButton jButton_UnselectAll;
    private JComboBox jComboBox_TimeSelect;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel_IndexPrompt;
    private JLabel jLabel_TimeIndices;
    private JList jList_ForecastTimes;
    private JList jList_SelectedTimes;
    private JPanel jPanel_Times;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTextField jTextField_TimeIndices;

    public FrmTimes(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    private void initComponents() {
        this.jPanel_Times = new JPanel();
        this.jButton_UnselectAll = new JButton();
        this.jButton_UnSelect = new JButton();
        this.jButton_SelectAll = new JButton();
        this.jButton_Select = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.jList_SelectedTimes = new JList();
        this.jLabel2 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jList_ForecastTimes = new JList();
        this.jLabel1 = new JLabel();
        this.jButton_OK = new JButton();
        this.jButton_Cancel = new JButton();
        this.jLabel3 = new JLabel();
        this.jComboBox_TimeSelect = new JComboBox();
        this.jTextField_TimeIndices = new JTextField();
        this.jLabel_TimeIndices = new JLabel();
        this.jLabel_IndexPrompt = new JLabel();
        this.setDefaultCloseOperation(2);
        this.jPanel_Times.setBorder(BorderFactory.createEtchedBorder());
        this.jButton_UnselectAll.setText("<<");
        this.jButton_UnselectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmTimes.this.jButton_UnselectAllActionPerformed(evt);
            }
        });
        this.jButton_UnSelect.setText("<");
        this.jButton_UnSelect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmTimes.this.jButton_UnSelectActionPerformed(evt);
            }
        });
        this.jButton_SelectAll.setText(">>");
        this.jButton_SelectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmTimes.this.jButton_SelectAllActionPerformed(evt);
            }
        });
        this.jButton_Select.setText(">");
        this.jButton_Select.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmTimes.this.jButton_SelectActionPerformed(evt);
            }
        });
        this.jList_SelectedTimes.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jScrollPane2.setViewportView(this.jList_SelectedTimes);
        this.jLabel2.setText("Selected Times:");
        this.jList_ForecastTimes.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jScrollPane1.setViewportView(this.jList_ForecastTimes);
        this.jLabel1.setText("Forecast Times:");
        GroupLayout jPanel_TimesLayout = new GroupLayout(this.jPanel_Times);
        this.jPanel_Times.setLayout(jPanel_TimesLayout);
        jPanel_TimesLayout.setHorizontalGroup(jPanel_TimesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_TimesLayout.createSequentialGroup().addContainerGap().addGroup(jPanel_TimesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jScrollPane1, -2, 187, -2)).addGap(24, 24, 24).addGroup(jPanel_TimesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButton_UnSelect, -2, 50, -2).addComponent(this.jButton_UnselectAll, -2, 50, -2).addGroup(jPanel_TimesLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jButton_Select, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jButton_SelectAll, GroupLayout.Alignment.LEADING))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(jPanel_TimesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, -2, 207, -2).addComponent(this.jLabel2)).addContainerGap()));
        jPanel_TimesLayout.setVerticalGroup(jPanel_TimesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel_TimesLayout.createSequentialGroup().addContainerGap().addGroup(jPanel_TimesLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel1).addComponent(this.jLabel2)).addGroup(jPanel_TimesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_TimesLayout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(jPanel_TimesLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane2, -2, 229, -2).addComponent(this.jScrollPane1, -2, 229, -2)).addContainerGap()).addGroup(jPanel_TimesLayout.createSequentialGroup().addGap(18, 18, 18).addComponent(this.jButton_Select).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButton_SelectAll).addGap(42, 42, 42).addComponent(this.jButton_UnSelect).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButton_UnselectAll).addContainerGap(-1, Short.MAX_VALUE)))));
        this.jButton_OK.setText("OK");
        this.jButton_OK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmTimes.this.jButton_OKActionPerformed(evt);
            }
        });
        this.jButton_Cancel.setText("Cancel");
        this.jButton_Cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmTimes.this.jButton_CancelActionPerformed(evt);
            }
        });
        this.jLabel3.setText("Time Select:");
        this.jComboBox_TimeSelect.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBox_TimeSelect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmTimes.this.jComboBox_TimeSelectActionPerformed(evt);
            }
        });
        this.jLabel_TimeIndices.setText("Time Indices:");
        this.jLabel_IndexPrompt.setForeground(new Color(0, 0, 204));
        this.jLabel_IndexPrompt.setText("Prompt: Input integer numbers with semicolon as delimiter! (0;1;2)");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel3).addComponent(this.jLabel_TimeIndices)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextField_TimeIndices).addGroup(layout.createSequentialGroup().addComponent(this.jComboBox_TimeSelect, -2, 186, -2).addGap(0, 0, Short.MAX_VALUE)))).addGroup(layout.createSequentialGroup().addComponent(this.jLabel_IndexPrompt).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jPanel_Times, -1, -1, Short.MAX_VALUE)).addContainerGap()).addGroup(layout.createSequentialGroup().addGap(144, 144, 144).addComponent(this.jButton_OK, -2, 91, -2).addGap(75, 75, 75).addComponent(this.jButton_Cancel, -2, 82, -2).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jComboBox_TimeSelect, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextField_TimeIndices, -2, -1, -2).addComponent(this.jLabel_TimeIndices)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel_IndexPrompt).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 20, Short.MAX_VALUE).addComponent(this.jPanel_Times, -2, -1, -2).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton_Cancel).addComponent(this.jButton_OK)).addContainerGap()));
        this.pack();
    }

    private void jComboBox_TimeSelectActionPerformed(ActionEvent evt) {
        if (this.jComboBox_TimeSelect.getItemCount() > 0) {
            TimeSelect tSel = (TimeSelect)((Object)this.jComboBox_TimeSelect.getSelectedItem());
            switch (tSel) {
                case All: {
                    this.jLabel_TimeIndices.setVisible(false);
                    this.jTextField_TimeIndices.setVisible(false);
                    this.jLabel_IndexPrompt.setVisible(false);
                    this.jPanel_Times.setVisible(false);
                    break;
                }
                case TimeIndex: {
                    this.jLabel_TimeIndices.setVisible(true);
                    this.jTextField_TimeIndices.setVisible(true);
                    this.jLabel_IndexPrompt.setVisible(true);
                    this.jPanel_Times.setVisible(false);
                    if (this._group.getTimeIndices().size() <= 0) break;
                    String indexStr = String.valueOf(this._group.getTimeIndices().get(0));
                    if (this._group.getTimeIndices().size() > 1) {
                        for (int i = 1; i < this._group.getTimeIndices().size(); ++i) {
                            indexStr = indexStr + ";" + String.valueOf(this._group.getTimeIndices().get(i));
                        }
                    }
                    this.jTextField_TimeIndices.setText(indexStr);
                    break;
                }
                case TimeValue: {
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    this.jLabel_TimeIndices.setVisible(false);
                    this.jTextField_TimeIndices.setVisible(false);
                    this.jLabel_IndexPrompt.setVisible(false);
                    this.jPanel_Times.setVisible(true);
                    List<LocalDateTime> times = this._group.getFcstTimes();
                    DefaultListModel<String> listModel = new DefaultListModel<String>();
                    DateTimeFormatter format = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
                    for (int i = 0; i < times.size(); ++i) {
                        listModel.addElement(format.format(times.get(i)));
                    }
                    this.jList_ForecastTimes.setModel(listModel);
                    this.jList_ForecastTimes.setSelectedIndex(0);
                    DefaultListModel<String> selListModel = new DefaultListModel<String>();
                    if (this._group.getTimeNum() > 0) {
                        for (int i = 0; i < this._group.getTimeNum(); ++i) {
                            selListModel.addElement(format.format(this._group.getTimes().get(i)));
                        }
                    }
                    this.jList_SelectedTimes.setModel(selListModel);
                    if (selListModel.getSize() > 0) {
                        this.jList_SelectedTimes.setSelectedIndex(0);
                    }
                    this.setCursor(Cursor.getDefaultCursor());
                }
            }
        }
    }

    private void jButton_SelectActionPerformed(ActionEvent evt) {
        Object[] selValues = this.jList_ForecastTimes.getSelectedValues();
        DefaultListModel listModel = (DefaultListModel)this.jList_SelectedTimes.getModel();
        for (Object value : selValues) {
            String sel = value.toString();
            if (listModel.contains(sel)) continue;
            listModel.addElement(sel);
        }
    }

    private void jButton_SelectAllActionPerformed(ActionEvent evt) {
        DefaultListModel listModel = (DefaultListModel)this.jList_ForecastTimes.getModel();
        DefaultListModel selListModel = (DefaultListModel)this.jList_SelectedTimes.getModel();
        selListModel.clear();
        for (int i = 0; i < listModel.getSize(); ++i) {
            selListModel.addElement(listModel.get(i));
        }
    }

    private void jButton_UnSelectActionPerformed(ActionEvent evt) {
        Object[] selValues;
        for (Object value : selValues = this.jList_SelectedTimes.getSelectedValues()) {
            ((DefaultListModel)this.jList_SelectedTimes.getModel()).removeElement(value);
        }
    }

    private void jButton_UnselectAllActionPerformed(ActionEvent evt) {
        ((DefaultListModel)this.jList_SelectedTimes.getModel()).removeAllElements();
    }

    private void jButton_OKActionPerformed(ActionEvent evt) {
        TimeSelect tSel = (TimeSelect)((Object)this.jComboBox_TimeSelect.getSelectedItem());
        boolean isOK = true;
        switch (tSel) {
            case TimeIndex: {
                String indexStr = this.jTextField_TimeIndices.getText().trim();
                if (indexStr.isEmpty()) {
                    JOptionPane.showMessageDialog(null, "The indices can not be empty!", "Error", 0);
                    isOK = false;
                    break;
                }
                String[] indexStrs = indexStr.split(";");
                ArrayList<Integer> indices = new ArrayList<Integer>();
                for (String str : indexStrs) {
                    indices.add(Integer.parseInt(str));
                }
                this._group.setTimeIndices(indices);
                break;
            }
            case TimeValue: {
                DefaultListModel listModel = (DefaultListModel)this.jList_SelectedTimes.getModel();
                if (listModel.getSize() == 0) {
                    JOptionPane.showMessageDialog(null, "The selected times can not be empty!", "Error", 0);
                    isOK = false;
                    break;
                }
                DateTimeFormatter format = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
                ArrayList<LocalDateTime> times = new ArrayList<LocalDateTime>();
                for (int i = 0; i < listModel.getSize(); ++i) {
                    times.add(LocalDateTime.parse(listModel.get(i).toString(), format));
                }
                this._group.setTimes(times);
            }
        }
        if (isOK) {
            this._group.setTimeSelect(tSel);
            this.dispose();
        }
    }

    private void jButton_CancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    public void setVerifyGroup(VerifyGroup group) {
        this._group = group;
        this.jComboBox_TimeSelect.removeAllItems();
        for (TimeSelect tSel : TimeSelect.values()) {
            this.jComboBox_TimeSelect.addItem(tSel);
        }
        this.jComboBox_TimeSelect.setSelectedItem((Object)group.getTimeSelect());
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(FrmTimes.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(FrmTimes.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(FrmTimes.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(FrmTimes.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                FrmTimes dialog = new FrmTimes((Frame)new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

