/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme.eclipse.stack;

import bibliothek.extension.gui.dock.theme.EclipseTheme;
import bibliothek.extension.gui.dock.theme.eclipse.stack.EclipseMenu;
import bibliothek.extension.gui.dock.theme.eclipse.stack.EclipseTab;
import bibliothek.extension.gui.dock.theme.eclipse.stack.EclipseTabInfo;
import bibliothek.extension.gui.dock.theme.eclipse.stack.EclipseTabPaneContent;
import bibliothek.extension.gui.dock.theme.eclipse.stack.tab.BaseTabComponent;
import bibliothek.extension.gui.dock.theme.eclipse.stack.tab.BorderedComponent;
import bibliothek.extension.gui.dock.theme.eclipse.stack.tab.TabComponent;
import bibliothek.extension.gui.dock.theme.eclipse.stack.tab.TabPainter;
import bibliothek.extension.gui.dock.theme.eclipse.stack.tab.TabPanePainter;
import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.station.stack.CombinedStackDockComponent;
import bibliothek.gui.dock.station.stack.CombinedStackDockContentPane;
import bibliothek.gui.dock.station.stack.StackDockComponent;
import bibliothek.gui.dock.station.stack.StackDockComponentBorder;
import bibliothek.gui.dock.station.stack.StackDockComponentContentBorder;
import bibliothek.gui.dock.station.stack.tab.LonelyTabPaneComponent;
import bibliothek.gui.dock.station.stack.tab.TabPane;
import bibliothek.gui.dock.station.stack.tab.TabPaneListener;
import bibliothek.gui.dock.themes.border.BorderForwarder;
import bibliothek.gui.dock.util.PropertyValue;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

public class EclipseTabPane
extends CombinedStackDockComponent<EclipseTab, EclipseMenu, EclipseTabInfo>
implements BorderedComponent {
    private PropertyValue<TabPainter> tabPainter = new PropertyValue<TabPainter>(EclipseTheme.TAB_PAINTER){

        @Override
        protected void valueChanged(TabPainter oldValue, TabPainter newValue) {
            EclipseTabPane.this.updateTabPainter();
        }
    };
    private PropertyValue<Boolean> paintIcons = new PropertyValue<Boolean>(EclipseTheme.PAINT_ICONS_WHEN_DESELECTED){

        @Override
        protected void valueChanged(Boolean oldValue, Boolean newValue) {
            EclipseTabPane.this.updatePaintIcons();
        }
    };
    private DockStation station;
    private EclipseTheme theme;
    private TabPanePainter painter;
    private BorderForwarder border;

    public EclipseTabPane(EclipseTheme theme, DockStation station) {
        this.theme = theme;
        this.station = station;
        this.setInfoComponent(new EclipseTabInfo(this));
        this.addTabPaneListener(new TabPaneListener(){

            @Override
            public void added(TabPane pane, Dockable dockable) {
            }

            @Override
            public void removed(TabPane pane, Dockable dockable) {
            }

            @Override
            public void selectionChanged(TabPane pane) {
                EclipseTabPane.this.updateFullBorder();
            }

            @Override
            public void infoComponentChanged(TabPane pane, LonelyTabPaneComponent oldInfo, LonelyTabPaneComponent newInfo) {
            }

            @Override
            public void controllerChanged(TabPane pane, DockController controller) {
            }
        });
        this.getComponent().addHierarchyListener(new WindowActiveObserver());
    }

    @Override
    protected CombinedStackDockContentPane createContentPane(CombinedStackDockComponent<EclipseTab, EclipseMenu, EclipseTabInfo> self) {
        return new EclipseTabPaneContent((EclipseTabPane)self);
    }

    @Override
    public void setController(DockController controller) {
        super.setController(controller);
        this.tabPainter.setProperties(controller);
        this.paintIcons.setProperties(controller);
        this.getBorderForwarder().setController(controller);
        if (this.painter != null) {
            this.painter.setController(controller);
        }
        for (EclipseTab tab : this.getTabsList()) {
            tab.setController(controller);
        }
        for (EclipseMenu menu : this.getMenuList()) {
            menu.setController(controller);
        }
        this.updateTabPainter();
    }

    @Override
    public void setInfoComponent(EclipseTabInfo info) {
        EclipseTabInfo old = (EclipseTabInfo)this.getInfoComponent();
        if (old != null) {
            old.setSelection(null);
        }
        if (info != null) {
            info.setSelection(this.getSelectedDockable());
        }
        super.setInfoComponent(info);
    }

    public EclipseTheme getTheme() {
        return this.theme;
    }

    public DockStation getStation() {
        return this.station;
    }

    public TabPainter getTabPainter() {
        return this.tabPainter.getValue();
    }

    protected void updateTabPainter() {
        this.updateFullBorder();
        TabPainter painter = this.getTabPainter();
        this.setPainter(painter == null ? null : painter.createDecorationPainter(this));
        this.discardComponentsAndRebuild();
    }

    public void setPainter(TabPanePainter painter) {
        if (this.painter != null) {
            this.painter.setController(null);
        }
        this.painter = painter;
        if (this.painter != null) {
            this.painter.setController(this.getController());
        }
        this.repaint();
    }

    public TabPanePainter getPainter() {
        return this.painter;
    }

    @Override
    public void updateFullBorder() {
        TabPainter painter = this.getTabPainter();
        DockController controller = this.getController();
        Dockable selection = this.getSelectedDockable();
        Border border = null;
        if (painter != null && controller != null && selection != null) {
            border = painter.getFullBorder(this, controller, selection);
        }
        this.getBorderForwarder().setBorder(border);
        this.repaint();
    }

    private BorderForwarder getBorderForwarder() {
        if (this.border == null) {
            this.border = this.createBorderModifier(this.getComponent());
            this.border.setController(this.getController());
        }
        return this.border;
    }

    protected BorderForwarder createBorderModifier(JComponent target) {
        return new TabPaneBorder(target);
    }

    @Override
    protected BorderForwarder createContentBorderModifier(Dockable dockable, JComponent component) {
        return new TabContentBorder(dockable, component);
    }

    private void updatePaintIcons() {
        boolean paintIconsWhenInactive = this.paintIcons.getValue();
        for (EclipseTab tab : this.getTabsList()) {
            tab.setPaintIconWhenInactive(paintIconsWhenInactive);
        }
        this.revalidate();
        this.repaint();
    }

    @Override
    protected EclipseTab newTab(Dockable dockable) {
        TabComponent component = this.getTabPainter().createTabComponent(this, dockable);
        EclipseTab tab = new EclipseTab(this, dockable, component);
        tab.setPaintIconWhenInactive(this.paintIcons.getValue());
        tab.setController(this.getController());
        tab.bind();
        return tab;
    }

    @Override
    protected void tabRemoved(EclipseTab tab) {
        tab.unbind();
    }

    public int indexOfVisible(TabComponent tab) {
        for (EclipseTab eclipse : this.getTabsList()) {
            if (eclipse.getTabComponent() != tab) continue;
            return this.indexOfVisible(eclipse);
        }
        return -1;
    }

    @Override
    public EclipseMenu newMenu() {
        EclipseMenu menu = new EclipseMenu(this);
        menu.setController(this.getController());
        return menu;
    }

    @Override
    protected void menuRemoved(EclipseMenu menu) {
        menu.setController(null);
    }

    public void setContentBorderAt(int index, Border border) {
        this.getContentAt(index).setBorder(border);
    }

    @Override
    protected Component createLayerAt(Component component, Dockable dockable) {
        JPanel panel = new JPanel(new GridLayout(1, 1));
        panel.add(component);
        panel.setOpaque(false);
        return panel;
    }

    @Override
    public JComponent getLayerAt(int index) {
        return (JComponent)super.getLayerAt(index);
    }

    public Insets getContentInsets() {
        Rectangle selectionBounds = this.getSelectedBounds();
        Dimension size = this.getComponent().getSize();
        Insets result = new Insets(selectionBounds.y, selectionBounds.x, size.height - selectionBounds.y - selectionBounds.height, size.width - selectionBounds.x - selectionBounds.width);
        int index = this.getSelectedIndex();
        if (index < 0) {
            return result;
        }
        JComponent layer = this.getLayerAt(index);
        Border border = layer.getBorder();
        if (border != null) {
            Insets add = border.getBorderInsets(layer);
            result.left += add.left;
            result.right += add.right;
            result.top += add.top;
            result.bottom += add.bottom;
        }
        return result;
    }

    @Override
    public boolean hasBorder() {
        return true;
    }

    @Override
    public boolean isSingleTabComponent() {
        return true;
    }

    private class TabContentBorder
    extends BorderForwarder
    implements StackDockComponentContentBorder {
        private Dockable dockable;

        public TabContentBorder(Dockable dockable, JComponent target) {
            super(StackDockComponentContentBorder.KIND, "dock.border.stack.eclipse.content", target);
            this.dockable = dockable;
        }

        @Override
        public StackDockComponent getStackComponent() {
            return EclipseTabPane.this;
        }

        @Override
        public Dockable getDockable() {
            return this.dockable;
        }
    }

    private class TabPaneBorder
    extends BorderForwarder
    implements StackDockComponentBorder {
        public TabPaneBorder(JComponent target) {
            super(StackDockComponentBorder.KIND, "dock.border.stack.eclipse", target);
        }

        @Override
        public StackDockComponent getStackComponent() {
            return EclipseTabPane.this;
        }
    }

    private class WindowActiveObserver
    extends WindowAdapter
    implements HierarchyListener {
        private Window window;

        private WindowActiveObserver() {
        }

        @Override
        public void hierarchyChanged(HierarchyEvent e) {
            Window newWindow = SwingUtilities.getWindowAncestor(EclipseTabPane.this.getComponent());
            long lFlags = e.getChangeFlags();
            if (this.window != newWindow && (lFlags & 1L) != 0L) {
                if (this.window != null) {
                    this.window.removeWindowListener(this);
                }
                if (newWindow != null) {
                    EclipseTab tab;
                    newWindow.addWindowListener(this);
                    if (EclipseTabPane.this.getSelectedIndex() != -1 && (tab = (EclipseTab)EclipseTabPane.this.getTab(EclipseTabPane.this.getSelectedDockable())) != null && tab.getComponent() instanceof BaseTabComponent) {
                        ((BaseTabComponent)tab.getComponent()).updateBorder();
                        ((BaseTabComponent)tab.getComponent()).updateFocus();
                    }
                }
                this.window = newWindow;
            }
        }

        @Override
        public void windowActivated(WindowEvent e) {
            EclipseTab tab;
            if (EclipseTabPane.this.getSelectedIndex() != -1 && (tab = (EclipseTab)EclipseTabPane.this.getTab(EclipseTabPane.this.getSelectedDockable())) != null && tab.getComponent() instanceof BaseTabComponent) {
                ((BaseTabComponent)tab.getComponent()).updateBorder();
                ((BaseTabComponent)tab.getComponent()).updateFocus();
            }
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
            EclipseTab tab;
            if (EclipseTabPane.this.getSelectedIndex() != -1 && (tab = (EclipseTab)EclipseTabPane.this.getTab(EclipseTabPane.this.getSelectedDockable())) != null && tab.getComponent() instanceof BaseTabComponent) {
                ((BaseTabComponent)tab.getComponent()).updateBorder();
                ((BaseTabComponent)tab.getComponent()).updateFocus();
            }
        }
    }
}

