/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.action;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.ActionGuard;
import bibliothek.gui.dock.action.DockActionSource;

public abstract class TypedActionGuard<T extends Dockable>
implements ActionGuard {
    private Class<T> type;

    public TypedActionGuard(Class<T> type) {
        if (type == null) {
            throw new IllegalArgumentException("Type must not be null");
        }
        this.type = type;
    }

    @Override
    public boolean react(Dockable dockable) {
        return this.type.isInstance(dockable);
    }

    @Override
    public DockActionSource getSource(Dockable dockable) {
        Dockable t = dockable;
        return this.getTypedSource(t);
    }

    protected abstract DockActionSource getTypedSource(T var1);
}

