/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.action.actions;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.ActionType;
import bibliothek.gui.dock.action.SelectableDockAction;
import bibliothek.gui.dock.action.actions.GroupKeyGenerator;
import bibliothek.gui.dock.action.actions.GroupedDropDownItemAction;
import bibliothek.gui.dock.action.actions.SimpleSelectableAction;
import bibliothek.gui.dock.action.view.ActionViewConverter;
import bibliothek.gui.dock.action.view.ViewTarget;
import bibliothek.gui.dock.event.SelectableDockActionListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;

public abstract class GroupedSelectableDockAction<K>
extends GroupedDropDownItemAction<K, SimpleSelectableAction>
implements SelectableDockAction {
    private List<SelectableDockActionListener> listeners = new ArrayList<SelectableDockActionListener>();
    private ActionType<SelectableDockAction> type;
    private SelectableDockActionListener listener = new SelectableDockActionListener(){

        @Override
        public void selectedChanged(SelectableDockAction action, Set<Dockable> dockables) {
            GroupedSelectableDockAction.this.fireSelectedChanged(dockables);
        }
    };

    public GroupedSelectableDockAction(GroupKeyGenerator<? extends K> generator, ActionType<SelectableDockAction> type) {
        super(generator);
        if (type == null) {
            throw new IllegalArgumentException("Type must not be null");
        }
        this.type = type;
    }

    @Override
    public void setGroup(K key, Dockable dockable) {
        super.setGroup(key, dockable);
        this.fireSelectedChanged(dockable);
    }

    @Override
    public <V> V createView(ViewTarget<V> target, ActionViewConverter converter, Dockable dockable) {
        return converter.createView(this.type, this, target, dockable);
    }

    @Override
    public void addSelectableListener(SelectableDockActionListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeSelectableListener(SelectableDockActionListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    protected SimpleSelectableAction createGroup(K key) {
        return this.createGroup(this.listener);
    }

    @Override
    protected abstract SimpleSelectableAction createGroup(SelectableDockActionListener var1);

    protected void fireSelectedChanged(Dockable dockable) {
        HashSet<Dockable> set = new HashSet<Dockable>();
        set.add(dockable);
        this.fireSelectedChanged(set);
    }

    protected void fireSelectedChanged(Set<Dockable> dockables) {
        for (SelectableDockActionListener listener : this.listeners.toArray(new SelectableDockActionListener[this.listeners.size()])) {
            listener.selectedChanged(this, dockables);
        }
    }

    @Override
    public boolean isSelected(Dockable dockable) {
        return ((SimpleSelectableAction)this.getGroup(dockable)).isSelected(dockable);
    }

    @Override
    public void setSelected(Dockable dockable, boolean selected) {
        ((SimpleSelectableAction)this.getGroup(dockable)).setSelected(dockable, selected);
    }

    public void setSelected(K key, boolean selected) {
        ((SimpleSelectableAction)this.ensureGroup(key)).setSelected(selected);
    }

    public boolean isSelected(Object key) {
        SimpleSelectableAction action = (SimpleSelectableAction)this.getGroup(key);
        if (action == null) {
            throw new IllegalArgumentException("There is no such group");
        }
        return action.isSelected();
    }

    public void setSelectedIcon(K key, Icon icon) {
        ((SimpleSelectableAction)this.ensureGroup(key)).setSelectedIcon(icon);
    }

    public Icon getSelectedIcon(Object key) {
        SimpleSelectableAction action = (SimpleSelectableAction)this.getGroup(key);
        if (action == null) {
            throw new IllegalArgumentException("There is no such group");
        }
        return action.getSelectedIcon();
    }

    public void setDisabledSelectedIcon(K key, Icon icon) {
        ((SimpleSelectableAction)this.ensureGroup(key)).setDisabledSelectedIcon(icon);
    }

    public Icon getDisabledSelectedIcon(Object key) {
        SimpleSelectableAction action = (SimpleSelectableAction)this.getGroup(key);
        if (action == null) {
            throw new IllegalArgumentException("There is no such group");
        }
        return action.getDisabledSelectedIcon();
    }

    public static abstract class Radio<K>
    extends GroupedSelectableDockAction<K> {
        public Radio(GroupKeyGenerator<? extends K> generator) {
            super(generator, ActionType.RADIO);
        }

        @Override
        protected SimpleSelectableAction createGroup(SelectableDockActionListener listener) {
            SimpleSelectableAction.Radio action = new SimpleSelectableAction.Radio(false);
            action.addSelectableListener(listener);
            return action;
        }
    }

    public static abstract class Check<K>
    extends GroupedSelectableDockAction<K> {
        public Check(GroupKeyGenerator<? extends K> generator) {
            super(generator, ActionType.CHECK);
        }

        @Override
        protected SimpleSelectableAction createGroup(SelectableDockActionListener listener) {
            SimpleSelectableAction.Check action = new SimpleSelectableAction.Check(false);
            action.addSelectableListener(listener);
            return action;
        }
    }
}

