/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.flap;

import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.FlapDockStation;
import bibliothek.gui.dock.event.DockStationAdapter;
import bibliothek.gui.dock.station.flap.AbstractFlapLayoutManager;
import bibliothek.gui.dock.station.flap.FlapLayoutManager;
import java.util.HashMap;
import java.util.Map;

public class DefaultFlapLayoutManager
extends AbstractFlapLayoutManager
implements FlapLayoutManager {
    private Map<FlapDockStation, Station> stations = new HashMap<FlapDockStation, Station>();

    @Override
    public void install(FlapDockStation station) {
        Station properties = new Station();
        station.addDockStationListener(properties);
        properties.size = station.getDefaultWindowSize();
        this.stations.put(station, properties);
    }

    @Override
    public void uninstall(FlapDockStation station) {
        Station properties = this.stations.remove(station);
        if (properties != null) {
            station.removeDockStationListener(properties);
        }
    }

    @Override
    public int getSize(FlapDockStation station, Dockable dockable) {
        return this.stations.get((Object)station).size;
    }

    @Override
    public boolean isHold(FlapDockStation station, Dockable dockable) {
        return Boolean.TRUE.equals(this.stations.get((Object)station).hold.get(dockable));
    }

    @Override
    public void setHold(FlapDockStation station, Dockable dockable, boolean hold) {
        this.stations.get((Object)station).hold.put(dockable, hold);
    }

    @Override
    public void setSize(FlapDockStation station, Dockable dockable, int size) {
        this.stations.get((Object)station).size = size;
    }

    @Override
    public boolean isHoldSwitchable(FlapDockStation station, Dockable dockable) {
        Boolean result = this.stations.get((Object)station).switchable.get(dockable);
        if (result == null) {
            return true;
        }
        return result;
    }

    public void setHoldSwitchable(FlapDockStation station, Dockable dockable, boolean switchable) {
        this.stations.get((Object)station).switchable.put(dockable, switchable);
        this.fireHoldSwitchableChanged(station, dockable);
    }

    private static class Station
    extends DockStationAdapter {
        public Map<Dockable, Boolean> hold = new HashMap<Dockable, Boolean>();
        public Map<Dockable, Boolean> switchable = new HashMap<Dockable, Boolean>();
        public int size;

        private Station() {
        }

        @Override
        public void dockableRemoved(DockStation station, Dockable dockable) {
            this.hold.remove(dockable);
            this.switchable.remove(dockable);
        }
    }
}

