/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.util;

import bibliothek.gui.DockController;
import bibliothek.gui.dock.themes.ThemeManager;
import bibliothek.gui.dock.util.BackgroundAlgorithmListener;
import bibliothek.gui.dock.util.BackgroundComponent;
import bibliothek.gui.dock.util.BackgroundPaint;
import bibliothek.gui.dock.util.PaintableComponent;
import bibliothek.gui.dock.util.Transparency;
import bibliothek.util.Path;
import java.awt.Component;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.List;

public abstract class BackgroundAlgorithm
implements BackgroundComponent {
    private Path kind;
    private String id;
    private DockController controller;
    private BackgroundPaint paint;
    private List<BackgroundAlgorithmListener> listeners = new ArrayList<BackgroundAlgorithmListener>(2);
    private Transparency transparency = Transparency.DEFAULT;

    public BackgroundAlgorithm(Path kind, String id) {
        this.kind = kind;
        this.id = id;
    }

    public void addListener(BackgroundAlgorithmListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(BackgroundAlgorithmListener listener) {
        this.listeners.remove(listener);
    }

    public void setController(DockController controller) {
        if (this.controller != null) {
            this.controller.getThemeManager().remove(this);
        }
        this.controller = controller;
        if (this.controller != null) {
            this.controller.getThemeManager().add(this.id, this.kind, ThemeManager.BACKGROUND_PAINT_TYPE, this);
        } else {
            this.set(null);
        }
    }

    @Override
    public void repaint() {
        this.getComponent().repaint();
    }

    @Override
    public void set(BackgroundPaint value) {
        if (this.paint != null) {
            this.paint.uninstall(this);
        }
        this.paint = value;
        if (this.paint != null) {
            this.paint.install(this);
        }
    }

    @Override
    public void setTransparency(Transparency transparency) {
        if (transparency == null) {
            throw new IllegalArgumentException("transparency must not be null");
        }
        if (this.transparency != transparency) {
            this.transparency = transparency;
            for (BackgroundAlgorithmListener listener : this.listeners.toArray(new BackgroundAlgorithmListener[this.listeners.size()])) {
                listener.transparencyChanged(this, this.transparency);
            }
        }
    }

    @Override
    public Transparency getTransparency() {
        return this.transparency;
    }

    public BackgroundPaint getPaint() {
        return this.paint;
    }

    public void paint(PaintableComponent component, Graphics g) {
        if (this.paint == null) {
            component.paintBackground(g);
            component.paintForeground(g);
            component.paintBorder(g);
            component.paintChildren(g);
            component.paintOverlay(g);
        } else {
            Paintable paintable = new Paintable(component);
            paintable.paint(g);
        }
    }

    private class Paintable
    implements PaintableComponent {
        private PaintableComponent delegate;
        private boolean backgroundPainted = false;
        private boolean foregroundPainted = false;
        private boolean borderPainted = false;
        private boolean childrenPainted = false;
        private boolean overlayPainted = false;

        public Paintable(PaintableComponent delegate) {
            this.delegate = delegate;
        }

        @Override
        public Component getComponent() {
            return this.delegate.getComponent();
        }

        @Override
        public void paintBackground(Graphics g) {
            this.backgroundPainted = true;
            if (g != null) {
                this.delegate.paintBackground(g);
            }
        }

        @Override
        public void paintForeground(Graphics g) {
            this.foregroundPainted = true;
            if (g != null) {
                this.delegate.paintForeground(g);
            }
        }

        @Override
        public void paintBorder(Graphics g) {
            this.borderPainted = true;
            if (g != null) {
                this.delegate.paintBorder(g);
            }
        }

        @Override
        public void paintChildren(Graphics g) {
            this.childrenPainted = true;
            if (g != null) {
                this.delegate.paintChildren(g);
            }
        }

        @Override
        public void paintOverlay(Graphics g) {
            this.overlayPainted = true;
            if (g != null) {
                this.delegate.paintOverlay(g);
            }
        }

        @Override
        public Transparency getTransparency() {
            return this.delegate.getTransparency();
        }

        public void paint(Graphics g) {
            BackgroundAlgorithm.this.paint.paint(BackgroundAlgorithm.this, this, g);
            if (!this.backgroundPainted) {
                this.paintBackground(g);
            }
            if (!this.foregroundPainted) {
                this.paintForeground(g);
            }
            if (!this.borderPainted) {
                this.paintBorder(g);
            }
            if (!this.childrenPainted) {
                this.paintChildren(g);
            }
            if (!this.overlayPainted) {
                this.paintOverlay(g);
            }
        }
    }
}

