/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.math.stats.distribution;

import java.io.Serializable;

public interface Distribution
extends Serializable {
    public int length();

    public double mean();

    public double variance();

    default public double sd() {
        return Math.sqrt(this.variance());
    }

    public double entropy();

    public double rand();

    default public double[] rand(int n) {
        double[] data = new double[n];
        for (int i = 0; i < n; ++i) {
            data[i] = this.rand();
        }
        return data;
    }

    public double p(double var1);

    public double logp(double var1);

    public double cdf(double var1);

    public double quantile(double var1);

    default public double likelihood(double[] x) {
        return Math.exp(this.logLikelihood(x));
    }

    default public double logLikelihood(double[] x) {
        double L = 0.0;
        for (double xi : x) {
            L += this.logp(xi);
        }
        return L;
    }
}

