/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.data.meteodata.radar;

import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteOrder;
import org.meteoinfo.common.DataConvert;

public class RadialHeader {
    public static int length = 64;
    public int radialState;
    public int spotBlank;
    public int sequenceNumber;
    public int radialNumber;
    public int elevationNumber;
    public float azimuth;
    public float elevation;
    public int seconds;
    public int microSeconds;
    public int lengthOfData;
    public int momentNumber;
    public byte[] reserved;
    public short horizontalEstimatedNoise;
    public short verticalEstimatedNoise;
    public byte[] reserved2;

    public RadialHeader(RandomAccessFile raf) throws IOException {
        byte[] bytes = new byte[4];
        raf.read(bytes);
        this.radialState = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.spotBlank = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.sequenceNumber = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.radialNumber = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.elevationNumber = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.azimuth = DataConvert.bytes2Float((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.elevation = DataConvert.bytes2Float((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.seconds = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.microSeconds = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.lengthOfData = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.momentNumber = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        this.reserved = new byte[2];
        raf.read(this.reserved);
        bytes = new byte[2];
        raf.read(bytes);
        this.horizontalEstimatedNoise = DataConvert.bytes2Short((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.verticalEstimatedNoise = DataConvert.bytes2Short((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        this.reserved2 = new byte[14];
        raf.read(this.reserved2);
    }

    public RadialHeader(InputStream raf) throws IOException {
        byte[] bytes = new byte[4];
        raf.read(bytes);
        this.radialState = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.spotBlank = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.sequenceNumber = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.radialNumber = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.elevationNumber = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.azimuth = DataConvert.bytes2Float((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.elevation = DataConvert.bytes2Float((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.seconds = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.microSeconds = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.lengthOfData = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.momentNumber = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        this.reserved = new byte[2];
        raf.read(this.reserved);
        bytes = new byte[2];
        raf.read(bytes);
        this.horizontalEstimatedNoise = DataConvert.bytes2Short((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.verticalEstimatedNoise = DataConvert.bytes2Short((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        this.reserved2 = new byte[14];
        raf.read(this.reserved2);
    }

    public RadialHeader(byte[] inBytes) throws IOException {
        int idx = 0;
        byte[] bytes = new byte[4];
        System.arraycopy(inBytes, idx, bytes, 0, 4);
        this.radialState = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        System.arraycopy(inBytes, idx += 4, bytes, 0, 4);
        this.spotBlank = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        System.arraycopy(inBytes, idx += 4, bytes, 0, 4);
        this.sequenceNumber = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        System.arraycopy(inBytes, idx += 4, bytes, 0, 4);
        this.radialNumber = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        System.arraycopy(inBytes, idx += 4, bytes, 0, 4);
        this.elevationNumber = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        System.arraycopy(inBytes, idx += 4, bytes, 0, 4);
        this.azimuth = DataConvert.bytes2Float((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        System.arraycopy(inBytes, idx += 4, bytes, 0, 4);
        this.elevation = DataConvert.bytes2Float((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        System.arraycopy(inBytes, idx += 4, bytes, 0, 4);
        this.seconds = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        System.arraycopy(inBytes, idx += 4, bytes, 0, 4);
        this.microSeconds = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        System.arraycopy(inBytes, idx += 4, bytes, 0, 4);
        this.lengthOfData = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        System.arraycopy(inBytes, idx += 4, bytes, 0, 4);
        this.momentNumber = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        this.reserved = new byte[2];
        System.arraycopy(inBytes, idx += 4, this.reserved, 0, 2);
        bytes = new byte[2];
        System.arraycopy(inBytes, idx += 2, bytes, 0, 2);
        this.horizontalEstimatedNoise = DataConvert.bytes2Short((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        System.arraycopy(inBytes, idx += 2, this.reserved, 0, 2);
        this.verticalEstimatedNoise = DataConvert.bytes2Short((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        this.reserved2 = new byte[14];
        System.arraycopy(inBytes, idx += 2, this.reserved2, 0, 14);
    }
}

