/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.data.meteodata.radar;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;
import java.time.LocalDateTime;
import org.meteoinfo.common.DataConvert;

public class TaskConfig {
    public static int length = 256;
    public String taskName;
    public String taskDescription;
    public int polarizationType;
    public int scanType;
    public int pulseWidth;
    public LocalDateTime scanStartTime;
    public int cutNumber;
    public float horizontalNoise;
    public float verticalNoise;
    public float horizontalCalibration;
    public float verticalCalibration;
    public float horizontalNoiseTemperature;
    public float verticalNoiseTemperature;
    public float ZDRCalibration;
    public float PHIDRCalibration;
    public float LDRCalibration;
    public byte[] reserves;

    public TaskConfig(InputStream raf) throws IOException {
        byte[] bytes = new byte[32];
        raf.read(bytes);
        this.taskName = new String(bytes).trim();
        bytes = new byte[128];
        raf.read(bytes);
        this.taskDescription = new String(bytes).trim();
        bytes = new byte[4];
        raf.read(bytes);
        this.polarizationType = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.scanType = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.pulseWidth = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        int seconds = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        LocalDateTime dt = LocalDateTime.of(1970, 1, 1, 0, 0);
        this.scanStartTime = dt.plusSeconds(seconds);
        raf.read(bytes);
        this.cutNumber = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.horizontalNoise = DataConvert.bytes2Float((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.verticalNoise = DataConvert.bytes2Float((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.horizontalCalibration = DataConvert.bytes2Float((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.verticalCalibration = DataConvert.bytes2Float((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.horizontalNoiseTemperature = DataConvert.bytes2Float((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.verticalNoiseTemperature = DataConvert.bytes2Float((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.ZDRCalibration = DataConvert.bytes2Float((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.PHIDRCalibration = DataConvert.bytes2Float((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.LDRCalibration = DataConvert.bytes2Float((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        this.reserves = new byte[40];
        raf.read(this.reserves);
    }
}

