/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.array;

import java.util.Arrays;
import java.util.Comparator;
import org.ojalgo.array.DenseArray;
import org.ojalgo.array.ReferenceTypeArray;
import org.ojalgo.array.operation.AMAX;
import org.ojalgo.array.operation.AXPY;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.structure.Access1D;
import org.ojalgo.structure.Mutate1D;

public abstract class ScalarArray<N extends Scalar<N>>
extends ReferenceTypeArray<N> {
    protected ScalarArray(DenseArray.Factory<N> factory, int length) {
        super(factory, length);
    }

    protected ScalarArray(DenseArray.Factory<N> factory, N[] data) {
        super(factory, data);
    }

    @Override
    public final void axpy(double a, Mutate1D.Modifiable<?> y) {
        AXPY.invoke(y, (double)a, (Scalar[])((Scalar[])this.data));
    }

    @Override
    public final void sortAscending() {
        Arrays.parallelSort((Comparable[])((Scalar[])this.data));
    }

    @Override
    public final void sortDescending() {
        Arrays.parallelSort((Scalar[])this.data, Comparator.reverseOrder());
    }

    @Override
    protected final void add(int index, Comparable<?> addend) {
        this.fillOne(index, (Scalar)((Scalar)this.get(index)).add((Scalar)this.valueOf(addend)).get());
    }

    @Override
    protected final void add(int index, double addend) {
        this.fillOne(index, (Scalar)((Scalar)this.get(index)).add((Scalar)this.valueOf(addend)).get());
    }

    @Override
    protected byte byteValue(int index) {
        return ((Scalar)this.get(index)).byteValue();
    }

    @Override
    protected final double doubleValue(int index) {
        return ((Scalar[])this.data)[index].doubleValue();
    }

    @Override
    protected final void fillOne(int index, Access1D<?> values, long valueIndex) {
        ((Scalar[])this.data)[index] = (Scalar)this.valueOf((Comparable<?>)values.get(valueIndex));
    }

    @Override
    protected final float floatValue(int index) {
        return ((Scalar[])this.data)[index].floatValue();
    }

    @Override
    protected final int indexOfLargest(int first, int limit, int step) {
        return AMAX.invoke((Scalar[])((Scalar[])this.data), (int)first, (int)limit, (int)step);
    }

    @Override
    protected int intValue(int index) {
        return ((Scalar)this.get(index)).intValue();
    }

    @Override
    protected final boolean isAbsolute(int index) {
        return ((Scalar[])this.data)[index].isAbsolute();
    }

    @Override
    protected final boolean isSmall(int index, double comparedTo) {
        return ((Scalar[])this.data)[index].isSmall(comparedTo);
    }

    @Override
    protected long longValue(int index) {
        return ((Scalar)this.get(index)).longValue();
    }

    @Override
    protected short shortValue(int index) {
        return ((Scalar)this.get(index)).shortValue();
    }

    @Override
    protected void set(int index, long value) {
        ((Scalar[])this.data)[index] = (Scalar)this.valueOf(value);
    }
}

