/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.decomposition;

import org.ojalgo.RecoverableCondition;
import org.ojalgo.array.Array1D;
import org.ojalgo.array.operation.AXPY;
import org.ojalgo.array.operation.DOT;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.matrix.decomposition.RawDecomposition;
import org.ojalgo.matrix.decomposition.SingularValue;
import org.ojalgo.matrix.decomposition.SingularValueDecomposition;
import org.ojalgo.matrix.decomposition.function.ExchangeColumns;
import org.ojalgo.matrix.decomposition.function.NegateColumn;
import org.ojalgo.matrix.decomposition.function.RotateRight;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.Primitive64Store;
import org.ojalgo.matrix.store.RawStore;
import org.ojalgo.structure.Access1D;
import org.ojalgo.structure.Access2D;
import org.ojalgo.structure.Structure2D;

final class RawSingularValue
extends RawDecomposition
implements SingularValue<Double> {
    private double[] e;
    private int m;
    private int n;
    private transient Primitive64Store myPseudoinverse = null;
    private boolean myTransposed;
    private double[][] myUt;
    private double[][] myVt;
    private double[] s;
    private double[] w;

    RawSingularValue() {
    }

    @Override
    public boolean computeValuesOnly(Access2D.Collectable<Double, ? super PhysicalStore<Double>> matrix) {
        return this.doDecompose(matrix, false);
    }

    @Override
    public int countSignificant(double threshold) {
        int significant = 0;
        for (int i = 0; i < this.s.length; ++i) {
            if (!(this.s[i] > threshold)) continue;
            ++significant;
        }
        return significant;
    }

    @Override
    public boolean decompose(Access2D.Collectable<Double, ? super PhysicalStore<Double>> matrix) {
        return this.doDecompose(matrix, true);
    }

    @Override
    public double getCondition() {
        return this.s[0] / this.s[this.n - 1];
    }

    @Override
    public MatrixStore<Double> getCovariance() {
        MatrixStore<Double> v = this.getV();
        Array1D<Double> values = this.getSingularValues();
        int rank = this.getRank();
        MatrixStore tmp = (MatrixStore)v.limits(-1L, rank).onColumns(PrimitiveMath.DIVIDE, values).collect(v.physical());
        return tmp.multiply(tmp.transpose());
    }

    @Override
    public MatrixStore<Double> getD() {
        return RawDecomposition.makeDiagonal(this.getSingularValues()).get();
    }

    @Override
    public double getFrobeniusNorm() {
        double retVal = PrimitiveMath.ZERO;
        for (int i = this.n - 1; i >= 0; --i) {
            double tmpVal = this.s[i];
            retVal += tmpVal * tmpVal;
        }
        return PrimitiveMath.SQRT.invoke(retVal);
    }

    @Override
    public MatrixStore<Double> getInverse() {
        return this.doGetInverse(this.allocate(this.getColDim(), this.getRowDim()));
    }

    @Override
    public MatrixStore<Double> getInverse(PhysicalStore<Double> preallocated) {
        return this.doGetInverse((Primitive64Store)preallocated);
    }

    @Override
    public double getKyFanNorm(int k) {
        double retVal = PrimitiveMath.ZERO;
        for (int i = Math.min(this.s.length, k) - 1; i >= 0; --i) {
            retVal += this.s[i];
        }
        return retVal;
    }

    @Override
    public double getOperatorNorm() {
        return this.s[0];
    }

    @Override
    public double getRankThreshold() {
        return Math.max(Double.MIN_NORMAL, this.s[0]) * this.getDimensionalEpsilon();
    }

    @Override
    public Array1D<Double> getSingularValues() {
        return Array1D.R064.copy(this.s);
    }

    @Override
    public void getSingularValues(double[] values) {
        System.arraycopy(this.s, 0, values, 0, Math.min(this.s.length, values.length));
    }

    @Override
    public MatrixStore<Double> getSolution(Access2D.Collectable<Double, ? super PhysicalStore<Double>> rhs) {
        return this.getSolution(rhs, this.allocate(this.getMinDim(), rhs.countColumns()));
    }

    @Override
    public MatrixStore<Double> getSolution(Access2D.Collectable<Double, ? super PhysicalStore<Double>> rhs, PhysicalStore<Double> preallocated) {
        preallocated.fillByMultiplying(this.getInverse(), this.collect(rhs));
        return preallocated;
    }

    @Override
    public double getTraceNorm() {
        return this.getKyFanNorm(this.s.length);
    }

    @Override
    public MatrixStore<Double> getU() {
        return this.myTransposed ? this.wrap(this.myVt).transpose() : this.wrap(this.myUt).transpose();
    }

    @Override
    public MatrixStore<Double> getV() {
        return this.myTransposed ? this.wrap(this.myUt).transpose() : this.wrap(this.myVt).transpose();
    }

    @Override
    public MatrixStore<Double> invert(Access2D<?> original, PhysicalStore<Double> preallocated) throws RecoverableCondition {
        this.doDecompose(original.asCollectable2D(), true);
        if (this.isSolvable()) {
            return this.getInverse(preallocated);
        }
        throw RecoverableCondition.newMatrixNotInvertible();
    }

    @Override
    public boolean isFullRank() {
        return this.s[this.s.length - 1] > this.getRankThreshold();
    }

    @Override
    public boolean isFullSize() {
        return false;
    }

    @Override
    public boolean isOrdered() {
        return true;
    }

    @Override
    public boolean isSolvable() {
        return super.isSolvable();
    }

    @Override
    public PhysicalStore<Double> preallocate(Structure2D template) {
        return this.allocate(template.countColumns(), template.countRows());
    }

    @Override
    public PhysicalStore<Double> preallocate(Structure2D templateBody, Structure2D templateRHS) {
        return this.allocate(templateBody.countColumns(), templateRHS.countColumns());
    }

    @Override
    public void reset() {
        super.reset();
        this.myPseudoinverse = null;
    }

    @Override
    public MatrixStore<Double> solve(Access2D<?> body, Access2D<?> rhs, PhysicalStore<Double> preallocated) throws RecoverableCondition {
        this.doDecompose(body.asCollectable2D(), true);
        if (this.isSolvable()) {
            return this.getSolution(rhs.asCollectable2D(), preallocated);
        }
        throw RecoverableCondition.newEquationSystemNotSolvable();
    }

    @Override
    protected boolean checkSolvability() {
        return true;
    }

    boolean doDecompose(Access2D.Collectable<Double, ? super PhysicalStore<Double>> matrix, boolean factors) {
        int j;
        int k;
        int i;
        double tmpVal;
        int j2;
        double[] tmpArr;
        this.myTransposed = matrix.countRows() < matrix.countColumns();
        double[][] input = this.reset(matrix, !this.myTransposed);
        if (this.myTransposed) {
            matrix.supplyTo(this.getInternalStore());
        } else {
            this.collect(matrix).transpose().supplyTo(this.getInternalStore());
        }
        this.m = this.getMaxDim();
        this.n = this.getMinDim();
        if (this.s == null || this.s.length != this.n) {
            this.s = new double[this.n];
            this.e = new double[this.n];
        }
        if (this.w == null || this.w.length != this.m) {
            this.w = new double[this.m];
        }
        if (factors) {
            this.myUt = input;
            if (this.myVt == null || this.myVt.length != this.n || this.myVt[0].length != this.n) {
                this.myVt = new double[this.n][this.n];
            }
        } else {
            this.myUt = null;
            this.myVt = null;
        }
        double nrm = PrimitiveMath.ZERO;
        int nct = Math.min(this.m - 1, this.n);
        int nrt = Math.max(0, this.n - 2);
        int limit = Math.max(nct, nrt);
        for (int k2 = 0; k2 < limit; ++k2) {
            int i2;
            tmpArr = input[k2];
            if (k2 < nct) {
                nrm = PrimitiveMath.ZERO;
                for (i2 = k2; i2 < this.m; ++i2) {
                    nrm = PrimitiveMath.HYPOT.invoke(nrm, tmpArr[i2]);
                }
                if (nrm != PrimitiveMath.ZERO) {
                    if (tmpArr[k2] < PrimitiveMath.ZERO) {
                        nrm = -nrm;
                    }
                    i2 = k2;
                    while (i2 < this.m) {
                        int n = i2++;
                        tmpArr[n] = tmpArr[n] / nrm;
                    }
                    int n = k2;
                    tmpArr[n] = tmpArr[n] + PrimitiveMath.ONE;
                    for (j2 = k2 + 1; j2 < this.n; ++j2) {
                        tmpVal = DOT.invoke(tmpArr, 0, input[j2], 0, k2, this.m);
                        AXPY.invoke(input[j2], 0, -(tmpVal /= tmpArr[k2]), tmpArr, 0, k2, this.m);
                    }
                }
                this.s[k2] = -nrm;
            }
            for (j2 = k2 + 1; j2 < this.n; ++j2) {
                this.e[j2] = input[j2][k2];
            }
            if (factors && k2 < nct) {
                for (i2 = k2; i2 < this.m; ++i2) {
                    this.myUt[k2][i2] = tmpArr[i2];
                }
            }
            if (k2 >= nrt) continue;
            nrm = PrimitiveMath.ZERO;
            for (i2 = k2 + 1; i2 < this.n; ++i2) {
                nrm = PrimitiveMath.HYPOT.invoke(nrm, this.e[i2]);
            }
            if (nrm != PrimitiveMath.ZERO) {
                if (this.e[k2 + 1] < PrimitiveMath.ZERO) {
                    nrm = -nrm;
                }
                i2 = k2 + 1;
                while (i2 < this.n) {
                    int n = i2++;
                    this.e[n] = this.e[n] / nrm;
                }
                int n = k2 + 1;
                this.e[n] = this.e[n] + PrimitiveMath.ONE;
                for (i2 = k2 + 1; i2 < this.m; ++i2) {
                    this.w[i2] = PrimitiveMath.ZERO;
                }
                for (j2 = k2 + 1; j2 < this.n; ++j2) {
                    AXPY.invoke(this.w, 0, this.e[j2], input[j2], 0, k2 + 1, this.m);
                }
                for (j2 = k2 + 1; j2 < this.n; ++j2) {
                    AXPY.invoke(input[j2], 0, -(this.e[j2] / this.e[k2 + 1]), this.w, 0, k2 + 1, this.m);
                }
            }
            this.e[k2] = -nrm;
            if (!factors) continue;
            for (i2 = k2 + 1; i2 < this.n; ++i2) {
                this.myVt[k2][i2] = this.e[i2];
            }
        }
        int p = this.n;
        if (nct < this.n) {
            this.s[nct] = input[nct][nct];
        }
        if (nrt + 1 < p) {
            this.e[nrt] = input[p - 1][nrt];
        }
        this.e[p - 1] = PrimitiveMath.ZERO;
        if (factors) {
            for (j2 = nct; j2 < this.n; ++j2) {
                tmpArr = this.myUt[j2];
                for (i = 0; i < this.m; ++i) {
                    tmpArr[i] = PrimitiveMath.ZERO;
                }
                tmpArr[j2] = PrimitiveMath.ONE;
            }
            for (k = nct - 1; k >= 0; --k) {
                tmpArr = this.myUt[k];
                if (this.s[k] != PrimitiveMath.ZERO) {
                    for (j = k + 1; j < this.n; ++j) {
                        tmpVal = DOT.invoke(tmpArr, 0, this.myUt[j], 0, k, this.m);
                        AXPY.invoke(this.myUt[j], 0, -(tmpVal /= tmpArr[k]), tmpArr, 0, k, this.m);
                    }
                    for (i = 0; i < k; ++i) {
                        tmpArr[i] = PrimitiveMath.ZERO;
                    }
                    tmpArr[k] = PrimitiveMath.ONE - tmpArr[k];
                    for (i = k + 1; i < this.m; ++i) {
                        tmpArr[i] = -tmpArr[i];
                    }
                    continue;
                }
                for (i = 0; i < this.m; ++i) {
                    tmpArr[i] = PrimitiveMath.ZERO;
                }
                tmpArr[k] = PrimitiveMath.ONE;
            }
        }
        if (factors) {
            for (k = this.n - 1; k >= 0; --k) {
                tmpArr = this.myVt[k];
                if (k < nrt && this.e[k] != PrimitiveMath.ZERO) {
                    for (j = k + 1; j < this.n; ++j) {
                        tmpVal = DOT.invoke(tmpArr, 0, this.myVt[j], 0, k + 1, this.n);
                        AXPY.invoke(this.myVt[j], 0, -(tmpVal /= tmpArr[k + 1]), tmpArr, 0, k + 1, this.n);
                    }
                }
                for (i = 0; i < this.n; ++i) {
                    tmpArr[i] = PrimitiveMath.ZERO;
                }
                tmpArr[k] = PrimitiveMath.ONE;
            }
        }
        RotateRight q1RotR = factors ? (low, high, cos, sin) -> {
            double[] colLow = this.myUt[low];
            double[] colHigh = this.myUt[high];
            for (int i = 0; i < this.m; ++i) {
                double valLow = colLow[i];
                double valHigh = colHigh[i];
                colLow[i] = -sin * valHigh + cos * valLow;
                colHigh[i] = cos * valHigh + sin * valLow;
            }
        } : RotateRight.NULL;
        RotateRight q2RotR = factors ? (low, high, cos, sin) -> {
            double[] colLow = this.myVt[low];
            double[] colHigh = this.myVt[high];
            for (int i = 0; i < this.n; ++i) {
                double valLow = colLow[i];
                double valHigh = colHigh[i];
                colLow[i] = -sin * valHigh + cos * valLow;
                colHigh[i] = cos * valHigh + sin * valLow;
            }
        } : RotateRight.NULL;
        ExchangeColumns q1XchgCols = factors ? (colA, colB) -> {
            double[] col1 = this.myUt[colA];
            double[] col2 = this.myUt[colB];
            for (int i = 0; i < this.m; ++i) {
                double tmp = col1[i];
                col1[i] = col2[i];
                col2[i] = tmp;
            }
        } : ExchangeColumns.NULL;
        ExchangeColumns q2XchgCols = factors ? (colA, colB) -> {
            double[] col1 = this.myVt[colA];
            double[] col2 = this.myVt[colB];
            for (int i = 0; i < this.n; ++i) {
                double tmp = col1[i];
                col1[i] = col2[i];
                col2[i] = tmp;
            }
        } : ExchangeColumns.NULL;
        NegateColumn q2NegCol = factors ? col -> {
            double[] column = this.myVt[col];
            for (int i = 0; i < column.length; ++i) {
                column[i] = -column[i];
            }
        } : NegateColumn.NULL;
        SingularValueDecomposition.toDiagonal(this.s, this.e, q1RotR, q2RotR, q1XchgCols, q2XchgCols, q2NegCol);
        return this.computed(true);
    }

    MatrixStore<Double> doGetInverse(Primitive64Store preallocated) {
        if (this.myPseudoinverse == null) {
            double[][] tmpQ1t = this.myTransposed ? this.myVt : this.myUt;
            double[] tmpSingular = this.s;
            RawStore tmpMtrx = this.newRawStore(tmpSingular.length, tmpQ1t[0].length);
            double[][] tmpMtrxData = tmpMtrx.data;
            double small = this.getRankThreshold();
            for (int i = 0; i < tmpSingular.length; ++i) {
                double tmpVal = tmpSingular[i];
                if (!(tmpVal > small)) continue;
                double[] tmpRow = tmpMtrxData[i];
                for (int j = 0; j < tmpRow.length; ++j) {
                    tmpRow[j] = tmpQ1t[i][j] / tmpVal;
                }
            }
            MatrixStore<Double> mtrxQ2 = this.getV();
            preallocated.fillByMultiplying((Access1D<Double>)mtrxQ2, tmpMtrx);
            this.myPseudoinverse = preallocated;
        }
        return this.myPseudoinverse;
    }
}

