/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.optimisation.service;

import org.ojalgo.netio.BasicLogger;
import org.ojalgo.netio.InMemoryFile;
import org.ojalgo.netio.ServiceClient;
import org.ojalgo.optimisation.ExpressionsBasedModel;
import org.ojalgo.optimisation.Optimisation;

public abstract class OptimisationService {
    public static Integration newIntegration(String host) {
        return new Integration(host);
    }

    public static final class Solver
    implements Optimisation.Solver {
        private static final String PATH_MAXIMISE = "/optimisation/v01/maximise";
        private static final String PATH_MINIMISE = "/optimisation/v01/minimise";
        private final String myHost;
        private final ExpressionsBasedModel myModel;
        private final Optimisation.Sense myOptimisationSense;

        Solver(ExpressionsBasedModel model, String host) {
            this.myModel = model;
            this.myOptimisationSense = model.getOptimisationSense();
            this.myHost = host;
        }

        @Override
        public Optimisation.Result solve(Optimisation.Result kickStarter) {
            InMemoryFile file = new InMemoryFile();
            this.myModel.simplify().writeTo(file);
            ServiceClient.Response<String> response = this.myOptimisationSense == Optimisation.Sense.MAX ? ServiceClient.post(this.myHost + PATH_MAXIMISE, file.getContentsAsByteArray()) : ServiceClient.post(this.myHost + PATH_MINIMISE, file.getContentsAsByteArray());
            String responseBody = response.getBody();
            return Optimisation.Result.parse(responseBody);
        }
    }

    public static final class Integration
    extends ExpressionsBasedModel.Integration<Solver> {
        private static final String PATH_TEST = "/optimisation/v01/test";
        private Boolean myCapable = null;
        private final String myHost;

        Integration(String host) {
            this.myHost = host;
        }

        @Override
        public Solver build(ExpressionsBasedModel model) {
            return new Solver(model, this.myHost);
        }

        @Override
        public boolean isCapable(ExpressionsBasedModel model) {
            if (this.myCapable == null) {
                ServiceClient.Response<String> response = ServiceClient.get(this.myHost + PATH_TEST);
                if (response.isResponseOK() && response.getBody().contains("VALID")) {
                    this.myCapable = Boolean.TRUE;
                } else {
                    BasicLogger.error("Calling {} failed!", this.myHost + PATH_TEST);
                    this.myCapable = Boolean.FALSE;
                }
            }
            return this.myCapable;
        }

        @Override
        protected boolean isSolutionMapped() {
            return false;
        }
    }
}

