/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.random.process;

import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.random.Normal;
import org.ojalgo.random.Normal1D;
import org.ojalgo.random.process.GaussianField;
import org.ojalgo.random.process.MultipleValuesBasedProcess;
import org.ojalgo.random.process.Process1D;

public final class GaussianProcess
extends MultipleValuesBasedProcess<Normal>
implements Process1D.ComponentProcess<Normal> {
    private static final Normal GENERATOR = new Normal();
    private final GaussianField<Double> myDelegate;

    public GaussianProcess(GaussianField.Covariance<Double> covarFunc) {
        this.myDelegate = new GaussianField<Double>(covarFunc, this.getObservations());
    }

    public GaussianProcess(GaussianField.Mean<Double> meanFunc, GaussianField.Covariance<Double> covarFunc) {
        this.myDelegate = new GaussianField<Double>(meanFunc, covarFunc, this.getObservations());
    }

    private GaussianProcess() {
        this(null, null);
    }

    public void calibrate() {
        this.myDelegate.calibrate();
    }

    @Override
    public Normal getDistribution(double evaluationPoint) {
        Normal1D tmpVal = this.getDistribution(new Double[]{evaluationPoint});
        double tmpLocation = tmpVal.getExpected().doubleValue(0L);
        double tmpScale = tmpVal.getStandardDeviation().doubleValue(0L);
        return new Normal(tmpLocation, tmpScale);
    }

    public Normal1D getDistribution(Double ... evaluationPoint) {
        return this.myDelegate.getDistribution(false, evaluationPoint);
    }

    @Override
    public double getValue() {
        return this.getCurrentValue();
    }

    @Override
    public void setValue(double newValue) {
        this.setCurrentValue(newValue);
    }

    @Override
    public double step(double stepSize, double standardGaussianInnovation) {
        return this.doStep(stepSize, standardGaussianInnovation);
    }

    @Override
    double doStep(double stepSize, double normalisedRandomIncrement) {
        Normal distr = this.getDistribution(stepSize);
        double retVal = normalisedRandomIncrement * distr.getStandardDeviation() + distr.getExpected();
        this.addObservation((Double)this.getObservations().last().getKey() + stepSize, retVal);
        return retVal;
    }

    MatrixStore<Double> getCovariances() {
        return this.myDelegate.getC22().reconstruct();
    }

    @Override
    double getExpected(double stepSize) {
        return this.getDistribution(stepSize).getExpected();
    }

    @Override
    double getLowerConfidenceQuantile(double stepSize, double confidence) {
        return this.getDistribution(stepSize).getLowerConfidenceQuantile(confidence);
    }

    @Override
    double getNormalisedRandomIncrement() {
        return GENERATOR.doubleValue();
    }

    @Override
    double getStandardDeviation(double stepSize) {
        return this.getDistribution(stepSize).getStandardDeviation();
    }

    @Override
    double getUpperConfidenceQuantile(double stepSize, double confidence) {
        return this.getDistribution(stepSize).getUpperConfidenceQuantile(confidence);
    }

    @Override
    double getVariance(double stepSize) {
        return this.getDistribution(stepSize).getVariance();
    }
}

