/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.series;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.ojalgo.ProgrammingError;
import org.ojalgo.array.DenseArray;
import org.ojalgo.function.BinaryFunction;
import org.ojalgo.series.MappedIndexSeries;
import org.ojalgo.series.primitive.CoordinatedSet;
import org.ojalgo.series.primitive.DataSeries;
import org.ojalgo.series.primitive.PrimitiveSeries;
import org.ojalgo.structure.Structure1D;
import org.ojalgo.type.CalendarDate;
import org.ojalgo.type.ColourData;
import org.ojalgo.type.NumberDefinition;
import org.ojalgo.type.TimeIndex;
import org.ojalgo.type.keyvalue.EntryPair;

public interface BasicSeries<K extends Comparable<? super K>, V extends Comparable<V>>
extends SortedMap<K, V> {
    public static final TimeSeriesBuilder<Calendar> CALENDAR = new TimeSeriesBuilder<Calendar>(TimeIndex.CALENDAR);
    public static final TimeSeriesBuilder<CalendarDate> CALENDAR_DATE = new TimeSeriesBuilder<CalendarDate>(TimeIndex.CALENDAR_DATE);
    public static final TimeSeriesBuilder<Date> DATE = new TimeSeriesBuilder<Date>(TimeIndex.DATE);
    public static final TimeSeriesBuilder<Instant> INSTANT = new TimeSeriesBuilder<Instant>(TimeIndex.INSTANT);
    public static final TimeSeriesBuilder<LocalDate> LOCAL_DATE = new TimeSeriesBuilder<LocalDate>(TimeIndex.LOCAL_DATE);
    public static final TimeSeriesBuilder<LocalDateTime> LOCAL_DATE_TIME = new TimeSeriesBuilder<LocalDateTime>(TimeIndex.LOCAL_DATE_TIME);
    public static final TimeSeriesBuilder<LocalTime> LOCAL_TIME = new TimeSeriesBuilder<LocalTime>(TimeIndex.LOCAL_TIME);
    public static final TimeSeriesBuilder<OffsetDateTime> OFFSET_DATE_TIME = new TimeSeriesBuilder<OffsetDateTime>(TimeIndex.OFFSET_DATE_TIME);
    public static final TimeSeriesBuilder<ZonedDateTime> ZONED_DATE_TIME = new TimeSeriesBuilder<ZonedDateTime>(TimeIndex.ZONED_DATE_TIME);

    public static <K extends Comparable<? super K>> CoordinatedSet<K> coordinate(List<? extends BasicSeries<K, ?>> uncoordinated) {
        return CoordinatedSet.from(uncoordinated);
    }

    public static <K extends Comparable<? super K>> K findEarliestFirstKey(Collection<? extends BasicSeries<K, ?>> collection) {
        Comparable retVal = null;
        Comparable tmpVal = null;
        for (BasicSeries<K, ?> individual : collection) {
            tmpVal = (Comparable)individual.firstKey();
            if (retVal != null && tmpVal.compareTo(retVal) >= 0) continue;
            retVal = tmpVal;
        }
        return (K)retVal;
    }

    public static <K extends Comparable<? super K>> K findEarliestLastKey(Collection<? extends BasicSeries<K, ?>> collection) {
        Comparable retVal = null;
        Comparable tmpVal = null;
        for (BasicSeries<K, ?> individual : collection) {
            tmpVal = (Comparable)individual.lastKey();
            if (retVal != null && tmpVal.compareTo(retVal) >= 0) continue;
            retVal = tmpVal;
        }
        return (K)retVal;
    }

    public static <K extends Comparable<? super K>> K findLatestFirstKey(Collection<? extends BasicSeries<K, ?>> collection) {
        Comparable retVal = null;
        Comparable tmpVal = null;
        for (BasicSeries<K, ?> individual : collection) {
            tmpVal = (Comparable)individual.firstKey();
            if (retVal != null && tmpVal.compareTo(retVal) <= 0) continue;
            retVal = tmpVal;
        }
        return (K)retVal;
    }

    public static <K extends Comparable<? super K>> K findLatestLastKey(Collection<? extends BasicSeries<K, ?>> collection) {
        Comparable retVal = null;
        Comparable tmpVal = null;
        for (BasicSeries<K, ?> individual : collection) {
            tmpVal = (Comparable)individual.lastKey();
            if (retVal != null && tmpVal.compareTo(retVal) <= 0) continue;
            retVal = tmpVal;
        }
        return (K)retVal;
    }

    public static BasicSeries<Double, Double> make(DenseArray.Factory<Double> arrayFactory) {
        return new MappedIndexSeries<Double, Double>(arrayFactory, MappedIndexSeries.MAPPER, null);
    }

    public static BasicSeries<Double, Double> make(DenseArray.Factory<Double> arrayFactory, BinaryFunction<Double> accumulator) {
        return new MappedIndexSeries<Double, Double>(arrayFactory, MappedIndexSeries.MAPPER, accumulator);
    }

    public static <N extends Comparable<N>> BasicSeries<N, N> make(DenseArray.Factory<N> arrayFactory, Structure1D.IndexMapper<N> indexMapper) {
        return new MappedIndexSeries<N, N>(arrayFactory, indexMapper, null);
    }

    public static <N extends Comparable<N>> BasicSeries<N, N> make(DenseArray.Factory<N> arrayFactory, Structure1D.IndexMapper<N> indexMapper, BinaryFunction<N> accumulator) {
        return new MappedIndexSeries<N, N>(arrayFactory, indexMapper, accumulator);
    }

    default public PrimitiveSeries asPrimitive() {
        double[] retVal = new double[this.size()];
        int i = 0;
        for (Comparable tmpValue : this.values()) {
            retVal[i] = NumberDefinition.doubleValue(tmpValue);
            ++i;
        }
        return DataSeries.wrap(retVal);
    }

    default public BasicSeries<K, V> colour(ColourData colour) {
        this.setColour(colour);
        return this;
    }

    default public void complete(UnaryOperator<K> keyIncrementor) {
        Comparable tmpKey = (Comparable)this.firstKey();
        Object tmpVal = null;
        V patchVal = this.firstValue();
        Comparable lastKey = (Comparable)this.lastKey();
        while (tmpKey.compareTo(lastKey) <= 0) {
            tmpVal = this.get((K)tmpKey);
            if (tmpVal != null) {
                patchVal = tmpVal;
            } else {
                this.put(tmpKey, patchVal);
            }
            tmpKey = (Comparable)keyIncrementor.apply(tmpKey);
        }
    }

    default public double doubleValue(K key) {
        if (key == null) {
            return Double.NaN;
        }
        V value = this.get(key);
        if (value == null) {
            return Double.NaN;
        }
        return NumberDefinition.doubleValue(value);
    }

    default public V firstValue() {
        return this.get((K)((Comparable)this.firstKey()));
    }

    @Override
    public V get(K var1);

    @Override
    default public V get(Object key) {
        return this.get((K)((Comparable)key));
    }

    public ColourData getColour();

    public String getName();

    default public V lastValue() {
        return this.get((K)((Comparable)this.lastKey()));
    }

    default public BasicSeries<K, V> name(String name) {
        this.setName(name);
        return this;
    }

    default public double put(EntryPair.KeyedPrimitive<K> entry) {
        return this.put((K)((Comparable)entry.getKey()), entry.doubleValue());
    }

    @Override
    default public double put(K key, double value) {
        Double tmpValue = value;
        Double newValue = tmpValue;
        Comparable oldValue = this.put(key, newValue);
        if (oldValue != null) {
            return NumberDefinition.doubleValue(oldValue);
        }
        return Double.NaN;
    }

    default public void putAll(Collection<? extends EntryPair<? extends K, ? extends V>> data) {
        for (EntryPair<K, V> entry : data) {
            this.put((Comparable)entry.getKey(), (Comparable)entry.getValue());
        }
    }

    default public <K2 extends Comparable<? super K2>> void resample(Function<K, K2> keyTranslator, BasicSeries<K2, V> destination) {
        destination.setColour(this.getColour());
        destination.setName(this.getName());
        for (Map.Entry entry : this.entrySet()) {
            Comparable key = (Comparable)keyTranslator.apply((Comparable)entry.getKey());
            Comparable value = (Comparable)entry.getValue();
            destination.put(key, value);
        }
    }

    public BasicSeries<K, V> resample(UnaryOperator<K> var1);

    public void setColour(ColourData var1);

    public void setName(String var1);

    public static final class TimeSeriesBuilder<K extends Comparable<? super K>> {
        private K myReference = null;
        private CalendarDate.Resolution myResolution = null;
        private final TimeIndex<K> myTimeIndex;

        TimeSeriesBuilder(TimeIndex<K> timeIndex) {
            this.myTimeIndex = timeIndex;
        }

        public <N extends Comparable<N>> BasicSeries<K, N> build(DenseArray.Factory<N> denseArrayFactory) {
            ProgrammingError.throwIfNull(denseArrayFactory);
            return this.doBuild(denseArrayFactory, null);
        }

        public <N extends Comparable<N>> BasicSeries<K, N> build(DenseArray.Factory<N> denseArrayFactory, BinaryFunction<N> accumularor) {
            ProgrammingError.throwIfNull(denseArrayFactory, accumularor);
            return this.doBuild(denseArrayFactory, accumularor);
        }

        public TimeSeriesBuilder<K> reference(K reference) {
            this.myReference = reference;
            return this;
        }

        public TimeSeriesBuilder<K> resolution(CalendarDate.Resolution resolution) {
            this.myResolution = resolution;
            return this;
        }

        private <N extends Comparable<N>> BasicSeries<K, N> doBuild(DenseArray.Factory<N> arrayFactory, BinaryFunction<N> accumularor) {
            if (this.myReference != null) {
                if (this.myResolution != null) {
                    return new MappedIndexSeries<K, N>(arrayFactory, this.myTimeIndex.from(this.myReference, this.myResolution), accumularor);
                }
                return new MappedIndexSeries<K, N>(arrayFactory, this.myTimeIndex.from(this.myReference), accumularor);
            }
            if (this.myResolution != null) {
                return new MappedIndexSeries<K, N>(arrayFactory, this.myTimeIndex.plain(this.myResolution), accumularor);
            }
            return new MappedIndexSeries<K, N>(arrayFactory, this.myTimeIndex.plain(), accumularor);
        }
    }

    public static interface NaturallySequenced<K extends Comparable<? super K>, V extends Comparable<V>>
    extends BasicSeries<K, V> {
        public void complete();

        default public K nextKey() {
            return (K)this.step((Comparable)this.lastKey());
        }

        public K step(K var1);
    }
}

