/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.type.collection;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;

public class CloseableMap<K, V extends AutoCloseable>
implements Map<K, V>,
AutoCloseable {
    private final Map<K, V> myDelegate;

    public static <K, V extends AutoCloseable> CloseableMap<K, V> newInstance() {
        return new CloseableMap(new HashMap());
    }

    public static <K, V extends AutoCloseable> CloseableMap<K, V> newInstance(int capacity) {
        return new CloseableMap(new HashMap(capacity));
    }

    public static <K, V extends AutoCloseable> CloseableMap<K, V> wrap(Map<K, V> delegate) {
        return new CloseableMap<K, V>(delegate);
    }

    CloseableMap(Map<K, V> delegate) {
        this.myDelegate = delegate;
    }

    @Override
    public void clear() {
        this.myDelegate.clear();
    }

    @Override
    public void close() throws Exception {
        this.myDelegate.values().forEach((? super T e) -> {
            try {
                if (e != null) {
                    e.close();
                }
            }
            catch (Exception cause) {
                throw new RuntimeException(cause);
            }
        });
    }

    @Override
    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return (V)((AutoCloseable)this.myDelegate.compute((K)key, (BiFunction<? super K, ? extends V, ? extends V>)remappingFunction));
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        return (V)((AutoCloseable)this.myDelegate.computeIfAbsent((K)key, mappingFunction));
    }

    @Override
    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return (V)((AutoCloseable)this.myDelegate.computeIfPresent((K)key, (BiFunction<? super K, ? extends V, ? extends V>)remappingFunction));
    }

    @Override
    public boolean containsKey(Object key) {
        return this.myDelegate.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.myDelegate.containsValue(value);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.myDelegate.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        return this.myDelegate.equals(o);
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
        this.myDelegate.forEach(action);
    }

    @Override
    public V get(Object key) {
        return (V)((AutoCloseable)this.myDelegate.get(key));
    }

    @Override
    public V getOrDefault(Object key, V defaultValue) {
        return (V)((AutoCloseable)this.myDelegate.getOrDefault(key, defaultValue));
    }

    @Override
    public int hashCode() {
        return this.myDelegate.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.myDelegate.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return this.myDelegate.keySet();
    }

    @Override
    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        return (V)((AutoCloseable)this.myDelegate.merge(key, (V)value, (BiFunction<? extends V, ? extends V, ? extends V>)remappingFunction));
    }

    @Override
    public V put(K key, V value) {
        return (V)((AutoCloseable)this.myDelegate.put(key, value));
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.myDelegate.putAll(m);
    }

    @Override
    public V putIfAbsent(K key, V value) {
        return (V)((AutoCloseable)this.myDelegate.putIfAbsent(key, value));
    }

    @Override
    public V remove(Object key) {
        return (V)((AutoCloseable)this.myDelegate.remove(key));
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.myDelegate.remove(key, value);
    }

    @Override
    public V replace(K key, V value) {
        return (V)((AutoCloseable)this.myDelegate.replace(key, value));
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        return this.myDelegate.replace(key, oldValue, newValue);
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        this.myDelegate.replaceAll(function);
    }

    @Override
    public int size() {
        return this.myDelegate.size();
    }

    @Override
    public Collection<V> values() {
        return this.myDelegate.values();
    }
}

