/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.type.management;

import java.util.concurrent.atomic.LongAdder;
import org.ojalgo.type.management.ThroughputMBean;

public final class Throughput
implements ThroughputMBean {
    private static final double NANOS = 1.0E9;
    private long myLastTime = System.nanoTime();
    private double myLastTotal = 0.0;
    private final LongAdder myTotal = new LongAdder();

    public void add(long x) {
        this.myTotal.add(x);
    }

    @Override
    public double getRate() {
        long currentTime = System.nanoTime();
        double currentTotal = this.myTotal.sum();
        double difference = currentTotal - this.myLastTotal;
        double interval = (double)(currentTime - this.myLastTime) / 1.0E9;
        double rate = difference / interval;
        this.myLastTime = currentTime;
        this.myLastTotal = currentTotal;
        return rate;
    }

    @Override
    public long getTotal() {
        return this.myTotal.sum();
    }

    public void increment() {
        this.myTotal.increment();
    }
}

