/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.type.math;

import org.ojalgo.algebra.NumberSet;
import org.ojalgo.machine.JavaType;

public enum MathType {
    C128(NumberSet.C, 2, JavaType.DOUBLE),
    H256(NumberSet.H, 4, JavaType.DOUBLE),
    Q128(NumberSet.Q, 2, JavaType.LONG),
    R032(NumberSet.R, 1, JavaType.FLOAT),
    R064(NumberSet.R, 1, JavaType.DOUBLE),
    R128(NumberSet.R, 1, JavaType.REFERENCE),
    Z008(NumberSet.Z, 1, JavaType.BYTE),
    Z016(NumberSet.Z, 1, JavaType.SHORT),
    Z032(NumberSet.Z, 1, JavaType.INT),
    Z064(NumberSet.Z, 1, JavaType.LONG);

    private final int myComponents;
    private final JavaType myJavaType;
    private final NumberSet myNumberSet;

    private MathType(NumberSet numberSet, int components, JavaType javaType) {
        this.myNumberSet = numberSet;
        this.myJavaType = javaType;
        this.myComponents = components;
    }

    public int getComponents() {
        return this.myComponents;
    }

    public Class<?> getJavaClass() {
        return this.myJavaType.getJavaClass();
    }

    public JavaType getJavaType() {
        return this.myJavaType;
    }

    public NumberSet getNumberSet() {
        return this.myNumberSet;
    }

    public long getTotalMemory() {
        return (long)this.myComponents * this.myJavaType.memory();
    }

    public boolean isPrimitive() {
        return this.myComponents == 1 && this.myJavaType != JavaType.REFERENCE;
    }
}

