/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.sigmet;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.nc2.iosp.sigmet.Ray;
import ucar.nc2.iosp.sigmet.SigmetIOServiceProvider;
import ucar.unidata.io.RandomAccessFile;

public class SigmetVolumeScan {
    private static Logger logger = LoggerFactory.getLogger(SigmetVolumeScan.class);
    public static final String[] data_name = new String[]{"ExtendedHeaders", "TotalPower", "Reflectivity", "Velocity", "Width", "DifferentialReflectivity", "[6]", "CorrectedReflectivity", "TotalPower_2", "Reflectivity_2", "Velocity_2", "Width_2", "DifferentialReflectivity_2", "RainfallRate_2", "KDPDifferentialPhase", "KDPDifferentialPhase_2", "PhiDPDifferentialPhase", "CorrectedVelocity", "SQI", "RhoHV", "RhoHV_2", "CorrectedReflectivity_2", "CorrectedVelocity_2", "SQI_2", "PhiDPDifferentialPhase_2", "LDRH", "LDRH_2", "LDRV", "LDRV_2", "[29]", "[30]", "[31]", "Height", "LinearLiquid_2", "RawData", "WindShear", "Divergence_2", "FloatedLiquid_2", "UserType", "UnspecifiedData", "Deformation_2", "VerticalVelocity_2", "HorizontalVelocity_2", "HorizontalWindDirection_2", "AxisOfDilatation_2", "TimeInSeconds_2", "RHOH", "RHOH_2", "RHOV", "RHOV_2", "PHIH", "PHIH_2", "PHIV", "PHIV_2", "UserType_2", "HydrometeorClass", "HydrometeorClass_2", "CorrectedDifferentialReflectivity", "CorrectedDifferentialReflectivity_2", "[59]", "[60]", "[61]", "[62]", "[63]", "[64]", "[65]", "[66]", "[67]", "[68]", "[69]", "[70]", "[71]", "[72]", "[73]", "[74]", "PolarimetricMeteoIndex", "PolarimetricMeteoIndex_2", "LOG8", "LOG16_2", "CSP8", "CSP16_2", "CCOR8", "CCOR16_2", "AH8", "AH16_2", "AV8", "AV16_2", "AZDR8", "AZDR16_2"};
    public static final String[] data_unit = new String[]{"?", "dBm", "dBZ", "m/s", "m/s", "dB", "?", "dBZ", "dBm", "dBZ", "m/s", "m/s", "dB", "mm/hr", "\u00b0/km", "\u00b0/km", "\u00b0", "m/s", "?", "?", "?", "dBZ", "m/s", "?", "\u00b0", "?", "?", "?", "?", "?", "?", "?", "1/10 km", ".001mm", "?", "m/s", "?", "mm", "?", "?", "1/s", "m/s", "m/s", "\u00b0", "1/s", "s", "?", "?", "?", "?", "\u00b0", "\u00b0", "\u00b0", "\u00b0", "?", "?", "?", "dB", "dB", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?"};
    public static final int REC_SIZE = 6144;
    public static final float MISSING_VALUE_FLOAT = -999.99f;
    public static final double MISSING_VALUE_DOUBLE = -999.99;
    public static final byte MISSING_VALUE_BYTE = 0;
    public static final ByteBuffer MISSING_VALUE_BYTE_ARRAY_BB = ByteBuffer.wrap(new byte[]{0});
    public static final Array MISSING_VALUE_BYTE_ARRAY = Array.factoryConstant((DataType)DataType.OPAQUE, (int[])new int[]{1}, (Object)new ByteBuffer[]{MISSING_VALUE_BYTE_ARRAY_BB});
    private HashMap<String, List<List<Ray>>> allGroups = new HashMap();
    private short[] data_type;
    private int[] num_gates;
    public int[] base_time;
    public short[] year;
    public short[] month;
    public short[] day;
    public Ray firstRay;
    public Ray lastRay;
    public RandomAccessFile raf;
    private int max_radials;
    private int min_radials = Integer.MAX_VALUE;
    private boolean debugRadials;

    SigmetVolumeScan(RandomAccessFile raf) throws IOException {
        int len = 12288;
        short nrec = 0;
        short nsweep = 1;
        short nray = 0;
        short byteoff = 0;
        int data_read = 0;
        int rays_count = 0;
        int nb = 0;
        int posInRay_relative = 0;
        int posInRay_absolute = 0;
        int pos_ray_hdr = 0;
        boolean t = false;
        short beg_az = 0;
        short beg_elev = 0;
        short end_az = 0;
        short end_elev = 0;
        int num_bins = 0;
        int time_start_sw = 0;
        float d = 0.0f;
        boolean beg_rec = true;
        boolean end_rec = true;
        boolean read_ray_hdr = true;
        boolean begin = true;
        int beg = 1;
        boolean col = false;
        int nu = 0;
        boolean bt0 = false;
        boolean bt1 = false;
        boolean start_sweep = true;
        boolean end_sweep = true;
        boolean start_ray = true;
        boolean end_ray = true;
        this.raf = raf;
        raf.order(1);
        int fileLength = (int)raf.length();
        Map<String, Number> recHdr = SigmetIOServiceProvider.readRecordsHdr(raf);
        int nparams = recHdr.get("nparams").intValue();
        short number_sweeps = recHdr.get("number_sweeps").shortValue();
        short num_rays = recHdr.get("num_rays").shortValue();
        int range_1st = recHdr.get("range_first").intValue();
        float range_first = (float)range_1st * 0.01f;
        int stepp = recHdr.get("range_last").intValue();
        float range_last = (float)stepp * 0.01f;
        short bins = recHdr.get("bins").shortValue();
        short[] num_sweep = new short[nparams];
        short[] num_rays_swp = new short[nparams];
        short[] indx_1ray = new short[nparams];
        short[] num_rays_exp = new short[nparams];
        short[] num_rays_act = new short[nparams];
        short[] angl_swp = new short[nparams];
        short[] bin_len = new short[nparams];
        this.data_type = new short[nparams];
        this.num_gates = new int[number_sweeps];
        this.base_time = new int[nparams * number_sweeps];
        this.year = new short[nparams * number_sweeps];
        this.month = new short[nparams * number_sweeps];
        this.day = new short[nparams * number_sweeps];
        HashMap<String, ArrayList<Ray>> all = new HashMap<String, ArrayList<Ray>>();
        short irays = num_rays;
        Ray ray = null;
        float[] val = new float[bins];
        while (len < fileLength) {
            short a00;
            int nwords;
            int rayoffset = 0;
            int datalen = 0;
            int cur_len = len;
            if (nsweep == number_sweeps & rays_count == beg) break;
            if (beg_rec) {
                raf.seek((long)cur_len);
                nrec = raf.readShort();
                nsweep = raf.readShort();
                byteoff = raf.readShort();
                len += 2;
                nray = raf.readShort();
                cur_len += 12;
                beg_rec = false;
            }
            if (nsweep <= number_sweeps & rays_count % beg == 0) {
                beg = 0;
                for (int i = 0; i < nparams; ++i) {
                    int idh_len = cur_len + 12 + i * 76;
                    raf.seek((long)idh_len);
                    this.base_time[nu] = raf.readInt();
                    raf.skipBytes(2);
                    this.year[nu] = raf.readShort();
                    this.month[nu] = raf.readShort();
                    this.day[nu] = raf.readShort();
                    ++nu;
                    num_sweep[i] = raf.readShort();
                    num_rays_swp[i] = raf.readShort();
                    indx_1ray[i] = raf.readShort();
                    num_rays_exp[i] = raf.readShort();
                    beg += num_rays_exp[i];
                    num_rays_act[i] = raf.readShort();
                    angl_swp[i] = raf.readShort();
                    bin_len[i] = raf.readShort();
                    this.data_type[i] = raf.readShort();
                }
                cur_len += nparams * 76;
            }
            if (end_rec) {
                raf.seek((long)cur_len);
                short a0 = raf.readShort();
                cur_len += 2;
                if (a0 == 1) {
                    if (cur_len % 6144 == 0) {
                        beg_rec = true;
                        end_rec = true;
                        ++rays_count;
                        read_ray_hdr = true;
                        posInRay_relative = 0;
                        posInRay_absolute = 0;
                        data_read = 0;
                        nb = 0;
                        len = cur_len;
                        continue;
                    }
                    end_rec = true;
                    len = cur_len;
                    ++rays_count;
                    continue;
                }
                nwords = a0 & Short.MAX_VALUE;
                int end_words = nwords - 6;
                data_read = end_words * 2;
                end_rec = false;
                if (cur_len % 6144 == 0) {
                    len = cur_len;
                    read_ray_hdr = true;
                    beg_rec = true;
                    continue;
                }
            }
            len = cur_len;
            short dty = this.data_type[0];
            short bitsToRead = bin_len[0];
            if (nparams > 1) {
                int kk = rays_count % nparams;
                dty = this.data_type[kk];
                bitsToRead = bin_len[kk];
            } else if (number_sweeps > 1) {
                // empty if block
            }
            if (bitsToRead <= 0 || bitsToRead % 8 != 0) {
                throw new IllegalStateException("Not compatible! Number of bits per bin for this data type = " + bitsToRead);
            }
            int bytesToRead = bitsToRead / 8;
            String var_name = data_name[dty];
            if (read_ray_hdr) {
                if (ray != null) {
                    throw new IllegalStateException("ray != null");
                }
                if (pos_ray_hdr < 2) {
                    raf.seek((long)cur_len);
                    beg_az = raf.readShort();
                    len = cur_len += 2;
                    if (cur_len % 6144 == 0) {
                        pos_ray_hdr = 2;
                        beg_rec = true;
                        read_ray_hdr = true;
                        continue;
                    }
                }
                if (pos_ray_hdr < 4) {
                    raf.seek((long)cur_len);
                    beg_elev = raf.readShort();
                    len = cur_len += 2;
                    if (cur_len % 6144 == 0) {
                        pos_ray_hdr = 4;
                        beg_rec = true;
                        read_ray_hdr = true;
                        continue;
                    }
                }
                if (pos_ray_hdr < 6) {
                    raf.seek((long)cur_len);
                    end_az = raf.readShort();
                    len = cur_len += 2;
                    if (cur_len % 6144 == 0) {
                        pos_ray_hdr = 6;
                        beg_rec = true;
                        read_ray_hdr = true;
                        continue;
                    }
                }
                if (pos_ray_hdr < 8) {
                    raf.seek((long)cur_len);
                    end_elev = raf.readShort();
                    len = cur_len += 2;
                    if (cur_len % 6144 == 0) {
                        pos_ray_hdr = 8;
                        beg_rec = true;
                        read_ray_hdr = true;
                        continue;
                    }
                }
                if (pos_ray_hdr < 10) {
                    raf.seek((long)cur_len);
                    num_bins = raf.readShort();
                    len = cur_len += 2;
                    if (num_bins % 2 != 0) {
                        num_bins = (short)(num_bins + 1);
                    }
                    this.num_gates[nsweep - 1] = num_bins;
                    if (cur_len % 6144 == 0) {
                        pos_ray_hdr = 10;
                        beg_rec = true;
                        read_ray_hdr = true;
                        continue;
                    }
                }
                if (pos_ray_hdr < 12) {
                    raf.seek((long)cur_len);
                    time_start_sw = raf.readUnsignedShort();
                    len = cur_len += 2;
                }
            }
            float az = SigmetIOServiceProvider.calcAz(beg_az, end_az);
            float elev = SigmetIOServiceProvider.calcElev(end_elev);
            float step = SigmetIOServiceProvider.calcStep(range_first, range_last, (short)num_bins);
            if (cur_len % 6144 == 0) {
                len = cur_len;
                beg_rec = true;
                read_ray_hdr = false;
                continue;
            }
            if (posInRay_relative > 0) {
                data_read -= posInRay_relative;
                posInRay_relative = 0;
            }
            if (data_read > 0) {
                raf.seek((long)cur_len);
                rayoffset = cur_len;
                datalen = data_read;
                for (int i = 0; i < data_read; ++i) {
                    ++cur_len;
                    if (++posInRay_absolute % bytesToRead == 0) {
                        ++nb;
                    }
                    if (cur_len % 6144 != 0) continue;
                    posInRay_relative = i + 1;
                    beg_rec = true;
                    read_ray_hdr = false;
                    len = cur_len;
                    raf.seek((long)cur_len);
                    break;
                }
                raf.seek((long)cur_len);
                if (posInRay_relative > 0) continue;
            }
            if (cur_len % 6144 == 0) {
                posInRay_relative = 0;
                beg_rec = true;
                read_ray_hdr = false;
                data_read = 0;
                len = cur_len;
                continue;
            }
            raf.seek((long)cur_len);
            int rayoffset1 = cur_len;
            while (nb < num_bins) {
                a00 = raf.readShort();
                cur_len += 2;
                if (a00 == 1) {
                    ray = new Ray(range_first, step, az, elev, (short)num_bins, (short)nb, time_start_sw, rayoffset, datalen, rayoffset1, nsweep, var_name, dty, bytesToRead);
                    ++rays_count;
                    beg_rec = false;
                    end_rec = true;
                    break;
                }
                if (a00 < 0) {
                    nwords = a00 & Short.MAX_VALUE;
                    data_read = nwords * 2;
                    if (cur_len % 6144 == 0) {
                        posInRay_relative = 0;
                        beg_rec = true;
                        end_rec = false;
                        read_ray_hdr = false;
                        break;
                    }
                    raf.seek((long)cur_len);
                    for (int ii = 0; ii < data_read; ++ii) {
                        ++cur_len;
                        if (++posInRay_absolute % bytesToRead == 0) {
                            ++nb;
                        }
                        if (cur_len % 6144 != 0) continue;
                        posInRay_relative = ii + 1;
                        beg_rec = true;
                        end_rec = false;
                        read_ray_hdr = false;
                        raf.seek((long)cur_len);
                        break;
                    }
                    raf.seek((long)cur_len);
                    if (posInRay_relative <= 0) continue;
                    break;
                }
                if (!(a00 > 0 & a00 != 1)) continue;
                int num_zero = a00 * 2;
                int nb_before = posInRay_absolute / bytesToRead;
                if (nb_before != nb) {
                    throw new IllegalStateException("nb_before != nb");
                }
                int nb_after = (posInRay_absolute += num_zero) / bytesToRead;
                nb += nb_after - nb_before;
                if (cur_len % 6144 != 0) continue;
                beg_rec = true;
                end_rec = false;
                read_ray_hdr = false;
                posInRay_relative = 0;
                data_read = 0;
                break;
            }
            if (cur_len % 6144 == 0) {
                len = cur_len;
                if (ray == null) continue;
                beg_rec = true;
                end_rec = true;
                read_ray_hdr = true;
                posInRay_relative = 0;
                posInRay_absolute = 0;
                data_read = 0;
                nb = 0;
                len = cur_len;
                if (ray == null) {
                    throw new IllegalStateException("ray == null");
                }
                ArrayList<Ray> varL = (ArrayList<Ray>)all.get(var_name.trim());
                if (varL == null) {
                    varL = new ArrayList<Ray>();
                    all.put(var_name.trim(), varL);
                }
                varL.add(ray);
                this.lastRay = ray;
                ray = null;
                continue;
            }
            raf.seek((long)cur_len);
            if (nb == num_bins) {
                a00 = raf.readShort();
                if (a00 != 1) {
                    logger.warn("nb == num_bins but a00 != 1 - something seems wrong");
                }
                cur_len += 2;
                end_rec = true;
                ray = new Ray(range_first, step, az, elev, (short)num_bins, (short)nb, time_start_sw, rayoffset, datalen, rayoffset1, nsweep, var_name, dty, bytesToRead);
                if (nsweep == number_sweeps & ++rays_count % beg == 0) {
                    if (ray == null) {
                        throw new IllegalStateException("ray == null");
                    }
                    ArrayList<Ray> varL = (ArrayList<Ray>)all.get(var_name.trim());
                    if (varL == null) {
                        varL = new ArrayList<Ray>();
                        all.put(var_name.trim(), varL);
                    }
                    varL.add(ray);
                    this.lastRay = ray;
                    ray = null;
                    break;
                }
                if (cur_len % 6144 == 0) {
                    beg_rec = true;
                    end_rec = true;
                    read_ray_hdr = true;
                    posInRay_relative = 0;
                    posInRay_absolute = 0;
                    data_read = 0;
                    nb = 0;
                    len = cur_len;
                    if (ray == null) {
                        throw new IllegalStateException("ray == null");
                    }
                    ArrayList<Ray> varL = (ArrayList<Ray>)all.get(var_name.trim());
                    if (varL == null) {
                        varL = new ArrayList<Ray>();
                        all.put(var_name.trim(), varL);
                    }
                    varL.add(ray);
                    this.lastRay = ray;
                    ray = null;
                    continue;
                }
            }
            if (this.firstRay == null) {
                this.firstRay = ray;
            }
            if (ray == null) {
                throw new IllegalStateException("ray == null");
            }
            ArrayList<Ray> additionalL = (ArrayList<Ray>)all.get(var_name.trim());
            if (additionalL == null) {
                additionalL = new ArrayList<Ray>();
                all.put(var_name.trim(), additionalL);
            }
            additionalL.add(ray);
            this.lastRay = ray;
            ray = null;
            posInRay_relative = 0;
            posInRay_absolute = 0;
            data_read = 0;
            nb = 0;
            read_ray_hdr = true;
            pos_ray_hdr = 0;
            if (nsweep <= number_sweeps & rays_count % beg == 0) {
                beg_rec = true;
                end_rec = true;
                rays_count = 0;
                nb = 0;
                cur_len = 6144 * (nrec + 1);
                read_ray_hdr = true;
            }
            len = cur_len;
        }
        for (String var_name : all.keySet()) {
            List additionalL = (List)all.get(var_name);
            if (additionalL.isEmpty()) continue;
            this.allGroups.put(var_name, this.sortScans(var_name, additionalL, 1000));
        }
    }

    private List<List<Ray>> sortScans(String name, List<Ray> scans, int siz) {
        HashMap<Short, List> groupHash = new HashMap<Short, List>(siz);
        for (Ray ray : scans) {
            List list = groupHash.computeIfAbsent((short)ray.nsweep, k -> new ArrayList());
            list.add(ray);
        }
        for (Short aShort : groupHash.keySet()) {
            List list = (List)groupHash.get(aShort);
            Ray[] rr = new Ray[list.size()];
            list.toArray(rr);
            this.checkSort(rr);
        }
        ArrayList<List<Ray>> groups = new ArrayList<List<Ray>>(groupHash.values());
        groups.sort(new GroupComparator());
        for (List list : groups) {
            this.max_radials = Math.max(this.max_radials, list.size());
            this.min_radials = Math.min(this.min_radials, list.size());
        }
        if (this.debugRadials) {
            System.out.println(name + " min_radials= " + this.min_radials + " max_radials= " + this.max_radials);
            for (List list : groups) {
                Ray lastr = (Ray)list.get(0);
                for (int j = 1; j < list.size(); ++j) {
                    Ray r = (Ray)list.get(j);
                    if (r.getTime() < lastr.getTime()) {
                        System.out.println(" out of order " + j);
                    }
                    lastr = r;
                }
            }
        }
        return groups;
    }

    public List<List<Ray>> getGroup(String name) {
        return this.allGroups.get(name);
    }

    public short[] getDataTypes() {
        return this.data_type;
    }

    public int[] getNumberGates() {
        return this.num_gates;
    }

    public int[] getStartSweep() {
        return this.base_time;
    }

    void checkSort(Ray[] r) {
        int i;
        int i2;
        int n2;
        int n1;
        int j = 0;
        boolean n = false;
        int[] k1 = new int[300];
        int[] k2 = new int[300];
        for (int i3 = 0; i3 < r.length - 1; ++i3) {
            int time2;
            int time1 = r[i3].getTime();
            if (time1 == (time2 = r[i3 + 1].getTime())) continue;
            k2[j] = i3;
            k1[++j] = i3 + 1;
        }
        if (k2[j] < r.length - 1 && j > 0) {
            k1[j] = k2[j - 1] + 1;
            k2[j] = r.length - 1;
        }
        int it1 = 0;
        int it2 = 0;
        for (int ii = 0; ii < j + 1; ++ii) {
            n1 = k1[ii];
            for (int i4 = 0; i4 < j + 1; ++i4) {
                if (i4 == ii) continue;
                n2 = k1[i4];
                if (r[n1].getTime() != r[n2].getTime()) continue;
                it1 = ii;
                it2 = i4;
            }
        }
        n1 = k1[it1];
        n2 = k1[it2];
        int s1 = k2[it1] - k1[it1] + 1;
        int s2 = k2[it2] - k1[it2] + 1;
        float[] t0 = new float[s1];
        float[] t00 = new float[s2];
        for (i2 = 0; i2 < s1; ++i2) {
            t0[i2] = r[n1 + i2].getAz();
        }
        for (i2 = 0; i2 < s2; ++i2) {
            t00[i2] = r[n2 + i2].getAz();
        }
        float mx0 = t0[0];
        for (int i5 = 0; i5 < s1; ++i5) {
            if (!(mx0 < t0[i5])) continue;
            mx0 = t0[i5];
        }
        float mx00 = t00[0];
        for (i = 0; i < s2; ++i) {
            if (!(mx00 < t00[i])) continue;
            mx00 = t00[i];
        }
        if (mx0 > 330.0f & mx00 < 50.0f) {
            for (i = 0; i < s1; ++i) {
                float q = r[n1 + i].getAz();
                r[n1 + i].setAz(q - 360.0f);
            }
        }
        Arrays.sort(r, new RayComparator());
        for (Ray ray : r) {
            float a = ray.getAz();
            if (!(a < 0.0f & a > -361.0f)) continue;
            float qa = ray.getAz();
            ray.setAz(qa + 360.0f);
        }
    }

    static class RayComparator
    implements Comparator<Ray> {
        RayComparator() {
        }

        @Override
        public int compare(Ray ray1, Ray ray2) {
            if (ray1.getTime() < ray2.getTime()) {
                return -1;
            }
            if (ray1.getTime() == ray2.getTime()) {
                if (ray1.getAz() < ray2.getAz()) {
                    return -1;
                }
                if (ray1.getAz() > ray2.getAz()) {
                    return 1;
                }
                if (ray1.getAz() == ray2.getAz()) {
                    return 0;
                }
            } else if (ray1.getTime() > ray2.getTime()) {
                return 1;
            }
            return 0;
        }
    }

    private static class GroupComparator
    implements Comparator<List<Ray>> {
        private GroupComparator() {
        }

        @Override
        public int compare(List<Ray> group1, List<Ray> group2) {
            Ray record1 = group1.get(0);
            Ray record2 = group2.get(0);
            return record1.nsweep - record2.nsweep;
        }
    }
}

