/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.geo.io;

import org.meteoinfo.geo.layer.VectorLayer;
import org.meteoinfo.geometry.io.geojson.Feature;
import org.meteoinfo.geometry.io.geojson.FeatureCollection;
import org.meteoinfo.geometry.io.geojson.GeoJSONFactory;
import org.meteoinfo.geometry.io.geojson.GeoJSONUtil;
import org.meteoinfo.geometry.io.geojson.Geometry;
import org.meteoinfo.geometry.legend.ColorBreak;
import org.meteoinfo.geometry.legend.LegendScheme;
import org.meteoinfo.geometry.legend.LegendType;
import org.meteoinfo.geometry.shape.Shape;
import org.meteoinfo.ndarray.DataType;

public class GeoJSONReader {
    public static VectorLayer read(FeatureCollection features) {
        Shape shape = GeoJSONUtil.toShape((Geometry)features.getFeature(0).getGeometry());
        VectorLayer layer = new VectorLayer(shape.getShapeType());
        String fieldName = "title";
        layer.editAddField(fieldName, DataType.STRING);
        LegendScheme ls = new LegendScheme(shape.getShapeType());
        ls.setLegendType(LegendType.UNIQUE_VALUE);
        ls.setFieldName(fieldName);
        for (int i = 0; i < features.getNumFeatures(); ++i) {
            Feature feature = features.getFeature(i);
            if (GeoJSONUtil.getShapeType((Feature)feature) != shape.getShapeType()) continue;
            ColorBreak cb = GeoJSONUtil.getLegendBreak((Feature)feature);
            ls.addLegendBreak(cb);
            Geometry geometry = feature.getGeometry();
            if (geometry == null) continue;
            try {
                int idx = layer.getShapeNum();
                layer.editInsertShape(GeoJSONUtil.toShape((Geometry)geometry), idx);
                layer.editCellValue(fieldName, idx, (Object)cb.getCaption());
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        layer.setLegendScheme(ls);
        return layer;
    }

    public static VectorLayer read(String json) {
        FeatureCollection features = (FeatureCollection)GeoJSONFactory.create((String)json);
        return GeoJSONReader.read(features);
    }
}

