/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib2;

import com.sun.jna.Memory;
import edu.ucar.unidata.compression.jna.libaec.LibAec;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.grib.GribNumbers;
import ucar.nc2.grib.GribUtils;
import ucar.nc2.grib.grib2.Grib2Drs;
import ucar.nc2.grib.grib2.Grib2JpegDecoder;
import ucar.nc2.grib.grib2.Grib2SectionBitMap;
import ucar.nc2.iosp.BitReader;
import ucar.unidata.io.RandomAccessFile;

public class Grib2DataReader {
    private static final Logger logger = LoggerFactory.getLogger(Grib2DataReader.class);
    private static final int[] bitsmv1 = new int[31];
    private final int dataTemplate;
    private final int totalNPoints;
    private final int dataNPoints;
    private final int scanMode;
    private final int nx;
    private final long startPos;
    private final int dataLength;
    private int bitmapIndicator;
    private byte[] bitmap;
    private static final boolean staticMissingValueInUse = true;
    private static final float staticMissingValue = Float.NaN;

    Grib2DataReader(int dataTemplate, int totalNPoints, int dataNPoints, int scanMode, int nx, long startPos, int dataLength) {
        this.dataTemplate = dataTemplate;
        this.totalNPoints = totalNPoints;
        this.dataNPoints = dataNPoints;
        this.scanMode = scanMode;
        this.nx = nx;
        this.startPos = startPos;
        this.dataLength = dataLength;
    }

    public float[] getData(RandomAccessFile raf, Grib2SectionBitMap bitmapSection, Grib2Drs gdrs) throws IOException {
        float[] data;
        this.bitmap = bitmapSection.getBitmap(raf);
        this.bitmapIndicator = bitmapSection.getBitMapIndicator();
        if (this.bitmap != null && this.bitmap.length * 8 < this.totalNPoints) {
            logger.warn("Bitmap section length = {} != grid length {} ({},{})", new Object[]{this.bitmap.length, this.totalNPoints, this.nx, this.totalNPoints / this.nx});
            throw new IllegalStateException("Bitmap section length!= grid length");
        }
        raf.seek(this.startPos + 5L);
        switch (this.dataTemplate) {
            case 0: {
                data = this.getData0(raf, (Grib2Drs.Type0)gdrs);
                break;
            }
            case 2: {
                data = this.getData2(raf, (Grib2Drs.Type2)gdrs);
                break;
            }
            case 3: {
                data = this.getData3(raf, (Grib2Drs.Type3)gdrs);
                break;
            }
            case 40: {
                data = this.getData40(raf, (Grib2Drs.Type40)gdrs);
                break;
            }
            case 41: {
                data = this.getData41(raf, (Grib2Drs.Type0)gdrs);
                break;
            }
            case 42: {
                data = this.getData42(raf, (Grib2Drs.Type42)gdrs);
                break;
            }
            case 50002: {
                data = this.getData50002(raf, (Grib2Drs.Type50002)gdrs);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported DRS type = " + this.dataTemplate);
            }
        }
        this.scanningModeCheck(data, this.scanMode, this.nx);
        return data;
    }

    @Nullable
    int[] getRawData(RandomAccessFile raf, Grib2SectionBitMap bitmapSection, Grib2Drs gdrs) throws IOException {
        this.bitmap = bitmapSection.getBitmap(raf);
        this.bitmapIndicator = bitmapSection.getBitMapIndicator();
        if (this.bitmap != null && this.bitmap.length * 8 < this.totalNPoints) {
            logger.warn("Bitmap section length = {} != grid length {} ({},{})", new Object[]{this.bitmap.length, this.totalNPoints, this.nx, this.totalNPoints / this.nx});
            throw new IllegalStateException("Bitmap section length!= grid length");
        }
        raf.seek(this.startPos + 5L);
        if (this.dataTemplate != 40) {
            return null;
        }
        return this.getData40raw(raf, (Grib2Drs.Type40)gdrs);
    }

    private float getMissingValue(Grib2Drs.Type2 gdrs) {
        int mvm = gdrs.missingValueManagement;
        float mv = Float.NaN;
        return mv;
    }

    private float[] getData0(RandomAccessFile raf, Grib2Drs.Type0 gdrs) throws IOException {
        int nb = gdrs.numberOfBits;
        int D = gdrs.decimalScaleFactor;
        float DD = (float)Math.pow(10.0, D);
        float R = gdrs.referenceValue;
        int E = gdrs.binaryScaleFactor;
        float EE = (float)Math.pow(2.0, E);
        float[] data = new float[this.totalNPoints];
        BitReader reader = new BitReader(raf, this.startPos + 5L);
        if (this.bitmap == null) {
            for (int i = 0; i < this.totalNPoints; ++i) {
                data[i] = (R + (float)reader.bits2UInt(nb) * EE) / DD;
            }
        } else {
            for (int i = 0; i < this.totalNPoints; ++i) {
                data[i] = GribNumbers.testBitIsSet(this.bitmap[i / 8], i % 8) ? (R + (float)reader.bits2UInt(nb) * EE) / DD : Float.NaN;
            }
        }
        return data;
    }

    private float[] getData2(RandomAccessFile raf, Grib2Drs.Type2 gdrs) throws IOException {
        int mvm = gdrs.missingValueManagement;
        float mv = this.getMissingValue(gdrs);
        float DD = (float)Math.pow(10.0, gdrs.decimalScaleFactor);
        float R = gdrs.referenceValue;
        float EE = (float)Math.pow(2.0, gdrs.binaryScaleFactor);
        float ref_val = R / DD;
        int NG = gdrs.numberOfGroups;
        if (NG == 0) {
            return this.nGroups0(this.bitmapIndicator, ref_val, mv);
        }
        BitReader reader = new BitReader(raf, this.startPos + 5L);
        int[] X1 = new int[NG];
        int nb = gdrs.numberOfBits;
        if (nb != 0) {
            for (int i = 0; i < NG; ++i) {
                X1[i] = (int)reader.bits2UInt(nb);
            }
        }
        int[] NB = new int[NG];
        nb = gdrs.bitsGroupWidths;
        if (nb != 0) {
            reader.incrByte();
            for (int i = 0; i < NG; ++i) {
                NB[i] = (int)reader.bits2UInt(nb);
            }
        }
        int[] L = new int[NG];
        int ref = gdrs.referenceGroupLength;
        int len_inc = gdrs.lengthIncrement;
        nb = gdrs.bitsScaledGroupLength;
        reader.incrByte();
        for (int i = 0; i < NG; ++i) {
            L[i] = ref + (int)reader.bits2UInt(nb) * len_inc;
        }
        L[NG - 1] = gdrs.lengthLastGroup;
        float[] data = new float[this.totalNPoints];
        int count = 0;
        reader.incrByte();
        for (int i = 0; i < NG; ++i) {
            for (int j = 0; j < L[i]; ++j) {
                if (NB[i] == 0) {
                    if (mvm == 0) {
                        data[count++] = (R + (float)X1[i] * EE) / DD;
                        continue;
                    }
                    data[count++] = mv;
                    continue;
                }
                int X2 = (int)reader.bits2UInt(NB[i]);
                data[count++] = mvm == 0 ? (R + (float)(X1[i] + X2) * EE) / DD : (X2 == bitsmv1[NB[i]] ? mv : (R + (float)(X1[i] + X2) * EE) / DD);
            }
        }
        if (this.bitmap != null) {
            int idx = 0;
            float[] tmp = new float[this.totalNPoints];
            for (int i = 0; i < this.totalNPoints; ++i) {
                tmp[i] = GribNumbers.testBitIsSet(this.bitmap[i / 8], i % 8) ? data[idx++] : mv;
            }
            data = tmp;
        }
        return data;
    }

    private float[] nGroups0(int bitmap_flag, float ref, float mv1) {
        float[] data = new float[this.totalNPoints];
        if (bitmap_flag == 255) {
            for (int i = 0; i < this.totalNPoints; ++i) {
                data[i] = ref;
            }
        } else if (bitmap_flag == 0 || bitmap_flag == 254) {
            int mask = 0;
            int mask_pointer = 0;
            for (int i = 0; i < this.totalNPoints; ++i) {
                if ((i & 7) == 0) {
                    mask = this.bitmap[mask_pointer];
                    ++mask_pointer;
                }
                data[i] = (mask & 0x80) == 0 ? ref : mv1;
                mask <<= 1;
            }
        } else {
            throw new IllegalArgumentException("unknown bitmap type =" + bitmap_flag);
        }
        return data;
    }

    private float[] getData3(RandomAccessFile raf, Grib2Drs.Type3 gdrs) throws IOException {
        int i;
        int i2;
        int itemp;
        int i3;
        int minsd;
        int ival1;
        int mvm = gdrs.missingValueManagement;
        float mv = this.getMissingValue(gdrs);
        float DD = (float)Math.pow(10.0, gdrs.decimalScaleFactor);
        float R = gdrs.referenceValue;
        float EE = (float)Math.pow(2.0, gdrs.binaryScaleFactor);
        float ref_val = R / DD;
        int NG = gdrs.numberOfGroups;
        if (NG == 0) {
            return this.nGroups0(this.bitmapIndicator, ref_val, mv);
        }
        BitReader reader = new BitReader(raf, this.startPos + 5L);
        int ival2 = 0;
        int os = gdrs.orderSpatial;
        int nbitsd = gdrs.descriptorSpatial;
        if ((nbitsd *= 8) > 0) {
            int sign = (int)reader.bits2UInt(1);
            ival1 = (int)reader.bits2UInt(nbitsd - 1);
            if (sign == 1) {
                ival1 = -ival1;
            }
            if (os == 2) {
                sign = (int)reader.bits2UInt(1);
                ival2 = (int)reader.bits2UInt(nbitsd - 1);
                if (sign == 1) {
                    ival2 = -ival2;
                }
            }
            sign = (int)reader.bits2UInt(1);
            minsd = (int)reader.bits2UInt(nbitsd - 1);
            if (sign == 1) {
                minsd = -minsd;
            }
        } else {
            float[] data = new float[this.totalNPoints];
            for (int i4 = 0; i4 < this.totalNPoints; ++i4) {
                data[i4] = mv;
            }
            return data;
        }
        int[] X1 = new int[NG];
        int nb = gdrs.numberOfBits;
        if (nb != 0) {
            reader.incrByte();
            for (int i5 = 0; i5 < NG; ++i5) {
                X1[i5] = (int)reader.bits2UInt(nb);
            }
        }
        int[] NB = new int[NG];
        nb = gdrs.bitsGroupWidths;
        if (nb != 0) {
            reader.incrByte();
            for (int i6 = 0; i6 < NG; ++i6) {
                NB[i6] = (int)reader.bits2UInt(nb);
            }
        }
        int referenceGroupWidths = gdrs.referenceGroupWidths;
        int i7 = 0;
        while (i7 < NG) {
            int n = i7++;
            NB[n] = NB[n] + referenceGroupWidths;
        }
        int[] L = new int[NG];
        int referenceGroupLength = gdrs.referenceGroupLength;
        nb = gdrs.bitsScaledGroupLength;
        int len_inc = gdrs.lengthIncrement;
        if (nb != 0) {
            reader.incrByte();
            for (int i8 = 0; i8 < NG; ++i8) {
                L[i8] = (int)reader.bits2UInt(nb);
            }
        }
        int totalL = 0;
        for (int i9 = 0; i9 < NG; ++i9) {
            L[i9] = L[i9] * len_inc + referenceGroupLength;
            totalL += L[i9];
        }
        totalL -= L[NG - 1];
        totalL += gdrs.lengthLastGroup;
        L[NG - 1] = gdrs.lengthLastGroup;
        if (mvm != 0) {
            if (totalL != this.totalNPoints) {
                logger.warn("NPoints != gds.nPts: " + totalL + "!=" + this.totalNPoints);
                float[] data = new float[this.totalNPoints];
                for (int i10 = 0; i10 < this.totalNPoints; ++i10) {
                    data[i10] = mv;
                }
                return data;
            }
        } else if (totalL != this.dataNPoints) {
            logger.warn("NPoints != drs.nPts: " + totalL + "!=" + this.totalNPoints);
            float[] data = new float[this.totalNPoints];
            for (int i11 = 0; i11 < this.totalNPoints; ++i11) {
                data[i11] = mv;
            }
            return data;
        }
        float[] data = new float[this.totalNPoints];
        int count = 0;
        reader.incrByte();
        int dataSize = 0;
        boolean[] dataBitMap = null;
        if (mvm == 0) {
            for (i3 = 0; i3 < NG; ++i3) {
                int j;
                if (NB[i3] != 0) {
                    for (j = 0; j < L[i3]; ++j) {
                        data[count++] = (int)reader.bits2UInt(NB[i3]) + X1[i3];
                    }
                    continue;
                }
                for (j = 0; j < L[i3]; ++j) {
                    data[count++] = X1[i3];
                }
            }
        } else if (mvm == 1 || mvm == 2) {
            dataBitMap = new boolean[this.totalNPoints];
            dataSize = 0;
            for (i3 = 0; i3 < NG; ++i3) {
                int j;
                int msng2;
                int msng1;
                if (NB[i3] != 0) {
                    msng1 = bitsmv1[NB[i3]];
                    msng2 = msng1 - 1;
                    for (j = 0; j < L[i3]; ++j) {
                        data[count] = (int)reader.bits2UInt(NB[i3]);
                        if (data[count] == (float)msng1 || mvm == 2 && data[count] == (float)msng2) {
                            dataBitMap[count] = false;
                        } else {
                            dataBitMap[count] = true;
                            data[dataSize++] = data[count] + (float)X1[i3];
                        }
                        ++count;
                    }
                    continue;
                }
                msng1 = bitsmv1[gdrs.numberOfBits];
                msng2 = msng1 - 1;
                if (X1[i3] == msng1) {
                    for (j = 0; j < L[i3]; ++j) {
                        dataBitMap[count++] = false;
                    }
                    continue;
                }
                if (mvm == 2 && X1[i3] == msng2) {
                    for (j = 0; j < L[i3]; ++j) {
                        dataBitMap[count++] = false;
                    }
                    continue;
                }
                for (j = 0; j < L[i3]; ++j) {
                    dataBitMap[count] = true;
                    data[dataSize++] = X1[i3];
                    ++count;
                }
            }
        }
        if (os == 1) {
            data[0] = ival1;
            itemp = mvm == 0 ? this.totalNPoints : dataSize;
            for (i2 = 1; i2 < itemp; ++i2) {
                int n = i2;
                data[n] = data[n] + (float)minsd;
                data[i2] = data[i2] + data[i2 - 1];
            }
        } else if (os == 2) {
            data[0] = ival1;
            data[1] = ival2;
            itemp = mvm == 0 ? this.totalNPoints : dataSize;
            for (i2 = 2; i2 < itemp; ++i2) {
                int n = i2;
                data[n] = data[n] + (float)minsd;
                data[i2] = data[i2] + 2.0f * data[i2 - 1] - data[i2 - 2];
            }
        }
        if (mvm == 0) {
            for (i3 = 0; i3 < data.length; ++i3) {
                data[i3] = (R + data[i3] * EE) / DD;
            }
        } else if (mvm == 1 || mvm == 2) {
            int count2 = 0;
            float[] tmp = new float[this.totalNPoints];
            for (i = 0; i < data.length; ++i) {
                tmp[i] = dataBitMap[i] ? (R + data[count2++] * EE) / DD : mv;
            }
            data = tmp;
        }
        if (this.bitmap != null) {
            int idx = 0;
            float[] tmp = new float[this.totalNPoints];
            for (i = 0; i < this.totalNPoints; ++i) {
                tmp[i] = GribNumbers.testBitIsSet(this.bitmap[i / 8], i % 8) ? data[idx++] : mv;
            }
            data = tmp;
        }
        return data;
    }

    private float[] getData40(RandomAccessFile raf, Grib2Drs.Type40 gdrs) throws IOException {
        int nb = gdrs.numberOfBits;
        int D = gdrs.decimalScaleFactor;
        float DD = (float)Math.pow(10.0, D);
        float R = gdrs.referenceValue;
        int E = gdrs.binaryScaleFactor;
        float EE = (float)Math.pow(2.0, E);
        float ref_val = R / DD;
        Grib2JpegDecoder g2j = null;
        if (nb != 0) {
            g2j = new Grib2JpegDecoder(nb, false);
            byte[] buf = new byte[this.dataLength - 5];
            raf.readFully(buf);
            g2j.decode(buf);
            gdrs.hasSignedProblem = g2j.hasSignedProblem();
        }
        float[] result = new float[this.totalNPoints];
        if (nb == 0) {
            for (int i = 0; i < this.dataNPoints; ++i) {
                result[i] = ref_val;
            }
            return result;
        }
        int[] idata = g2j.getGdata();
        if (this.bitmap == null) {
            if (idata.length != this.dataNPoints) {
                logger.debug("Number of points in the data record {} != {} expected from GDS", (Object)idata.length, (Object)this.dataNPoints);
                throw new IllegalStateException("Number of points in the data record {} != expected from GDS");
            }
            for (int i = 0; i < this.dataNPoints; ++i) {
                result[i] = (R + (float)idata[i] * EE) / DD;
            }
            return result;
        }
        int j = 0;
        for (int i = 0; i < this.totalNPoints; ++i) {
            if (GribNumbers.testBitIsSet(this.bitmap[i / 8], i % 8)) {
                if (j >= idata.length) {
                    logger.warn("jj2000 data count {} < bitmask count {}, i={}, totalNPoints={}", new Object[]{idata.length, j, i, this.totalNPoints});
                    break;
                }
                int indata = idata[j];
                result[i] = (R + (float)indata * EE) / DD;
                ++j;
                continue;
            }
            result[i] = Float.NaN;
        }
        return result;
    }

    @Nullable
    private int[] getData40raw(RandomAccessFile raf, Grib2Drs.Type40 gdrs) throws IOException {
        int nb = gdrs.numberOfBits;
        if (nb == 0) {
            return null;
        }
        int missing_value = (2 << nb - 1) - 1;
        Grib2JpegDecoder g2j = new Grib2JpegDecoder(nb, false);
        byte[] buf = new byte[this.dataLength - 5];
        raf.readFully(buf);
        g2j.decode(buf);
        gdrs.hasSignedProblem = g2j.hasSignedProblem();
        int[] idata = g2j.getGdata();
        if (this.bitmap == null) {
            if (idata.length != this.totalNPoints) {
                logger.debug("Number of points in the data record {} != {} expected from GDS", (Object)idata.length, (Object)this.totalNPoints);
                return null;
            }
            return idata;
        }
        int[] result = new int[this.totalNPoints];
        int j = 0;
        for (int i = 0; i < this.totalNPoints; ++i) {
            if (GribNumbers.testBitIsSet(this.bitmap[i / 8], i % 8)) {
                if (j >= idata.length) {
                    logger.warn("jj2000 data count {} < bitmask count {}, i={}, totalNPoints={}", new Object[]{idata.length, j, i, this.totalNPoints});
                    break;
                }
                result[i] = idata[j];
                ++j;
                continue;
            }
            result[i] = missing_value;
        }
        return result;
    }

    private float[] getData41(RandomAccessFile raf, Grib2Drs.Type0 gdrs) throws IOException {
        int nb = gdrs.numberOfBits;
        int D = gdrs.decimalScaleFactor;
        float DD = (float)Math.pow(10.0, D);
        float R = gdrs.referenceValue;
        int E = gdrs.binaryScaleFactor;
        float EE = (float)Math.pow(2.0, E);
        float[] data = new float[this.totalNPoints];
        if (nb == 0) {
            Arrays.fill(data, R);
            return data;
        }
        byte[] buf = new byte[this.dataLength - 5];
        raf.readFully(buf);
        ByteArrayInputStream in = new ByteArrayInputStream(buf);
        BufferedImage image = ImageIO.read(in);
        if (nb != image.getColorModel().getPixelSize()) {
            logger.debug("PNG pixel size {} disagrees with grib number of bits {}", (Object)image.getColorModel().getPixelSize(), (Object)nb);
        }
        DataBuffer db = image.getRaster().getDataBuffer();
        int numBands = image.getRaster().getNumBands();
        if (this.bitmap == null) {
            for (int i = 0; i < this.dataNPoints; ++i) {
                int offset = i * numBands;
                int gridValue = this.decodePng(numBands, offset, db);
                data[i] = (R + (float)gridValue * EE) / DD;
            }
        } else {
            int dataPt = 0;
            for (int bitPt = 0; bitPt < this.totalNPoints; ++bitPt) {
                if (GribNumbers.testBitIsSet(this.bitmap[bitPt / 8], bitPt % 8)) {
                    int offset = dataPt++ * numBands;
                    int gridValue = this.decodePng(numBands, offset, db);
                    data[bitPt] = (R + (float)gridValue * EE) / DD;
                    continue;
                }
                data[bitPt] = Float.NaN;
            }
        }
        return data;
    }

    private int decodePng(int numBands, int offset, DataBuffer db) throws IOException {
        int gridValue = 0;
        switch (numBands) {
            case 1: {
                gridValue = db.getElem(offset);
                break;
            }
            case 3: 
            case 4: {
                int red = Byte.toUnsignedInt((byte)db.getElem(offset));
                int green = Byte.toUnsignedInt((byte)db.getElem(offset + 1));
                int blue = Byte.toUnsignedInt((byte)db.getElem(offset + 2));
                if (numBands == 3) {
                    gridValue = GribNumbers.uint3(blue, green, red);
                    break;
                }
                int alpha = Byte.toUnsignedInt((byte)db.getElem(offset + 3));
                gridValue = GribNumbers.int4(alpha, blue, green, red);
                break;
            }
            default: {
                throw new IOException("Cannot handle png compressed GRIB messages with " + numBands + " samples per pixel.");
            }
        }
        return gridValue;
    }

    private float[] getData50002(RandomAccessFile raf, Grib2Drs.Type50002 gdrs) throws IOException {
        BitReader reader = new BitReader(raf, this.startPos + 5L);
        int[] groupWidth = new int[gdrs.p1];
        for (int i = 0; i < gdrs.p1; ++i) {
            groupWidth[i] = (int)reader.bits2UInt(gdrs.widthOfWidth);
        }
        reader = new BitReader(raf, raf.getFilePointer());
        int[] groupLength = new int[gdrs.p1];
        for (int i = 0; i < gdrs.p1; ++i) {
            groupLength[i] = (int)reader.bits2UInt(gdrs.widthOfLength);
        }
        reader = new BitReader(raf, raf.getFilePointer());
        int[] firstOrderValues = new int[gdrs.p1];
        for (int i = 0; i < gdrs.p1; ++i) {
            firstOrderValues[i] = (int)reader.bits2UInt(gdrs.widthOfFirstOrderValues);
        }
        int bias = 0;
        if (gdrs.orderOfSPD > 0) {
            bias = gdrs.spd[gdrs.orderOfSPD];
        }
        reader = new BitReader(raf, raf.getFilePointer());
        int cnt = gdrs.orderOfSPD;
        int[] data = new int[this.totalNPoints];
        for (int i = 0; i < gdrs.p1; ++i) {
            int j;
            if (groupWidth[i] > 0) {
                for (j = 0; j < groupLength[i]; ++j) {
                    data[cnt] = (int)reader.bits2UInt(groupWidth[i]);
                    int n = cnt++;
                    data[n] = data[n] + firstOrderValues[i];
                }
                continue;
            }
            for (j = 0; j < groupLength[i]; ++j) {
                data[cnt] = firstOrderValues[i];
                ++cnt;
            }
        }
        if (gdrs.orderOfSPD >= 0) {
            System.arraycopy(gdrs.spd, 0, data, 0, gdrs.orderOfSPD);
        }
        switch (gdrs.orderOfSPD) {
            case 1: {
                int i;
                int y = data[0];
                for (i = 1; i < this.totalNPoints; ++i) {
                    data[i] = y += data[i] + bias;
                }
                break;
            }
            case 2: {
                int i;
                int y = data[1] - data[0];
                int z = data[1];
                for (i = 2; i < this.totalNPoints; ++i) {
                    data[i] = z += (y += data[i] + bias);
                }
                break;
            }
            case 3: {
                int i;
                int y = data[2] - data[1];
                int z = y - (data[1] - data[0]);
                int w = data[2];
                for (i = 3; i < this.totalNPoints; ++i) {
                    data[i] = w += (y += (z += data[i] + bias));
                }
                break;
            }
        }
        int D = gdrs.decimalScaleFactor;
        float DD = (float)Math.pow(10.0, -D);
        float R = gdrs.referenceValue;
        int E = gdrs.binaryScaleFactor;
        float EE = (float)Math.pow(2.0, E);
        float[] ret = new float[this.totalNPoints];
        for (int i = 0; i < this.totalNPoints; ++i) {
            ret[i] = ((float)data[i] * EE + R) * DD;
        }
        return ret;
    }

    private float[] getData42(RandomAccessFile raf, Grib2Drs.Type42 gdrs) throws IOException {
        byte[] decodedData;
        int encodedLength = this.dataLength - 5;
        byte[] inputData = new byte[encodedLength];
        raf.readFully(inputData);
        int nbytesPerSample = (gdrs.numberOfBits + 7) / 8;
        try (Memory inputMemory = new Memory((long)encodedLength);
             Memory outputMemory = new Memory((long)nbytesPerSample * (long)this.totalNPoints);){
            LibAec.AecStream aecStreamDecode = LibAec.AecStream.create((int)gdrs.numberOfBits, (int)gdrs.blockSize, (int)gdrs.referenceSampleInterval, (int)gdrs.compressionOptionsMask);
            inputMemory.write(0L, inputData, 0, inputData.length);
            aecStreamDecode.setInputMemory(inputMemory);
            aecStreamDecode.setOutputMemory(outputMemory);
            int ok = LibAec.aec_buffer_decode((LibAec.AecStream)aecStreamDecode);
            if (ok != 0) {
                System.out.printf("AEC Error: %s%n", ok);
            }
            decodedData = new byte[nbytesPerSample * this.totalNPoints];
            outputMemory.read(0L, decodedData, 0, decodedData.length);
        }
        ByteBuffer bb = ByteBuffer.wrap(decodedData);
        int D = gdrs.decimalScaleFactor;
        float DD = (float)Math.pow(10.0, D);
        float R = gdrs.referenceValue;
        int E = gdrs.binaryScaleFactor;
        float EE = (float)Math.pow(2.0, E);
        float[] data = new float[decodedData.length];
        if (this.bitmap == null) {
            for (int i = 0; i < this.totalNPoints; ++i) {
                data[i] = (R + (float)this.getNextLong(bb, nbytesPerSample) * EE) / DD;
            }
        } else {
            for (int i = 0; i < this.totalNPoints; ++i) {
                data[i] = GribNumbers.testBitIsSet(this.bitmap[i / 8], i % 8) ? (R + (float)this.getNextLong(bb, nbytesPerSample) * EE) / DD : Float.NaN;
            }
        }
        return data;
    }

    private long getNextLong(ByteBuffer bb, int numberOfBytes) throws IOException {
        switch (numberOfBytes) {
            case 1: {
                return Byte.toUnsignedLong(bb.get());
            }
            case 2: {
                return Short.toUnsignedLong(bb.getShort());
            }
            case 4: {
                return Integer.toUnsignedLong(bb.getInt());
            }
        }
        throw new IOException("Invalid number of bytes per sample for GDR42: " + numberOfBytes);
    }

    private void scanningModeCheck(float[] data, int scanMode, int Xlength) {
        if (scanMode == 0 || scanMode == 64) {
            return;
        }
        if (!GribUtils.scanModeXisPositive(scanMode)) {
            int mid = Xlength / 2;
            for (int index = 0; index < data.length; index += Xlength) {
                for (int idx = 0; idx < mid; ++idx) {
                    float tmp = data[index + idx];
                    data[index + idx] = data[index + Xlength - idx - 1];
                    data[index + Xlength - idx - 1] = tmp;
                }
            }
            return;
        }
        if (!GribUtils.scanModeSameDirection(scanMode)) {
            int mid = Xlength / 2;
            for (int index = 0; index < data.length; index += Xlength) {
                int row = index / Xlength;
                if (row % 2 == 0) continue;
                for (int idx = 0; idx < mid; ++idx) {
                    float tmp = data[index + idx];
                    data[index + idx] = data[index + Xlength - idx - 1];
                    data[index + Xlength - idx - 1] = tmp;
                }
            }
        }
    }

    static {
        for (int i = 0; i < 31; ++i) {
            Grib2DataReader.bitsmv1[i] = (int)Math.pow(2.0, i) - 1;
        }
    }
}

