/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.sampling.distribution;

import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.LargeMeanPoissonSampler;
import org.apache.commons.rng.sampling.distribution.SamplerBase;
import org.apache.commons.rng.sampling.distribution.SharedStateDiscreteSampler;
import org.apache.commons.rng.sampling.distribution.SmallMeanPoissonSampler;

public class PoissonSampler
extends SamplerBase
implements SharedStateDiscreteSampler {
    static final double PIVOT = 40.0;
    private final SharedStateDiscreteSampler poissonSamplerDelegate;

    public PoissonSampler(UniformRandomProvider rng, double mean) {
        super(null);
        this.poissonSamplerDelegate = PoissonSampler.of(rng, mean);
    }

    @Override
    public int sample() {
        return this.poissonSamplerDelegate.sample();
    }

    @Override
    public String toString() {
        return this.poissonSamplerDelegate.toString();
    }

    @Override
    public SharedStateDiscreteSampler withUniformRandomProvider(UniformRandomProvider rng) {
        return (SharedStateDiscreteSampler)this.poissonSamplerDelegate.withUniformRandomProvider(rng);
    }

    public static SharedStateDiscreteSampler of(UniformRandomProvider rng, double mean) {
        return mean < 40.0 ? SmallMeanPoissonSampler.of(rng, mean) : LargeMeanPoissonSampler.of(rng, mean);
    }
}

