/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.euclidean.threed;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.geometry.euclidean.threed.BoundarySource3D;
import org.apache.commons.geometry.euclidean.threed.PlaneConvexSubset;
import org.apache.commons.geometry.euclidean.threed.Vector3D;
import org.apache.commons.geometry.euclidean.threed.line.LineConvexSubset3D;
import org.apache.commons.geometry.euclidean.threed.line.LinecastPoint3D;
import org.apache.commons.geometry.euclidean.threed.line.Linecastable3D;

final class BoundarySourceLinecaster3D
implements Linecastable3D {
    private final BoundarySource3D boundarySrc;

    BoundarySourceLinecaster3D(BoundarySource3D boundarySrc) {
        this.boundarySrc = boundarySrc;
    }

    @Override
    public List<LinecastPoint3D> linecast(LineConvexSubset3D subset) {
        try (Stream<LinecastPoint3D> stream = this.getIntersectionStream(subset);){
            List results = stream.collect(Collectors.toCollection(ArrayList::new));
            LinecastPoint3D.sortAndFilter(results);
            List list = results;
            return list;
        }
    }

    @Override
    public LinecastPoint3D linecastFirst(LineConvexSubset3D subset) {
        try (Stream<LinecastPoint3D> stream = this.getIntersectionStream(subset);){
            LinecastPoint3D linecastPoint3D = stream.min(LinecastPoint3D.ABSCISSA_ORDER).orElse(null);
            return linecastPoint3D;
        }
    }

    private Stream<LinecastPoint3D> getIntersectionStream(LineConvexSubset3D subset) {
        return this.boundarySrc.boundaryStream().map(boundary -> this.computeIntersection((PlaneConvexSubset)boundary, subset)).filter(Objects::nonNull);
    }

    private LinecastPoint3D computeIntersection(PlaneConvexSubset planeSubset, LineConvexSubset3D lineSubset) {
        Vector3D intersectionPt = planeSubset.intersection(lineSubset);
        if (intersectionPt != null) {
            Vector3D.Unit normal = planeSubset.getPlane().getNormal();
            return new LinecastPoint3D(intersectionPt, normal, lineSubset.getLine());
        }
        return null;
    }
}

