/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.core.partitioning.bsp;

import org.apache.commons.geometry.core.Point;
import org.apache.commons.geometry.core.partitioning.bsp.BSPTree;
import org.apache.commons.geometry.core.partitioning.bsp.BSPTreeVisitor;

final class BSPTreePrinter<P extends Point<P>, N extends BSPTree.Node<P, N>>
implements BSPTreeVisitor<P, N> {
    private static final String INDENT = "    ";
    private static final String NEW_LINE = "\n";
    private static final String MINUS_CHILD = "[-] ";
    private static final String PLUS_CHILD = "[+] ";
    private static final String ELLIPSIS = "...";
    private final int maxDepth;
    private final StringBuilder output = new StringBuilder();

    BSPTreePrinter(int maxDepth) {
        this.maxDepth = maxDepth;
    }

    @Override
    public BSPTreeVisitor.Result visit(N node) {
        int depth = node.depth();
        if (depth <= this.maxDepth) {
            this.startLine(node);
            this.writeNode(node);
        } else if (depth == this.maxDepth + 1 && node.isPlus()) {
            this.startLine(node);
            this.write(ELLIPSIS);
        }
        return BSPTreeVisitor.Result.CONTINUE;
    }

    @Override
    public BSPTreeVisitor.Order visitOrder(N node) {
        if (node.depth() > this.maxDepth + 1) {
            return BSPTreeVisitor.Order.NONE;
        }
        return BSPTreeVisitor.Order.NODE_MINUS_PLUS;
    }

    private void startLine(N node) {
        if (node.getParent() != null) {
            this.write(NEW_LINE);
        }
        int depth = node.depth();
        for (int i = 0; i < depth; ++i) {
            this.write(INDENT);
        }
    }

    private void writeNode(N node) {
        if (node.getParent() != null) {
            if (node.isMinus()) {
                this.write(MINUS_CHILD);
            } else {
                this.write(PLUS_CHILD);
            }
        }
        this.write(node.toString());
    }

    private void write(String str) {
        this.output.append(str);
    }

    public String toString() {
        return this.output.toString();
    }
}

