fn = 'D:/Temp/nc/2019_mon_u_v.nc'
f = addfile(fn)
u = f['U'][0,::-1]
v = f['V'][0,::-1]
lon1 = u.dimvalue(1)
lat1 = u.dimvalue(0)
lon, lat = meshgrid(lon1, lat1)

psi, Upsi, Vpsi = meteolib.stream_function(lon, lat, u, v, 10000, 1e-7)

axesm()
geoshow('country', edgecolor='darkgray')    
levs = arange(-20, 20.1, 2)
contourf(lon1, lat1, psi*1e-6, levs, extend='both', cmap='amwg256')
colorbar() 
ss = 10
qq = quiver(lon[::ss,::ss], lat[::ss,::ss], Upsi[::ss,::ss], Vpsi[::ss,::ss], 
    size=30, overhang=1, headwidth=4, headlength=4, antialias=True)
quiverkey(qq, 0.85, 0.12, 10, bbox={'edge':True, 'fill':True})
title('Stream function')