mu = 60.0
sigma = 2.0
x = mu + sigma * random.randn(500)
bins = 50
n, bins, patches = hist(x, bins, density=True, histtype="bar", 
    facecolor="#99FF33", edgecolor="#00FF99", alpha=0.75)
y = ((1/(np.power(2*np.pi, 0.5)*sigma))*np.exp(-0.5*
    np.power((bins-mu)/sigma, 2)))

plot(bins, y, color="#7744FF", linestyle="--", linewidth=2)
grid(linestype=":", linewidth=1, color="gray", alpha=0.2)
text(54, 0.2, r"$y=\frac{1}{\sqrt{2\pi}\sigma}e^{-\frac{(x-\mu)^2}{2\sigma^2}}$", 
    fontsize=20)
xlabel(u"体重", fontname=u'楷体')
ylabel(u"概率密度", fontname=u'楷体')
title(u"体重的直方图" + r"：$\mu=60.0$, $\sigma=2.0$", fontsize=16, 
    fontname=u'黑体')