/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.data.mapdata.webmap;

import org.meteoinfo.data.mapdata.webmap.TileFactoryInfo;

public class BingMapInfo
extends TileFactoryInfo {
    private String version = "2660";
    private String clientKey = null;

    public BingMapInfo() {
        super("BingMap", 1, 17, 19, 256, true, true, "http://ecn.t%1$d.tiles.virtualearth.net/tiles/r%2$s?g=%3$s&mkt=%4$s&lbl=l1&stl=h&shading=hill&n=z%5$s");
        if (this.getLanguage().equals("zh-cn")) {
            this.baseURL = "http://t%1$d.tiles.ditu.live.com/tiles/r%2$s.png?g=%3$s&mkt=%4$s&n=z%5$s";
        }
    }

    @Override
    public void setLanguage(String value) {
        super.setLanguage(value);
        this.baseURL = value.equals("zh-cn") ? "http://t%1$d.tiles.ditu.live.com/tiles/r%2$s.png?g=%3$s&mkt=%4$s&n=z%5$s" : "http://ecn.t%1$d.tiles.virtualearth.net/tiles/r%2$s?g=%3$s&mkt=%4$s&lbl=l1&stl=h&shading=hill&n=z%5$s";
    }

    @Override
    public String getTileUrl(int x, int y, int zoom) {
        zoom = this.getTotalMapZoom() - zoom;
        int serverNum = this.getServerNum(x, y, 4);
        String key = this.tileXYToQuadKey(x, y, zoom);
        String ckey = this.clientKey;
        if (ckey == null) {
            ckey = "";
        }
        String url = String.format(this.baseURL, serverNum, key, this.version, this.getLanguage(), zoom);
        return url;
    }

    private String tileXYToQuadKey(long tileX, long tileY, int levelOfDetail) {
        StringBuilder quadKey = new StringBuilder();
        for (int i = levelOfDetail; i > 0; --i) {
            char digit = '0';
            int mask = 1 << i - 1;
            if ((tileX & (long)mask) != 0L) {
                digit = (char)(digit + 1);
            }
            if ((tileY & (long)mask) != 0L) {
                digit = (char)(digit + 1);
                digit = (char)(digit + '\u0001');
            }
            quadKey.append(digit);
        }
        return quadKey.toString();
    }
}

