/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.chart.graphic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.meteoinfo.geometry.graphic.GraphicCollection3D;

public class ParticleGraphics
extends GraphicCollection3D {
    private float pointSize = 2.0f;
    private HashMap<Integer, List> particles = new HashMap();

    public float getPointSize() {
        return this.pointSize;
    }

    public void setPointSize(float value) {
        this.pointSize = value;
    }

    public HashMap<Integer, List> getParticles() {
        return this.particles;
    }

    public void setParticles(HashMap<Integer, List> value) {
        this.particles = value;
    }

    public void addParticle(int key, Particle particle) {
        if (this.particles.containsKey(key)) {
            this.particles.get(key).add(particle);
        } else {
            ArrayList<Particle> list = new ArrayList<Particle>();
            list.add(particle);
            this.particles.put(key, list);
        }
    }

    public int getPointNumber() {
        int n = 0;
        for (List list : this.particles.values()) {
            n += list.size();
        }
        return n;
    }

    public List<Map.Entry<Integer, List>> getParticleList() {
        ArrayList<Map.Entry<Integer, List>> list = new ArrayList<Map.Entry<Integer, List>>(this.particles.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<Integer, List>>(){

            @Override
            public int compare(Map.Entry<Integer, List> mapping1, Map.Entry<Integer, List> mapping2) {
                return mapping2.getKey() - mapping1.getKey();
            }
        });
        return list;
    }

    public static class Particle {
        public float x;
        public float y;
        public float z;
        public float[] rgba;
    }
}

