/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.svggen;

import io.sf.carte.echosvg.ext.awt.g2d.GraphicContext;
import io.sf.carte.echosvg.svggen.AbstractSVGConverter;
import io.sf.carte.echosvg.svggen.SVGDescriptor;
import io.sf.carte.echosvg.svggen.SVGGeneratorContext;
import io.sf.carte.echosvg.svggen.SVGPaintDescriptor;
import java.awt.Color;
import java.awt.Paint;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class SVGColor
extends AbstractSVGConverter {
    public static final Color aqua = Color.cyan;
    public static final Color black = Color.black;
    public static final Color blue = Color.blue;
    public static final Color fuchsia = Color.magenta;
    public static final Color gray = Color.gray;
    public static final Color green = new Color(0, 128, 0);
    public static final Color lime = Color.green;
    public static final Color maroon = new Color(128, 0, 0);
    public static final Color navy = new Color(0, 0, 128);
    public static final Color olive = new Color(128, 128, 0);
    public static final Color purple = new Color(128, 0, 128);
    public static final Color red = Color.red;
    public static final Color silver = new Color(192, 192, 192);
    public static final Color teal = new Color(0, 128, 128);
    public static final Color white = Color.white;
    public static final Color yellow = Color.yellow;
    private static final Set<String> cssProfileNames;
    private static Map<Color, String> colorMap;

    public SVGColor(SVGGeneratorContext generatorContext) {
        super(generatorContext);
    }

    @Override
    public SVGDescriptor toSVG(GraphicContext gc) {
        Paint paint = gc.getPaint();
        return SVGColor.toSVG((Color)paint, this.getGeneratorContext());
    }

    public static SVGPaintDescriptor toSVG(Color color, SVGGeneratorContext gc) {
        String cssColor = colorMap.get(color);
        if (cssColor == null) {
            cssColor = SVGColor.serializeColor(color);
        }
        float alpha = (float)color.getAlpha() / 255.0f;
        String alphaString = gc.doubleString(alpha);
        return new SVGPaintDescriptor(cssColor, alphaString);
    }

    private static String serializeColor(Color color) {
        StringBuilder cssColorBuffer;
        ColorSpace cs = color.getColorSpace();
        if (!cs.isCS_sRGB()) {
            String csName;
            float[] comps = color.getColorComponents(null);
            if (!(cs instanceof ICC_ColorSpace) || (csName = SVGColor.lcColorProfileName((ICC_ColorSpace)cs)) == null || !cssProfileNames.contains(csName)) {
                csName = "xyz-d50";
                comps = cs.toCIEXYZ(comps);
            }
            DecimalFormatSymbols dfs = new DecimalFormatSymbols(Locale.ROOT);
            DecimalFormat df = new DecimalFormat("#.#", dfs);
            df.setMaximumFractionDigits(6);
            cssColorBuffer = new StringBuilder(csName.length() + 34);
            cssColorBuffer.append("color(").append(csName);
            for (float comp : comps) {
                cssColorBuffer.append(' ').append(df.format(comp));
            }
            cssColorBuffer.append(')');
        } else {
            cssColorBuffer = new StringBuilder(16);
            cssColorBuffer.append("rgb(");
            cssColorBuffer.append(color.getRed());
            cssColorBuffer.append(",");
            cssColorBuffer.append(color.getGreen());
            cssColorBuffer.append(",");
            cssColorBuffer.append(color.getBlue());
            cssColorBuffer.append(")");
        }
        return cssColorBuffer.toString();
    }

    private static String lcColorProfileName(ICC_ColorSpace cs) {
        int numrec;
        ICC_Profile profile = cs.getProfile();
        byte[] bdesc = profile.getData(1684370275);
        byte[] mluc = new byte[]{109, 108, 117, 99};
        String iccProfileName = null;
        if (bdesc != null && Arrays.equals(bdesc, 0, 4, mluc, 0, 4) && (numrec = SVGColor.uInt32Number(bdesc, 8)) > 0) {
            int len = SVGColor.uInt32Number(bdesc, 20);
            int offset = SVGColor.uInt32Number(bdesc, 24);
            int maxlen = bdesc.length - offset;
            if (maxlen > 0) {
                len = Math.min(len, maxlen);
                iccProfileName = new String(bdesc, offset, len, StandardCharsets.UTF_16BE).trim();
                if ((iccProfileName = iccProfileName.toLowerCase(Locale.ROOT).replace(' ', '-')).contains("bt.2020")) {
                    iccProfileName = "rec2020";
                } else if ("adobe-rgb-(1998)".equals(iccProfileName)) {
                    iccProfileName = "a98-rgb";
                }
            }
        }
        return iccProfileName;
    }

    private static int uInt32Number(byte[] bytes, int offset) {
        long value = (long)(bytes[offset + 3] & 0xFF | (bytes[offset + 2] & 0xFF) << 8 | (bytes[offset + 1] & 0xFF) << 16) | (long)(bytes[offset] & 0xFF) << 24;
        return (int)value;
    }

    static {
        colorMap = new HashMap<Color, String>();
        colorMap.put(black, "black");
        colorMap.put(silver, "silver");
        colorMap.put(gray, "gray");
        colorMap.put(white, "white");
        colorMap.put(maroon, "maroon");
        colorMap.put(red, "red");
        colorMap.put(purple, "purple");
        colorMap.put(fuchsia, "fuchsia");
        colorMap.put(green, "green");
        colorMap.put(lime, "lime");
        colorMap.put(olive, "olive");
        colorMap.put(yellow, "yellow");
        colorMap.put(navy, "navy");
        colorMap.put(blue, "blue");
        colorMap.put(teal, "teal");
        colorMap.put(aqua, "aqua");
        String[] knownProfiles = new String[]{"display-p3", "a98-rgb", "prophoto-rgb", "rec2020"};
        cssProfileNames = new HashSet<String>(knownProfiles.length);
        Collections.addAll(cssProfileNames, knownProfiles);
    }
}

