/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc.array.projected;

import gov.nasa.giss.data.nc.NcException;
import gov.nasa.giss.data.nc.NcLLAltGridding;
import gov.nasa.giss.data.nc.NcLLAltGriddingVarType;
import gov.nasa.giss.data.nc.NcVarType;
import gov.nasa.giss.data.nc.NcVariable;
import gov.nasa.giss.data.nc.array.NcArrayLonLat;
import gov.nasa.giss.data.nc.array.NcArrayLonLatProjected;
import gov.nasa.giss.data.nc.array.NcLonLatProjGridding;
import gov.nasa.giss.data.nc.exc.NcNullException;
import gov.nasa.giss.math.PointLL;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.VariableDS;
import ucar.unidata.geoloc.Projection;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.projection.AlbersEqualArea;
import ucar.unidata.geoloc.projection.proj4.AlbersEqualAreaEllipse;

public class NcArrayLonLatAlbersEqualAreaConic
extends NcArrayLonLatProjected {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private boolean useNjProj_;
    private Projection njProj_;
    private double phi1_ = 30.0;
    private double phi2_ = -30.0;
    private double termC_;
    private double termN_;
    private double twoN_;
    private double oneOverN_;
    private double rho0_;

    public NcArrayLonLatAlbersEqualAreaConic(NcVariable ncvar) throws NcException {
        super(ncvar, NcLonLatProjGridding.ALBERS_CONIC);
        this.initMe();
    }

    private void initMe() {
        NcVarType vtype = this.ncvar_.getVarType();
        if (!(vtype instanceof NcLLAltGriddingVarType)) {
            throw new NcException("Variable is not on a projected grid.");
        }
        if (!((NcLLAltGriddingVarType)vtype).isGrid(NcLLAltGridding.ALBERS_CONIC)) {
            throw new NcException("Variable is not projected type Albers equal-area conic.");
        }
        this.initGissProj();
        if (this.ellipsoid_) {
            LOGGER.trace("Ellipsoid. Using NJ proj.");
            this.useNjProj_ = true;
            this.initUnidataProj();
        } else {
            LOGGER.trace("Sphere. Using GISS proj.");
        }
    }

    private void initUnidataProj() {
        VariableDS njvarDS = (VariableDS)this.ncvar_.getObject();
        List csList = njvarDS.getCoordinateSystems();
        if (csList.isEmpty()) {
            throw new NcException("No coordinate system(s) reported.");
        }
        CoordinateSystem cs = (CoordinateSystem)csList.get(0);
        ProjectionImpl pj = cs.getProjection();
        if (pj == null) {
            throw new NcNullException("C.S. returned null projection handler.");
        }
        LOGGER.trace("C.S. returned projection {}", (Object)pj.getClass().getSimpleName());
        if (!(pj instanceof AlbersEqualArea) && !(pj instanceof AlbersEqualAreaEllipse)) {
            LOGGER.warn("Expected AlbersEqualArea(X) class but got {}", (Object)pj.getClass().getSimpleName());
            throw new NcException("C.S. returned projection class " + pj.getClass().getSimpleName() + " when AlbersEqualArea or AlbersEqualAreaEllipse was expected");
        }
        this.njProj_ = pj;
    }

    private void initGissProj() {
        this.getGridMappingName();
        if (!this.mappingName_.equalsIgnoreCase("albers_equal_area_conic") && !this.mappingName_.equalsIgnoreCase("albers_conical_equal_area")) {
            LOGGER.trace("Found unusable mapping name {}", (Object)this.mappingName_);
            throw new NcException("Mapping name is not albers_equal_area_conic or albers_conical_equal_area");
        }
        this.initCenter();
        this.initRadiusEastingAndNorthing();
        LOGGER.trace("ellipsoid {}", (Object)this.ellipsoid_);
        Attribute parallelsA = this.mappingVarDS_.findAttribute("standard_parallel");
        if (parallelsA == null) {
            throw new NcException("Coordinate transform variable is missing standard parallel(s)");
        }
        if (parallelsA.isArray()) {
            Array pararray = parallelsA.getValues();
            double[] parvalues = (double[])pararray.get1DJavaArray(DataType.DOUBLE);
            this.phi1_ = parvalues[0];
            this.phi2_ = parvalues[1];
        } else {
            this.phi2_ = this.phi1_ = parallelsA.getNumericValue().doubleValue();
        }
        double phi1Rad = Math.toRadians(this.phi1_);
        double phi2Rad = Math.toRadians(this.phi2_);
        double cosPhi1 = Math.cos(phi1Rad);
        double sinPhiC = Math.sin(this.phiCRad_);
        double sinPhi1 = Math.sin(phi1Rad);
        double sinPhi2 = Math.sin(phi2Rad);
        this.termN_ = 0.5 * (sinPhi1 + sinPhi2);
        this.twoN_ = 2.0 * this.termN_;
        this.oneOverN_ = 1.0 / this.termN_;
        this.termC_ = cosPhi1 * cosPhi1 + this.twoN_ * sinPhi1;
        this.rho0_ = Math.sqrt(this.termC_ - this.twoN_ * sinPhiC) * this.oneOverN_;
    }

    @Override
    public Point2D.Double transformLL2XY(double lon, double lat) {
        if (this.useNjProj_) {
            return NcArrayLonLatAlbersEqualAreaConic.transformNjLL2XY(this.njProj_, lon, lat);
        }
        if (NcArrayLonLat.isBadLatitude(lat)) {
            return null;
        }
        double lambdaRad = this.lonToLambdaRad(lon);
        double phiRad = Math.toRadians(lat);
        double rho = Math.sqrt(this.termC_ - this.twoN_ * Math.sin(phiRad)) * this.oneOverN_;
        double theta = this.termN_ * lambdaRad;
        double x = rho * Math.sin(theta);
        double y = this.rho0_ - rho * Math.cos(theta);
        return new Point2D.Double(x * this.radius_ + this.falseEasting_, y * this.radius_ + this.falseNorthing_);
    }

    @Override
    public PointLL transformXY2LL(double x, double y) {
        if (this.useNjProj_) {
            return NcArrayLonLatAlbersEqualAreaConic.transformNjXY2LL(this.njProj_, x, y);
        }
        double xOverR = (x - this.falseEasting_) * this.oneOverR_;
        double yOverR = (y - this.falseNorthing_) * this.oneOverR_;
        double rho0MinusYOverR = this.rho0_ - yOverR;
        double rho = Math.hypot(xOverR, rho0MinusYOverR);
        double nRho = this.termN_ * rho;
        double phiRad = Math.asin(0.5 * (this.termC_ - nRho * nRho) * this.oneOverN_);
        if (Double.isNaN(phiRad) || Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double theta = this.termN_ < 0.0 ? Math.atan2(-xOverR, -rho0MinusYOverR) : Math.atan2(xOverR, rho0MinusYOverR);
        double lambdaRad = theta * this.oneOverN_;
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        return new PointLL(this.lambdaC_ + Math.toDegrees(lambdaRad), Math.toDegrees(phiRad));
    }
}

