/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc.array.projected;

import gov.nasa.giss.data.nc.NcException;
import gov.nasa.giss.data.nc.NcLLAltGridding;
import gov.nasa.giss.data.nc.NcLLAltGriddingVarType;
import gov.nasa.giss.data.nc.NcVarType;
import gov.nasa.giss.data.nc.NcVariable;
import gov.nasa.giss.data.nc.array.NcArrayLonLat;
import gov.nasa.giss.data.nc.array.NcArrayLonLatProjected;
import gov.nasa.giss.data.nc.array.NcLonLatProjGridding;
import gov.nasa.giss.data.nc.exc.NcNullException;
import gov.nasa.giss.map.LonLatEdges;
import gov.nasa.giss.math.PointLL;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.Attribute;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.VariableDS;
import ucar.unidata.geoloc.Projection;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.projection.Mercator;

public class NcArrayLonLatMercator
extends NcArrayLonLatProjected {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final boolean USE_NJ_PROJ = false;
    private static final double SMALL_VALUE = 0.001;
    private static final double HALF_PI = 1.5707963267948966;
    private Projection njProj_;
    private double phi1_;
    private double rS_;
    private double oneOverRS_;
    private double halfEccen_ = 0.0;
    private double eterm2_;
    private double eterm4_;
    private double eterm6_;

    public NcArrayLonLatMercator(NcVariable ncvar) throws NcException {
        super(ncvar, NcLonLatProjGridding.MERCATOR);
        this.initMe();
    }

    private void initMe() {
        NcVarType vtype = this.ncvar_.getVarType();
        if (!(vtype instanceof NcLLAltGriddingVarType)) {
            throw new NcException("Variable is not on a projected grid.");
        }
        if (!((NcLLAltGriddingVarType)vtype).isGrid(NcLLAltGridding.MERCATOR)) {
            throw new NcException("Variable is not projected type Mercator.");
        }
        this.initGissProj();
    }

    private void initUnidataProj() {
        VariableDS njvarDS = (VariableDS)this.ncvar_.getObject();
        List csList = njvarDS.getCoordinateSystems();
        if (csList.isEmpty()) {
            throw new NcException("No coordinate system(s) reported.");
        }
        CoordinateSystem cs = (CoordinateSystem)csList.get(0);
        ProjectionImpl pj = cs.getProjection();
        if (pj == null) {
            throw new NcNullException("C.S. returned null projection handler.");
        }
        LOGGER.trace("C.S. returned projection {}", (Object)pj.getClass().getSimpleName());
        if (!(pj instanceof Mercator)) {
            LOGGER.warn("Expected Mercator class but got {}", (Object)pj.getClass().getSimpleName());
            throw new NcException("C.S. returned projection class " + pj.getClass().getSimpleName() + " when Mercator was expected");
        }
        this.njProj_ = pj;
    }

    private void initGissProj() {
        Attribute parallelA;
        this.getGridMappingName();
        if (!this.mappingName_.equalsIgnoreCase("mercator")) {
            LOGGER.trace("Found unusable mapping name {}", (Object)this.mappingName_);
            throw new NcException("Mapping name is not mercator");
        }
        this.initCenter();
        this.initRadiusEastingAndNorthing();
        LOGGER.trace("ellipsoid {}", (Object)this.ellipsoid_);
        if (this.ellipsoid_) {
            this.halfEccen_ = 0.5 * this.eccen_;
            double eccen4 = this.eccen2_ * this.eccen2_;
            double eccen6 = this.eccen2_ * eccen4;
            this.eterm2_ = 0.5 * this.eccen2_ + 0.20833333333333334 * eccen4 + 0.08333333333333333 * eccen6;
            this.eterm4_ = 0.14583333333333334 * eccen4 + 0.12083333333333333 * eccen6;
            this.eterm6_ = 0.058333333333333334 * eccen6;
        }
        if ((parallelA = this.mappingVarDS_.findAttribute("standard_parallel")) == null) {
            this.setScalingFactor(1.0);
        } else {
            this.phi1_ = parallelA.getNumericValue().doubleValue();
            double phi1Rad = Math.toRadians(this.phi1_);
            double sfactor = Math.cos(phi1Rad);
            this.setScalingFactor(sfactor);
        }
        double[][] xBounds = this.getXAxis().getBounds();
        double[][] yBounds = this.getYAxis().getBounds();
        double left = xBounds[0][0];
        double right = xBounds[xBounds.length - 1][1];
        LOGGER.trace("L {}, R {}", (Object)left, (Object)right);
    }

    private void setScalingFactor(double sfactor) {
        this.rS_ = this.ellipsoid_ ? this.semimajor_ * sfactor : this.radius_ * sfactor;
        this.oneOverRS_ = 1.0 / this.rS_;
        LOGGER.trace("S {} - RS {} - 1/RS {}", sfactor, this.rS_, this.oneOverRS_);
    }

    @Override
    public Point2D.Double transformLL2XY(double lon, double lat) {
        if (NcArrayLonLat.isBadLatitude(lat)) {
            return null;
        }
        if (90.0 - Math.abs(lat) < 0.001) {
            return new Point2D.Double(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
        }
        double lambdaRad = this.lonToLambdaRad(lon);
        double phiRad = Math.toRadians(lat);
        double emult = 1.0;
        if (this.ellipsoid_) {
            double sinPhi = Math.sin(phiRad);
            emult = (1.0 - this.eccen_ * sinPhi) / (1.0 + this.eccen_ * sinPhi);
            emult = Math.pow(emult, this.halfEccen_);
        }
        double x = lambdaRad;
        double y = Math.log(Math.tan(0.5 * (1.5707963267948966 + phiRad)) * emult);
        x *= this.rS_;
        y *= this.rS_;
        return new Point2D.Double(x += this.falseEasting_, y += this.falseNorthing_);
    }

    @Override
    public PointLL transformXY2LL(double x, double y) {
        double chiRad;
        double xx = x - this.falseEasting_;
        double yy = y - this.falseNorthing_;
        double lambdaRad = xx * this.oneOverRS_;
        double tt = Math.exp(yy * this.oneOverRS_);
        double twoAtanT = Math.atan(tt);
        double phiRad = chiRad = twoAtanT - 1.5707963267948966;
        if (this.ellipsoid_) {
            phiRad += this.eterm2_ * Math.sin(2.0 * chiRad) + this.eterm4_ * Math.sin(4.0 * chiRad) + this.eterm6_ * Math.sin(6.0 * chiRad);
        }
        return new PointLL(this.lambdaC_ + Math.toDegrees(lambdaRad), Math.toDegrees(phiRad));
    }

    @Override
    public LonLatEdges getLonLatEdges() {
        Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        logger.warn("Not yet implemented.");
        return null;
    }
}

